/*
 * Decompiled with CFR 0.152.
 */
package com.nilo.plaf.nimrod;

import com.nilo.plaf.nimrod.NimRODBorders;
import com.nilo.plaf.nimrod.NimRODLookAndFeel;
import com.nilo.plaf.nimrod.NimRODUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTextAreaUI;
import javax.swing.text.JTextComponent;

public class NimRODTextAreaUI
extends BasicTextAreaUI {
    private boolean rollover = false;
    private boolean focus = false;
    private MiTextML miTextML;

    public NimRODTextAreaUI(JComponent c) {
    }

    public static ComponentUI createUI(JComponent c) {
        return new NimRODTextAreaUI(c);
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.miTextML = new MiTextML();
        this.getComponent().addMouseListener(this.miTextML);
        this.getComponent().addFocusListener(this.miTextML);
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        this.getComponent().removeMouseListener(this.miTextML);
        this.getComponent().removeFocusListener(this.miTextML);
    }

    public boolean isFocus() {
        return this.focus;
    }

    public boolean isRollover() {
        return this.rollover;
    }

    @Override
    protected void paintBackground(Graphics g) {
        JTextComponent c = this.getComponent();
        Border bb = c.getBorder();
        if (bb != null && bb instanceof NimRODBorders.NimRODGenBorder) {
            g.setColor(this.getComponent().getBackground());
            Graphics2D g2d = (Graphics2D)g;
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.fillRoundRect(2, 2, c.getWidth() - 4, c.getHeight() - 4, 7, 7);
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_DEFAULT);
            if (c.isEnabled() && c.isEditable()) {
                if (this.focus) {
                    NimRODUtils.paintFocus(g, 1, 1, c.getWidth() - 2, c.getHeight() - 2, 2, 2, NimRODLookAndFeel.getFocusColor());
                } else if (this.rollover) {
                    NimRODUtils.paintFocus(g, 1, 1, c.getWidth() - 2, c.getHeight() - 2, 2, 2, NimRODUtils.getColorAlfa(NimRODLookAndFeel.getFocusColor(), 150));
                }
            }
        } else {
            super.paintBackground(g);
        }
    }

    @Override
    protected void paintSafely(Graphics g) {
        JTextComponent jTextComponent = this.getComponent();
        if (jTextComponent.isEditable()) {
            jTextComponent.setBackground(Color.WHITE);
            jTextComponent.setForeground(Color.DARK_GRAY);
            jTextComponent.setCaretColor(Color.BLACK);
        } else {
            jTextComponent.setBackground(Color.LIGHT_GRAY);
            jTextComponent.setForeground(Color.DARK_GRAY);
            jTextComponent.setCaretColor(Color.BLACK);
        }
        super.paintSafely(g);
    }

    class MiTextML
    extends MouseAdapter
    implements FocusListener {
        MiTextML() {
        }

        protected void refreshBorder() {
            if (NimRODTextAreaUI.this.getComponent().getParent() != null) {
                JTextComponent papi = NimRODTextAreaUI.this.getComponent();
                papi.getParent().repaint(((Component)papi).getX() - 5, ((Component)papi).getY() - 5, ((Component)papi).getWidth() + 10, ((Component)papi).getHeight() + 10);
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            NimRODTextAreaUI.this.rollover = false;
            this.refreshBorder();
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            NimRODTextAreaUI.this.rollover = true;
            this.refreshBorder();
        }

        @Override
        public void focusGained(FocusEvent e) {
            NimRODTextAreaUI.this.focus = true;
            this.refreshBorder();
        }

        @Override
        public void focusLost(FocusEvent e) {
            NimRODTextAreaUI.this.focus = false;
            this.refreshBorder();
        }
    }
}

