/*
 * Decompiled with CFR 0.152.
 */
package sun.security.rsa;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyRep;
import java.security.ProviderException;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import sun.security.rsa.RSAKeyFactory;
import sun.security.rsa.RSAUtil;
import sun.security.util.BitArray;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.x509.AlgorithmId;
import sun.security.x509.X509Key;

public final class RSAPublicKeyImpl
extends X509Key
implements RSAPublicKey {
    private static final long serialVersionUID = 2644735423591199609L;
    private static final BigInteger THREE = BigInteger.valueOf(3L);
    private BigInteger n;
    private BigInteger e;
    private transient RSAUtil.KeyType type;
    private AlgorithmParameterSpec keyParams;

    public static RSAPublicKey newKey(byte[] byArray) throws InvalidKeyException {
        return new RSAPublicKeyImpl(byArray);
    }

    public static RSAPublicKey newKey(RSAUtil.KeyType keyType, String string, byte[] byArray) throws InvalidKeyException {
        RSAPublicKeyImpl rSAPublicKeyImpl;
        switch (string) {
            case "X.509": {
                rSAPublicKeyImpl = new RSAPublicKeyImpl(byArray);
                RSAKeyFactory.checkKeyAlgo(rSAPublicKeyImpl, keyType.keyAlgo);
                break;
            }
            case "PKCS#1": {
                try {
                    BigInteger[] bigIntegerArray = RSAPublicKeyImpl.parseASN1(byArray);
                    rSAPublicKeyImpl = new RSAPublicKeyImpl(RSAUtil.createAlgorithmId(keyType, null), bigIntegerArray[0], bigIntegerArray[1]);
                    break;
                }
                catch (IOException iOException) {
                    throw new InvalidKeyException("Invalid PKCS#1 encoding", iOException);
                }
            }
            default: {
                throw new InvalidKeyException("Unsupported RSA PublicKey format: " + string);
            }
        }
        return rSAPublicKeyImpl;
    }

    public static RSAPublicKey newKey(RSAUtil.KeyType keyType, AlgorithmParameterSpec algorithmParameterSpec, BigInteger bigInteger, BigInteger bigInteger2) throws InvalidKeyException {
        AlgorithmId algorithmId = RSAUtil.createAlgorithmId(keyType, algorithmParameterSpec);
        return new RSAPublicKeyImpl(algorithmId, bigInteger, bigInteger2);
    }

    RSAPublicKeyImpl(AlgorithmId algorithmId, BigInteger bigInteger, BigInteger bigInteger2) throws InvalidKeyException {
        RSAKeyFactory.checkRSAProviderKeyLengths(bigInteger.bitLength(), bigInteger2);
        RSAPublicKeyImpl.checkExponentRange(bigInteger, bigInteger2);
        this.n = bigInteger;
        this.e = bigInteger2;
        this.algid = algorithmId;
        Object[] objectArray = RSAUtil.getTypeAndParamSpec(this.algid);
        this.type = (RSAUtil.KeyType)((Object)objectArray[0]);
        this.keyParams = (AlgorithmParameterSpec)objectArray[1];
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            derOutputStream.putInteger(bigInteger);
            derOutputStream.putInteger(bigInteger2);
            byte[] byArray = new DerValue(48, derOutputStream.toByteArray()).toByteArray();
            this.setKey(new BitArray(byArray.length * 8, byArray));
        }
        catch (IOException iOException) {
            throw new InvalidKeyException(iOException);
        }
    }

    private RSAPublicKeyImpl(byte[] byArray) throws InvalidKeyException {
        if (byArray == null || byArray.length == 0) {
            throw new InvalidKeyException("Missing key encoding");
        }
        this.decode(byArray);
        RSAKeyFactory.checkRSAProviderKeyLengths(this.n.bitLength(), this.e);
        RSAPublicKeyImpl.checkExponentRange(this.n, this.e);
        try {
            Object[] objectArray = RSAUtil.getTypeAndParamSpec(this.algid);
            this.type = (RSAUtil.KeyType)((Object)objectArray[0]);
            this.keyParams = (AlgorithmParameterSpec)objectArray[1];
        }
        catch (ProviderException providerException) {
            throw new InvalidKeyException(providerException);
        }
    }

    static void checkExponentRange(BigInteger bigInteger, BigInteger bigInteger2) throws InvalidKeyException {
        if (bigInteger2.compareTo(bigInteger) >= 0) {
            throw new InvalidKeyException("exponent is larger than modulus");
        }
        if (bigInteger2.compareTo(THREE) < 0) {
            throw new InvalidKeyException("exponent is smaller than 3");
        }
    }

    @Override
    public String getAlgorithm() {
        return this.type.keyAlgo;
    }

    @Override
    public BigInteger getModulus() {
        return this.n;
    }

    @Override
    public BigInteger getPublicExponent() {
        return this.e;
    }

    @Override
    public AlgorithmParameterSpec getParams() {
        return this.keyParams;
    }

    private static BigInteger[] parseASN1(byte[] byArray) throws IOException {
        DerValue derValue = new DerValue(byArray);
        if (derValue.tag != 48) {
            throw new IOException("Not a SEQUENCE");
        }
        BigInteger[] bigIntegerArray = new BigInteger[]{derValue.data.getPositiveBigInteger(), derValue.data.getPositiveBigInteger()};
        if (derValue.data.available() != 0) {
            throw new IOException("Extra data available");
        }
        return bigIntegerArray;
    }

    @Override
    protected void parseKeyBits() throws InvalidKeyException {
        try {
            BigInteger[] bigIntegerArray = RSAPublicKeyImpl.parseASN1(this.getKey().toByteArray());
            this.n = bigIntegerArray[0];
            this.e = bigIntegerArray[1];
        }
        catch (IOException iOException) {
            throw new InvalidKeyException("Invalid RSA public key", iOException);
        }
    }

    @Override
    public String toString() {
        return "Sun " + this.type.keyAlgo + " public key, " + this.n.bitLength() + " bits\n  params: " + this.keyParams + "\n  modulus: " + this.n + "\n  public exponent: " + this.e;
    }

    private Object writeReplace() throws ObjectStreamException {
        return new KeyRep(KeyRep.Type.PUBLIC, this.getAlgorithm(), this.getFormat(), this.getEncoded());
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        throw new InvalidObjectException("RSAPublicKeyImpl keys are not directly deserializable");
    }
}

