/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www;

import java.util.Iterator;

public class HeaderParser {
    String raw;
    String[][] tab;
    int nkeys;
    int asize = 10;

    public HeaderParser(String string) {
        this.raw = string;
        this.tab = new String[this.asize][2];
        this.parse();
    }

    private HeaderParser() {
    }

    public HeaderParser subsequence(int n, int n2) {
        if (n == 0 && n2 == this.nkeys) {
            return this;
        }
        if (n < 0 || n >= n2 || n2 > this.nkeys) {
            throw new IllegalArgumentException("invalid start or end");
        }
        HeaderParser headerParser = new HeaderParser();
        headerParser.tab = new String[this.asize][2];
        headerParser.asize = this.asize;
        System.arraycopy(this.tab, n, headerParser.tab, 0, n2 - n);
        headerParser.nkeys = n2 - n;
        return headerParser;
    }

    private void parse() {
        if (this.raw != null) {
            this.raw = this.raw.trim();
            char[] cArray = this.raw.toCharArray();
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            boolean bl = true;
            boolean bl2 = false;
            int n4 = cArray.length;
            while (n2 < n4) {
                char c = cArray[n2];
                if (c == '=' && !bl2) {
                    this.tab[n3][0] = new String(cArray, n, n2 - n).toLowerCase();
                    bl = false;
                    n = ++n2;
                } else if (c == '\"') {
                    if (bl2) {
                        this.tab[n3++][1] = new String(cArray, n, n2 - n);
                        bl2 = false;
                        while (++n2 < n4 && (cArray[n2] == ' ' || cArray[n2] == ',')) {
                        }
                        bl = true;
                        n = n2;
                    } else {
                        bl2 = true;
                        n = ++n2;
                    }
                } else if (c == ' ' || c == ',') {
                    if (bl2) {
                        ++n2;
                        continue;
                    }
                    if (bl) {
                        this.tab[n3++][0] = new String(cArray, n, n2 - n).toLowerCase();
                    } else {
                        this.tab[n3++][1] = new String(cArray, n, n2 - n);
                    }
                    while (n2 < n4 && (cArray[n2] == ' ' || cArray[n2] == ',')) {
                        ++n2;
                    }
                    bl = true;
                    n = n2;
                } else {
                    ++n2;
                }
                if (n3 != this.asize) continue;
                this.asize *= 2;
                String[][] stringArray = new String[this.asize][2];
                System.arraycopy(this.tab, 0, stringArray, 0, this.tab.length);
                this.tab = stringArray;
            }
            if (--n2 > n) {
                if (!bl) {
                    this.tab[n3++][1] = cArray[n2] == '\"' ? new String(cArray, n, n2 - n) : new String(cArray, n, n2 - n + 1);
                } else {
                    this.tab[n3++][0] = new String(cArray, n, n2 - n + 1).toLowerCase();
                }
            } else if (n2 == n) {
                if (!bl) {
                    this.tab[n3++][1] = cArray[n2] == '\"' ? String.valueOf(cArray[n2 - 1]) : String.valueOf(cArray[n2]);
                } else {
                    this.tab[n3++][0] = String.valueOf(cArray[n2]).toLowerCase();
                }
            }
            this.nkeys = n3;
        }
    }

    public String findKey(int n) {
        if (n < 0 || n > this.asize) {
            return null;
        }
        return this.tab[n][0];
    }

    public String findValue(int n) {
        if (n < 0 || n > this.asize) {
            return null;
        }
        return this.tab[n][1];
    }

    public String findValue(String string) {
        return this.findValue(string, null);
    }

    public String findValue(String string, String string2) {
        if (string == null) {
            return string2;
        }
        string = string.toLowerCase();
        for (int i = 0; i < this.asize; ++i) {
            if (this.tab[i][0] == null) {
                return string2;
            }
            if (!string.equals(this.tab[i][0])) continue;
            return this.tab[i][1];
        }
        return string2;
    }

    public Iterator<String> keys() {
        return new ParserIterator(false);
    }

    public Iterator<String> values() {
        return new ParserIterator(true);
    }

    public String toString() {
        Iterator<String> iterator = this.keys();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{size=" + this.asize + " nkeys=" + this.nkeys + " ");
        int n = 0;
        while (iterator.hasNext()) {
            String string = iterator.next();
            String string2 = this.findValue(n);
            if (string2 != null && string2.isEmpty()) {
                string2 = null;
            }
            stringBuffer.append(" {" + string + (string2 == null ? "" : "," + string2) + "}");
            if (iterator.hasNext()) {
                stringBuffer.append(",");
            }
            ++n;
        }
        stringBuffer.append(" }");
        return new String(stringBuffer);
    }

    public int findInt(String string, int n) {
        try {
            return Integer.parseInt(this.findValue(string, String.valueOf(n)));
        }
        catch (Throwable throwable) {
            return n;
        }
    }

    class ParserIterator
    implements Iterator<String> {
        int index;
        boolean returnsValue;

        ParserIterator(boolean bl) {
            this.returnsValue = bl;
        }

        @Override
        public boolean hasNext() {
            return this.index < HeaderParser.this.nkeys;
        }

        @Override
        public String next() {
            return HeaderParser.this.tab[this.index++][this.returnsValue ? 1 : 0];
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove not supported");
        }
    }
}

