/*
 * Decompiled with CFR 0.152.
 */
package nlc.module.apcm.fx;

import ext.base.core.BcBooleanUtil;
import ext.base.core.BcNumberUtil;
import ext.base.core.BcStringUtil;
import ext.base.mmd.MmdField;
import ext.base.mmd.MmdUtil;
import ext.base.reflect.BcReflectUtil;
import ext.base.util.BcISO;
import ext.lib.datasource.util.DtsWordManager;
import ext.lib.fx.control.FxTextField;
import ext.lib.orm.entity.OrmPersistenceEntity;
import ext.lib.orm.entity.OrmPersistenceField;
import ext.lib.orm.persistence.OrmPersistenceUtil;
import java.lang.reflect.Field;
import nlc.module.apcm.model.ApcmFieldAnnotation;
import nlc.module.apcm.model.ApcmFieldInput;

public final class Y_ApcmFxUtil3 {
    private Y_ApcmFxUtil3() {
    }

    public static MmdField createMmd(Field field, OrmPersistenceEntity persistenceEntity, DtsWordManager wordManager) throws Exception {
        MmdField mmdField = MmdUtil.createMmdField(field);
        String tableName = null;
        if (persistenceEntity != null) {
            tableName = persistenceEntity.tableName();
        }
        OrmPersistenceField persistenceField = field.getAnnotation(OrmPersistenceField.class);
        ApcmFieldAnnotation fieldAnnotation = field.getAnnotation(ApcmFieldAnnotation.class);
        ApcmFieldInput fieldInput = field.getAnnotation(ApcmFieldInput.class);
        if (fieldAnnotation != null) {
            mmdField.displayName = fieldAnnotation.name();
            mmdField.columnCount = mmdField.dataSize = BcNumberUtil.parseInteger(fieldAnnotation.dataSize(), -1).intValue();
            mmdField.renderingConverterClassName = fieldAnnotation.converter();
        }
        if (BcStringUtil.isEmpty(mmdField.displayName) && wordManager != null) {
            mmdField.wordCode = OrmPersistenceUtil.toColumnName(persistenceEntity, field, null);
            mmdField.displayName = wordManager.getWord(mmdField.wordCode, BcISO.ISO_639.Japanese.code);
        }
        if (fieldInput != null) {
            mmdField.inputType = fieldInput.inputType();
            mmdField.readonly = BcBooleanUtil.parseBoolean(fieldInput.readonly());
            mmdField.required = BcBooleanUtil.parseBoolean(fieldInput.required());
            mmdField.inputPattern = fieldInput.pattern();
            mmdField.isFullWidth = BcBooleanUtil.parseBoolean(fieldInput.fullWidth());
            mmdField.columnCount = BcNumberUtil.parseInteger(fieldInput.columnCount(), -1);
            mmdField.rowCount = BcNumberUtil.parseInteger(fieldInput.rowCount(), -1);
            mmdField.placeholder = fieldInput.placeholder();
            mmdField.inputDescription = fieldInput.inputDescription();
            mmdField.iconName = fieldInput.iconName();
            mmdField.submitDisabled = BcBooleanUtil.parseBoolean(fieldInput.submitDisabled());
            mmdField.autocomplete = fieldInput.autocomplete();
            mmdField.characterCounter = BcBooleanUtil.parseBoolean(fieldInput.characterCounter());
            mmdField.enabled = BcBooleanUtil.parseBoolean(fieldInput.enabled());
            mmdField.options = fieldInput.option();
        }
        if (mmdField.columnCount <= 0) {
            mmdField.columnCount = mmdField.dataSize > 0 ? mmdField.dataSize : (Number.class.isAssignableFrom(mmdField.dataClass) ? Y_ApcmFxUtil3.getTextLength(mmdField.dataClass) : 20);
        }
        return mmdField;
    }

    public static MmdField createMmdField(Class entityClass, String fieldName) throws Exception {
        Field field = BcReflectUtil.getField(entityClass, fieldName);
        if (field == null) {
            String msg = "\u30d5\u30a3\u30fc\u30eb\u30c9\u540d '" + fieldName + "' \u306f\u5b58\u5728\u3057\u307e\u305b\u3093\u3002\u30af\u30e9\u30b9=" + entityClass.getName();
            throw new Exception(msg);
        }
        OrmPersistenceEntity persistenceEntity = entityClass.getAnnotation(OrmPersistenceEntity.class);
        return Y_ApcmFxUtil3.createMmd(field, persistenceEntity, null);
    }

    public static int getTextLength(Class clazz) throws Exception {
        int textLength = -1;
        if (Long.class.isAssignableFrom(clazz) || Long.TYPE.isAssignableFrom(clazz)) {
            textLength = 24;
        } else if (Integer.class.isAssignableFrom(clazz) || Integer.TYPE.isAssignableFrom(clazz)) {
            textLength = 16;
        } else if (Short.class.isAssignableFrom(clazz) || Short.TYPE.isAssignableFrom(clazz)) {
            textLength = 8;
        } else if (Byte.class.isAssignableFrom(clazz) || Byte.TYPE.isAssignableFrom(clazz)) {
            textLength = 4;
        }
        return textLength;
    }

    public static void setAttribute(Class entityClass, String fieldName, FxTextField textField) throws Exception {
        MmdField mmdField = Y_ApcmFxUtil3.createMmdField(entityClass, fieldName);
        textField.setPrefColumnCount(mmdField.columnCount);
        textField.setMaxLength(mmdField.columnCount);
        textField.setFullWidth(mmdField.isFullWidth);
    }
}

