/*
 * Decompiled with CFR 0.152.
 */
package ext.scf4.swg;

import ext.appfw.common.AfbApplication;
import ext.base.core.BcNumberUtil;
import ext.base.log.BcLogUtil;
import ext.base.mmd.MmdField;
import ext.base.table.BcTableColumn;
import ext.base.table.BcTableColumnModel;
import ext.base.table.BcTableUtil;
import ext.base.util.BcSortUtil;
import ext.base.xml.BcXmlUtil;
import ext.lib.html.util.HtmlToPlain;
import ext.lib.swg.SwgTableView;
import ext.scf4.table.ScfColumnContext;
import ext.scf4.table.ScfDisplayContext;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.table.TableColumnModel;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class HswgTableDisplayUtil {
    static HtmlToPlain htmlToPlain = new HtmlToPlain();
    public static final String TAG_visual = "visual";
    public static final String TAG_table = "table";
    public static final String TAG_columns = "columns";
    public static final String TAG_column = "column";

    private HswgTableDisplayUtil() {
    }

    public static int toVisibleInt(boolean visible) {
        if (visible) {
            return ScfColumnContext.VISIBLE_true;
        }
        return ScfColumnContext.VISIBLE_false;
    }

    public static boolean toVisible(int visibleInt) {
        return visibleInt == ScfColumnContext.VISIBLE_true;
    }

    protected static ScfColumnContext createContext(BcTableColumn tableColumn, int viewIndex) throws Exception {
        MmdField mmdField = tableColumn.getMmdField();
        ScfColumnContext columnContext = new ScfColumnContext();
        columnContext.tableColumnName = mmdField.tableColumnName;
        columnContext.index = viewIndex;
        columnContext.headerValue = htmlToPlain.toPlain(tableColumn.getHeaderValue().toString());
        columnContext.visible = HswgTableDisplayUtil.toVisibleInt(tableColumn.getVisible());
        return columnContext;
    }

    public static List<ScfColumnContext> createColumnContextList(TableColumnModel tableColumnModel) throws Exception {
        ArrayList<ScfColumnContext> columnContextList = new ArrayList<ScfColumnContext>();
        int i = 0;
        while (i < tableColumnModel.getColumnCount()) {
            BcTableColumn tableColumn = (BcTableColumn)tableColumnModel.getColumn(i);
            ScfColumnContext columnContext = HswgTableDisplayUtil.createContext(tableColumn, i);
            columnContextList.add(columnContext);
            ++i;
        }
        return columnContextList;
    }

    public static Map<String, ScfColumnContext> toMap(List<ScfColumnContext> columnContextList) throws Exception {
        HashMap<String, ScfColumnContext> columnContextMap = new HashMap<String, ScfColumnContext>();
        int i = 0;
        while (i < columnContextList.size()) {
            ScfColumnContext columnContext = columnContextList.get(i);
            columnContextMap.put(columnContext.tableColumnName, columnContext);
            ++i;
        }
        return columnContextMap;
    }

    public static List<ScfColumnContext> toList(Map<String, ScfColumnContext> columnContextMap) throws Exception {
        List columnContextList = BcSortUtil.sort(columnContextMap.values(), true, "index", "headerValue");
        return columnContextList;
    }

    public static Document createXml(ScfDisplayContext displayContext) throws Exception {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document xmlDoc = documentBuilder.newDocument();
        Element docElem = xmlDoc.createElement(TAG_visual);
        xmlDoc.appendChild(docElem);
        Element tableElem = xmlDoc.createElement(TAG_table);
        docElem.appendChild(tableElem);
        Element columnsElem = xmlDoc.createElement(TAG_columns);
        tableElem.appendChild(columnsElem);
        List columnContextList = BcSortUtil.sort(displayContext.columnContextMap.values(), true, "index");
        int i = 0;
        while (i < columnContextList.size()) {
            ScfColumnContext columnContext = (ScfColumnContext)columnContextList.get(i);
            HswgTableDisplayUtil.createColumnNode(xmlDoc, columnsElem, columnContext);
            ++i;
        }
        return xmlDoc;
    }

    protected static void createColumnNode(Document xmlDoc, Element columnsElem, ScfColumnContext columnContext) throws Exception {
        Element columnElement = xmlDoc.createElement(TAG_column);
        columnElement.setAttribute("index", Integer.toString(columnContext.index));
        columnElement.setAttribute("name", columnContext.tableColumnName);
        columnElement.setAttribute("visible", Integer.toString(columnContext.visible));
        columnsElem.appendChild(columnElement);
    }

    public static ScfDisplayContext parseXml(File xmlFile) throws Exception {
        ScfDisplayContext tavleViewContext = new ScfDisplayContext();
        BcLogUtil.info("parseXml:xmlFile=" + xmlFile.getPath());
        Document xmlDoc = BcXmlUtil.createDocument(xmlFile);
        Element docElem = xmlDoc.getDocumentElement();
        HswgTableDisplayUtil.parseXml(xmlDoc, tavleViewContext);
        return tavleViewContext;
    }

    public static void parseXml(Document xmlDoc, ScfDisplayContext displayContext) throws Exception {
        displayContext.columnContextMap = new HashMap<String, ScfColumnContext>();
        List<Node> domNodeList = BcXmlUtil.getNodeList((Node)xmlDoc, (short)1);
        int i = 0;
        while (i < domNodeList.size()) {
            Node domNode = domNodeList.get(i);
            if (domNode.getNodeName().equals(TAG_table)) {
                HswgTableDisplayUtil.parseTableNode(domNode, displayContext);
            } else {
                BcLogUtil.warning("Not Supported Tag. '" + domNode.getNodeName() + "'");
            }
            ++i;
        }
    }

    public static void parseTableNode(Node tableNode, ScfDisplayContext displayContext) throws Exception {
        displayContext.columnContextMap = new HashMap<String, ScfColumnContext>();
        List<Node> domNodeList = BcXmlUtil.getNodeList(tableNode, (short)1);
        int i = 0;
        while (i < domNodeList.size()) {
            Node domNode = domNodeList.get(i);
            if (domNode.getNodeName().equals(TAG_columns)) {
                HswgTableDisplayUtil.parseColumnsNode(domNode, displayContext);
            } else {
                BcLogUtil.warning("Not Supported Tag. '" + domNode.getNodeName() + "'");
            }
            ++i;
        }
    }

    public static void parseColumnsNode(Node columnsNode, ScfDisplayContext displayContext) throws Exception {
        displayContext.columnContextMap = new HashMap<String, ScfColumnContext>();
        List<Node> domNodeList = BcXmlUtil.getNodeList(columnsNode, (short)1);
        int i = 0;
        while (i < domNodeList.size()) {
            Node domNode1 = domNodeList.get(i);
            if (!domNode1.getNodeName().equals(TAG_column)) {
                throw new Exception("not suported node '" + domNode1.getNodeName() + "'");
            }
            ScfColumnContext columnContext = HswgTableDisplayUtil.parseColumnNode(domNode1);
            displayContext.columnContextMap.put(columnContext.tableColumnName, columnContext);
            ++i;
        }
    }

    protected static ScfColumnContext parseColumnNode(Node columnNode) throws Exception {
        ScfColumnContext columnContext = new ScfColumnContext();
        columnContext.tableColumnName = BcXmlUtil.getAttribute(columnNode, "name");
        String tmpStr = BcXmlUtil.getAttribute(columnNode, "index");
        columnContext.index = BcNumberUtil.parseInt(tmpStr, -1);
        tmpStr = BcXmlUtil.getAttribute(columnNode, "visible");
        columnContext.visible = BcNumberUtil.parseInt(tmpStr, -1);
        return columnContext;
    }

    public static void applyDisplayContext(SwgTableView tableView, ScfDisplayContext displayContext) throws Exception {
        BcTableColumnModel tableColumnModel = (BcTableColumnModel)tableView.getColumnModel();
        List<ScfColumnContext> columnContextList = HswgTableDisplayUtil.toList(displayContext.columnContextMap);
        int tmpIndex = -1;
        int i = 0;
        while (i < columnContextList.size()) {
            ScfColumnContext columnContext = columnContextList.get(i);
            BcTableColumn tableColumn = tableColumnModel.getColumn(columnContext.tableColumnName);
            if (tableColumn == null) {
                BcLogUtil.debug("\u5217 '" + columnContext.tableColumnName + "' \u306f\u5b58\u5728\u3057\u307e\u305b\u3093\u3002");
            } else {
                int viewIndex1 = BcTableUtil.getColumnIndex(tableColumnModel, tableColumn);
                int viewIndex2 = -1;
                viewIndex2 = columnContext.index >= 0 ? ++tmpIndex : tableColumnModel.getColumnCount() - 1;
                if (viewIndex1 != viewIndex2) {
                    tableColumnModel.moveColumn(viewIndex1, viewIndex2);
                }
                if (columnContext.visible == ScfColumnContext.VISIBLE_true) {
                    tableColumn.setVisible(true);
                } else if (columnContext.visible == ScfColumnContext.VISIBLE_false) {
                    tableColumn.setVisible(false);
                }
            }
            ++i;
        }
    }

    public static File findXmlFile(String targetName) throws Exception {
        File dir = HswgTableDisplayUtil.getBaseDir();
        File xmlFile = new File(dir, String.valueOf(targetName) + BcXmlUtil.EXTENTION_dot_xml);
        return xmlFile;
    }

    public static File toOrginFile(String targetName) throws Exception {
        File dir = HswgTableDisplayUtil.getBaseDir();
        File xmlFile = new File(dir, String.valueOf(targetName) + "_origin" + BcXmlUtil.EXTENTION_dot_xml);
        return xmlFile;
    }

    public static File getBaseDir() throws Exception {
        File dir = new File(AfbApplication.getInstance().toReal("${APP}visual/"));
        return dir;
    }

    public static void save(String targetName, ScfDisplayContext displayContext, ScfDisplayContext displayContextOrigin) throws Exception {
        Document xmlDoc = HswgTableDisplayUtil.createXml(displayContext);
        File xmlFile = HswgTableDisplayUtil.findXmlFile(targetName);
        BcXmlUtil.output(xmlDoc, xmlFile, true);
        if (displayContextOrigin != null) {
            Document xmlDocOrgin = HswgTableDisplayUtil.createXml(displayContextOrigin);
            File orginFile = HswgTableDisplayUtil.toOrginFile(targetName);
            BcXmlUtil.output(xmlDocOrgin, orginFile, true);
        }
    }
}

