/*
 * Decompiled with CFR 0.152.
 */
package ext.module.xfil.swg;

import ext.base.core.BcTimeUtil;
import ext.base.log.BcLogUtil;
import ext.lib.swg.SwgTableCellRenderer;
import java.awt.Component;
import java.io.Serializable;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

class XfilTableCellRendererDuration
extends SwgTableCellRenderer
implements TableCellRenderer,
Serializable {
    @Override
    public Component getTableCellRendererComponent(JTable tableView, Object value, boolean isSelected, boolean hasFocus, int rowId, int columnId) {
        Component component = null;
        try {
            component = this.getComponent(tableView, value, isSelected, hasFocus, rowId, columnId);
        }
        catch (Exception ex) {
            BcLogUtil.error(ex);
        }
        return component;
    }

    protected Component getComponent(JTable tableView, Object value, boolean isSelected, boolean hasFocus, int rowId, int columnId) throws Exception {
        Component component = null;
        if (value instanceof Number) {
            Number number = (Number)value;
            if (number.longValue() >= 0L) {
                BcTimeUtil.TimeStructure timeStructure = BcTimeUtil.toTimeStructure(number.longValue());
                String duration = BcTimeUtil.toDurationString(timeStructure, false);
                component = super.getTableCellRendererComponent(tableView, duration, isSelected, hasFocus, rowId, columnId);
            } else {
                component = super.getTableCellRendererComponent(tableView, number.longValue(), isSelected, hasFocus, rowId, columnId);
            }
        }
        return component;
    }
}

