/*
 * Decompiled with CFR 0.152.
 */
package ext.module.xfil.swg;

import ext.base.table.BcTableColumn;
import ext.base.table.BcTableModel;
import ext.base.util.BcResult;
import ext.base.util.BcWords;
import ext.lib.awt.AwtImageHelper;
import ext.lib.fx.layout.FxFlowPane;
import ext.lib.fx.util.FxUtil;
import ext.lib.rmi.model.RmiRequest;
import ext.lib.swg.SwgButton;
import ext.lib.swg.SwgOptionPane;
import ext.lib.swg.SwgTableView;
import ext.lib.swg.SwgTableViewUtil;
import ext.lib.swg.SwgUtil;
import ext.module.xfil.common.XfilConstants;
import ext.module.xfil.common.XfilUtil;
import ext.module.xfil.common.XfilWords;
import ext.module.xfil.fx.XfilConditionSet;
import ext.module.xfil.fx.XfilFxHelper;
import ext.module.xfil.model.XfilAnalysisCondition;
import ext.module.xfil.rmo.XfilFileListRMO;
import ext.module.xfil.swg.XfilTableCellRendererDuration;
import ext.module.xfil.swg.XfilTableCellRendererFileSize;
import ext.module.xfil.swg.XfilTableCellRendererThumbnail;
import ext.scf5.swg.IswgAbstractDataViewPanel;
import ext.scf5.swg.IswgLoadableTablePanel;
import ext.scf6.swg.JswgAbstractDataViewPanel_FxCondition;
import java.awt.Desktop;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.List;
import javafx.scene.Node;
import javafx.scene.Parent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class XfilFileIndexListPanel
extends JswgAbstractDataViewPanel_FxCondition {
    private static final long serialVersionUID = 5567181320277829613L;
    XfilAnalysisCondition analysisCondition;

    public XfilFileIndexListPanel() throws Exception {
        super(IswgAbstractDataViewPanel.DataViewStyle.Default);
        Parent conditionNode = this.createConditionNode(-1, null);
        this.setConditionNode(conditionNode);
    }

    @Override
    public String getTitle() throws Exception {
        return XfilWords.getInstance().FileList.toPlain();
    }

    @Override
    protected Parent createConditionNode(int tabIndex, Node preConditionNode) throws Exception {
        InnerConditionPane conditionPane = new InnerConditionPane();
        XfilConditionSet conditionSet = conditionPane.conditionSet;
        conditionPane.addNodeUnit(conditionSet.crawlUnit);
        conditionPane.addNodeUnit(conditionSet.fileNameUnit);
        conditionPane.addNodeUnit(conditionSet.fileCheckBoxUnit);
        conditionPane.addNodeUnit(conditionSet.directoryCheckBoxUnit);
        conditionPane.addNodeUnit(conditionSet.fileExtentionUnit);
        conditionPane.addNodeUnit(conditionSet.fileCreationPeriodUnit);
        conditionPane.addNodeUnit(conditionSet.fileModifiedPeriodUnit);
        conditionPane.addNodeUnit(conditionSet.missingIncludeCheckBoxUnit);
        conditionPane.addNodeUnit(conditionSet.tagUnit);
        if (preConditionNode != null) {
            InnerConditionPane preConditionPane = (InnerConditionPane)preConditionNode;
            conditionSet.setConditionSet(preConditionPane.conditionSet);
        }
        FxUtil.defaultInitialize((Node)conditionPane);
        return conditionPane;
    }

    @Override
    protected BcResult validateCondition() throws Exception {
        InnerConditionPane conditionPane = (InnerConditionPane)this.getConditionNode();
        this.analysisCondition = conditionPane.conditionSet.getCondition();
        BcResult result = new BcResult();
        return result;
    }

    @Override
    protected RmiRequest createRequest() throws Exception {
        RmiRequest rmiReq = new RmiRequest();
        rmiReq.setClassName(XfilFileListRMO.class.getName());
        rmiReq.setMethodName(XfilFileListRMO.Method.fileList.getMethodName());
        rmiReq.addData(this.analysisCondition);
        return rmiReq;
    }

    @Override
    public IswgLoadableTablePanel createTablePanel() throws Exception {
        InnerTablePanel tablePanel = new InnerTablePanel();
        return tablePanel;
    }

    @Override
    public int getDividerLocation() throws Exception {
        return 180;
    }

    @Override
    protected Image getIconImage() throws Exception {
        return AwtImageHelper.getImage("table_view_64x64.png");
    }

    public void setCrawlSessionId(long crawId) throws Exception {
        InnerConditionPane conditionPane = (InnerConditionPane)this.getConditionNode();
        XfilConditionSet conditionSet = conditionPane.conditionSet;
        conditionSet.setCrawlId(crawId);
    }

    class InnerConditionPane
    extends FxFlowPane {
        XfilConditionSet conditionSet;

        public InnerConditionPane() throws Exception {
            super(11);
            this.conditionSet = new XfilConditionSet();
            this.conditionSet.fileCheckBox.setSelected(true);
            this.conditionSet.setupCrawlComboBox(true, null);
        }
    }

    class InnerTablePanel
    extends IswgLoadableTablePanel {
        List<List> rowList;
        Number entityId;
        int columnId_entityId;
        int columnId_thumbnail_files;
        XfilTableCellRendererThumbnail tableCellRendererThumbnail;
        SwgButton openFileButton;
        SwgButton openDirectoryButton;
        SwgButton openThumbnailDirectoryButton;
        SwgButton editButton;

        public InnerTablePanel() throws Exception {
            this.setVisualSaveEnavled(true);
            this.openFileButton = SwgUtil.cretaeOpenButton(BcWords.getInstance().openFile, null);
            this.openFileButton.addActionListener(this.actionListener);
            this.openFileButton.setEnabled(false);
            this.tableControlPanel.addControl3(this.openFileButton);
            this.openDirectoryButton = SwgUtil.cretaeOpenDirectoryButton();
            this.openDirectoryButton.addActionListener(this.actionListener);
            this.openDirectoryButton.setEnabled(false);
            this.tableControlPanel.addControl3(this.openDirectoryButton);
            this.openThumbnailDirectoryButton = SwgUtil.cretaeOpenDirectoryButton(XfilWords.getInstance().\u30b5\u30e0\u30cd\u30a4\u30eb\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u3092\u958b\u304f, null);
            this.openThumbnailDirectoryButton.addActionListener(this.actionListener);
            this.openThumbnailDirectoryButton.setEnabled(false);
            this.tableControlPanel.addControl3(this.openThumbnailDirectoryButton);
            this.editButton = SwgUtil.cretaeOpenDirectoryButton("Edit", null);
            this.editButton.addActionListener(this.actionListener);
            this.editButton.setEnabled(false);
            this.tableControlPanel.addControl3(this.editButton);
        }

        @Override
        public void tableModelCreated(BcTableModel tableModel) throws Exception {
            this.columnId_entityId = tableModel.getTableColumnModel().getIndexByTableColumnName(XfilConstants.xfil_entity.id.fullName());
            this.columnId_thumbnail_files = tableModel.getTableColumnModel().getIndexByTableColumnName(XfilConstants.xfil_entity.thumbnail_files.fullName());
            BcTableColumn tableColumn = tableModel.getTableColumnModel().getColumn(XfilConstants.xfil_entity.size_.fullName());
            XfilTableCellRendererFileSize tableCellRendererFileSize = new XfilTableCellRendererFileSize();
            tableColumn.setCellRenderer(tableCellRendererFileSize);
            tableColumn = tableModel.getTableColumnModel().getColumn(XfilConstants.xfil_entity.duration_millis.fullName());
            XfilTableCellRendererDuration tableCellRendererDuration = new XfilTableCellRendererDuration();
            tableColumn.setCellRenderer(tableCellRendererDuration);
            tableColumn = (BcTableColumn)tableModel.getTableColumnModel().getColumn(this.columnId_thumbnail_files);
            this.tableCellRendererThumbnail = new XfilTableCellRendererThumbnail(this.columnId_entityId);
            tableColumn.setCellRenderer(this.tableCellRendererThumbnail);
            super.tableModelCreated(tableModel);
        }

        @Override
        protected SwgTableView createTableView(BcTableModel tableModel) throws Exception {
            InnerTableView tableView = new InnerTableView(tableModel, tableModel.getTableColumnModel());
            SwgTableViewUtil.setHeaderRowCount(tableView, 3);
            tableView.setRowHeight(SwgTableViewUtil.ROW_HEIGHT * 3);
            tableView.columnId_thumbnail_files = this.columnId_thumbnail_files;
            tableView.tableCellRendererThumbnail = this.tableCellRendererThumbnail;
            return tableView;
        }

        @Override
        protected void tableSelectionChanged(ListSelectionEvent ev) throws Exception {
            super.tableSelectionChanged(ev);
            if (!ev.getValueIsAdjusting()) {
                SwgTableView tableView = this.getTableView();
                if (tableView.getSelectedRows().length > 0) {
                    this.rowList = SwgTableViewUtil.getRowList(tableView, tableView.getSelectedRows(), XfilConstants.xfil_entity.id.fullName(), XfilConstants.xfil_entity.crawl_id.fullName(), XfilConstants.xfil_entity.directory_.fullName(), XfilConstants.xfil_entity.name_.fullName());
                    this.entityId = (Number)this.rowList.get(0).get(0);
                    this.openFileButton.setEnabled(true);
                    this.openDirectoryButton.setEnabled(true);
                    this.openThumbnailDirectoryButton.setEnabled(true);
                    this.editButton.setEnabled(true);
                } else {
                    this.openFileButton.setEnabled(false);
                    this.openDirectoryButton.setEnabled(false);
                    this.openThumbnailDirectoryButton.setEnabled(false);
                    this.editButton.setEnabled(false);
                }
            }
        }

        @Override
        protected void tableMouseClicked(MouseEvent ev) throws Exception {
            super.tableMouseClicked(ev);
            if (ev.getClickCount() != 2) {
                return;
            }
        }

        @Override
        protected void actionPerformed2(ActionEvent ev) throws Exception {
            super.actionPerformed2(ev);
            if (ev.getSource() == this.openFileButton || ev.getSource() == this.openDirectoryButton) {
                String directory = (String)this.rowList.get(0).get(2);
                String fileName = (String)this.rowList.get(0).get(3);
                boolean isFile = ev.getSource() == this.openFileButton;
                this.openFile(directory, fileName, isFile);
            } else if (ev.getSource() == this.openThumbnailDirectoryButton) {
                Long entityId = (Long)this.rowList.get(0).get(this.columnId_entityId);
                this.openThumbnailDirectory(entityId);
            } else if (ev.getSource() == this.editButton) {
                Long uriEntityId = (Long)this.rowList.get(0).get(0);
                XfilFxHelper.getInstance().openUriEntityPane(uriEntityId);
            }
        }

        protected void openFile(String directory, String fileName, boolean isFile) throws Exception {
            File dir = new File(directory);
            File file = new File(dir, fileName);
            if (isFile) {
                if (!file.exists()) {
                    BcWords.getInstance().fileNotExists(file.getPath());
                    String msg = BcWords.getInstance().fileNotExists(file.getPath());
                    SwgOptionPane.showMessageDialog(this, msg, BcWords.getInstance().error, 0);
                    return;
                }
                Desktop.getDesktop().open(file);
            } else {
                if (!file.getParentFile().exists()) {
                    BcWords.getInstance().fileNotExists(file.getParentFile().getPath());
                    String msg = BcWords.getInstance().fileNotExists(file.getPath());
                    SwgOptionPane.showMessageDialog(this, msg, BcWords.getInstance().error, 0);
                    return;
                }
                Desktop.getDesktop().open(file.getParentFile());
            }
        }

        protected void openThumbnailDirectory(long entityId) throws Exception {
            File dir = XfilUtil.getTthumbnailsDir(entityId);
            Desktop.getDesktop().open(dir);
        }
    }

    class InnerTableView
    extends SwgTableView {
        int columnId_thumbnail_files;
        XfilTableCellRendererThumbnail tableCellRendererThumbnail;
        BufferedImage bufferedImage1;

        public InnerTableView(TableModel tableModel, TableColumnModel tableColumnModel) throws Exception {
            super(tableModel, tableColumnModel);
            this.addMouseMotionListener(new MouseAdapter(){

                @Override
                public void mouseMoved(MouseEvent ev) {
                    InnerTableView.this.mouseMotionEvent(ev);
                }
            });
        }

        protected void mouseMotionEvent(MouseEvent ev) {
            try {
                switch (ev.getID()) {
                    case 503: {
                        this.mouseMoved(ev);
                    }
                }
            }
            catch (Exception ex) {
                this.exceptionHandle(ex);
            }
        }

        protected void mouseMoved(MouseEvent ev) throws Exception {
            Point point = ev.getPoint();
            int rowId = this.rowAtPoint(point);
            int columnId = this.columnAtPoint(point);
            if (columnId == this.columnId_thumbnail_files) {
                Rectangle cellRectangle = this.getCellRect(rowId, columnId, false);
                Object[] res = this.tableCellRendererThumbnail.getImage(this, rowId, point, cellRectangle);
                BufferedImage bufferedImage2 = null;
                Rectangle rectangle2 = null;
                if (res != null) {
                    bufferedImage2 = (BufferedImage)res[0];
                    rectangle2 = (Rectangle)res[1];
                }
                boolean b = false;
                if (bufferedImage2 != null) {
                    b = this.bufferedImage1 != null ? bufferedImage2.hashCode() != this.bufferedImage1.hashCode() : true;
                } else {
                    boolean bl = b = this.bufferedImage1 != null;
                }
                if (b) {
                    double ratio = 1.0;
                    Point2D.Double pointWk1 = null;
                    if (bufferedImage2 != null) {
                        pointWk1 = new Point2D.Double();
                        pointWk1.x = (double)rectangle2.x - ((double)bufferedImage2.getWidth() * ratio - rectangle2.getWidth()) / 2.0;
                        pointWk1.y = (double)rectangle2.y - (double)bufferedImage2.getHeight() * ratio - 2.0;
                    }
                    XfilFxHelper.getInstance().openImagePane(bufferedImage2, ratio, pointWk1);
                }
                this.bufferedImage1 = bufferedImage2;
            }
        }
    }
}

