/*
 * Decompiled with CFR 0.152.
 */
package ext.module.xfil.fx;

import ext.base.util.BcMessageCreator;
import ext.base.util.BcResult;
import ext.base.util.BcWords;
import ext.lib.fx.layout.FxDecoratePane;
import ext.lib.fx.layout.FxTitledPane;
import ext.lib.fx.scene.FxScene;
import ext.lib.fx.stage.FxStage;
import ext.lib.fx.util.FxImageHelper;
import ext.lib.fx.util.FxOptionPane;
import ext.lib.fx.util.FxUtil;
import ext.lib.rmi.model.RmiRequest;
import ext.lib.rmi.model.RmiRespons;
import ext.module.xfil.common.XfilWords;
import ext.module.xfil.fx.XfilCaptureIndicationPane;
import ext.module.xfil.fx.XfilCrawlConditionPane1;
import ext.module.xfil.model.XfilAnalysisCondition;
import ext.module.xfil.model.XfilVCaptureCondition;
import ext.module.xfil.rmo.XfilCrawlRMO;
import ext.scf.client.ScfClientContainer;
import ext.scf4.fx.HfxTaskMonitor;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.image.Image;
import javafx.scene.layout.VBox;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.stage.WindowEvent;

public class XfilCrawlIndicationPane
extends FxDecoratePane {
    Mode mode;
    XfilCrawlConditionPane1 crawlConditionPane1;
    XfilCaptureIndicationPane captureIndicationPane;
    Button executeButton;
    Button cancelButton;
    int wWidth = 980;
    int wHeight;
    String title;
    Image windowImage;
    Stage stage;

    public XfilCrawlIndicationPane(Mode mode) throws Exception {
        this.mode = mode;
        this.initComponent();
    }

    protected void initComponent() throws Exception {
        this.executeButton = FxUtil.createExecuteButton();
        this.executeButton.setOnAction(this.actionEventHandler);
        this.getControlPane().addControl((Node)this.executeButton);
        this.cancelButton = FxUtil.createCancelButton();
        this.cancelButton.setOnAction(this.actionEventHandler);
        this.getControlPane().addControl((Node)this.cancelButton);
        VBox vBox = new VBox();
        int height1 = 210;
        int height2 = 320;
        if (this.mode == Mode.fileCrawl) {
            this.crawlConditionPane1 = new XfilCrawlConditionPane1();
            this.crawlConditionPane1.setPrefHeight(height1);
            FxTitledPane titledPane1 = new FxTitledPane();
            titledPane1.setTitle(XfilWords.getInstance().FileCrawl.toPlain());
            titledPane1.setIconNode((Node)FxImageHelper.createImageView_icon("folder_view_64x64.png"));
            titledPane1.setContentNode((Node)this.crawlConditionPane1);
            vBox.getChildren().addAll((Object[])new Node[]{titledPane1});
            this.wHeight = height1 + height2 + 40;
            this.title = XfilWords.getInstance().FileCrawl.toPlain();
            this.windowImage = FxImageHelper.getImage("folder_view_64x64.png");
        } else if (this.mode == Mode.videoCapture) {
            this.wHeight = height2 + 250;
            this.title = XfilWords.getInstance().ScreenCapture.toPlain();
            this.windowImage = FxImageHelper.getImage("screenshot_64x64.png");
        }
        this.captureIndicationPane = new XfilCaptureIndicationPane(this);
        this.captureIndicationPane.setPrefHeight(height2);
        FxTitledPane titledPane2 = new FxTitledPane();
        titledPane2.setContentNode((Node)this.captureIndicationPane);
        if (this.mode != Mode.videoCapture) {
            titledPane2.setTitle(XfilWords.getInstance().ScreenCapture.toPlain());
            titledPane2.setIconNode((Node)FxImageHelper.createImageView_icon("screenshot_64x64.png"));
        }
        vBox.getChildren().addAll((Object[])new Node[]{titledPane2});
        this.setCenter((Node)vBox);
        this.setPadding(new Insets(8.0));
        FxUtil.defaultInitialize((Node)this);
    }

    @Override
    public void actionPerformed(ActionEvent ev) throws Exception {
        super.actionPerformed(ev);
        if (ev.getSource() == this.executeButton) {
            BcResult result = this.execute();
            if (result.hasError()) {
                String message = BcMessageCreator.getInstance().createMessage(result.getErrorList());
                FxOptionPane.showMessageDialog((Window)this.stage, (Object)message, BcWords.getInstance().error, 0);
                return;
            }
            HfxTaskMonitor.getInstance().show();
            this.close();
        } else if (ev.getSource() == this.cancelButton) {
            this.close();
        }
    }

    public BcResult execute() throws Exception {
        XfilAnalysisCondition analysisConditionA = null;
        XfilAnalysisCondition analysisConditionB = this.captureIndicationPane.getCondition();
        XfilVCaptureCondition captureCondition = this.captureIndicationPane.captureConditionPane.captureConditionSet.getCondition();
        if (this.crawlConditionPane1 != null) {
            analysisConditionA = this.crawlConditionPane1.getCondition();
            analysisConditionA.execute = true;
        } else {
            analysisConditionA = new XfilAnalysisCondition();
            analysisConditionB.execute = true;
        }
        RmiRequest rmiReq = new RmiRequest();
        rmiReq.setClassName(XfilCrawlRMO.class.getName());
        rmiReq.setMethodName(XfilCrawlRMO.Method.fileCrawl.getMethodName());
        rmiReq.addData(analysisConditionA);
        rmiReq.addData(analysisConditionB);
        rmiReq.addData(captureCondition);
        RmiRespons rmiRes = ScfClientContainer.getInstance().getAgent().invoke(rmiReq);
        BcResult result = (BcResult)rmiRes.getData();
        return result;
    }

    public void close() {
        this.stage.close();
    }

    public void show(Window ownerWindow) throws Exception {
        this.stage = new FxStage();
        if (ownerWindow != null) {
            this.stage.initModality(Modality.WINDOW_MODAL);
            this.stage.initOwner(ownerWindow);
        }
        this.stage.setOnShown((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent ev) {
            }
        });
        FxScene scene = new FxScene((Parent)this);
        this.stage.setScene((Scene)scene);
        this.stage.setWidth((double)this.wWidth);
        this.stage.setHeight((double)this.wHeight);
        this.stage.setResizable(false);
        this.stage.setTitle(this.title);
        this.stage.getIcons().add((Object)this.windowImage);
        this.stage.show();
    }

    public static enum Mode {
        fileCrawl,
        videoCapture;

    }
}

