/*
 * Decompiled with CFR 0.152.
 */
package ext.module.xdts.server;

import ext.base.core.BcNumberUtil;
import ext.base.util.BcResult;
import ext.lib.sql.SqlResultSet;
import ext.lib.sql.context.SqlContext;
import ext.lib.task.TskAbstractCallable;
import java.sql.ResultSet;
import java.sql.SQLException;

public abstract class XsysResultSetIterationTask
extends TskAbstractCallable<BcResult> {
    protected SqlResultSet rs;
    protected SqlContext sqlContext;

    public void setResultSet(SqlResultSet rs) throws SQLException {
        this.rs = rs;
        this.sqlContext = rs.getStatement().getSqlContext();
    }

    @Override
    public BcResult taskProcess() throws Exception {
        this.started();
        BcResult result = new BcResult();
        int rowNumber = 0;
        try {
            while (this.rs.next()) {
                if (++rowNumber % 1000 == 0) {
                    this.getLogger().info("Row Number=" + BcNumberUtil.toString(rowNumber));
                }
                this.selected(this.rs, rowNumber);
            }
        }
        finally {
            if (this.rs != null) {
                try {
                    this.rs.close();
                }
                catch (Exception ex) {
                    this.getLogger().error(ex);
                }
            }
        }
        this.getLogger().info("rowCount=" + rowNumber);
        this.finised(rowNumber);
        return result;
    }

    protected void started() throws Exception {
    }

    protected void selected(ResultSet rs, int rowNumber) throws Exception {
    }

    protected void finised(int rowNumber) throws Exception {
    }
}

