/*
 * Decompiled with CFR 0.152.
 */
package ext.module.xdts.fx;

import ext.base.core.BcBooleanUtil;
import ext.base.core.BcStringUtil;
import ext.base.core.BcTimeUtil;
import ext.base.event.BcEvent;
import ext.base.event.BcEventHandler;
import ext.base.log.BcLogUtil;
import ext.base.log.BcLoggableObject;
import ext.base.mmd.MmdIndex;
import ext.base.mmd.MmdModel;
import ext.base.mmd.MmdUtil;
import ext.base.table.BcTableModel;
import ext.base.table.BcTableUtil;
import ext.base.util.BcCollectionUtil;
import ext.base.util.BcCsvUtil;
import ext.lib.fx.control.FxButton;
import ext.lib.fx.control.FxCheckBox;
import ext.lib.fx.control.FxComboBox;
import ext.lib.fx.control.FxLabel;
import ext.lib.fx.control.FxTextArea;
import ext.lib.fx.control.FxTextField;
import ext.lib.fx.layout.FxNodeUnit;
import ext.lib.fx.scene.FxScene;
import ext.lib.fx.skin.FxCssUtil;
import ext.lib.fx.util.FxImageHelper;
import ext.lib.fx.util.FxUtil;
import ext.lib.sql.context.SqlContext;
import ext.lib.swg.SwgUtil;
import ext.libx.fx.FxxPeriodPane;
import ext.libx.fx.FxxRadioButtonControl;
import ext.module.xdts.common.EtcSqlConditionUtil;
import ext.module.xdts.common.XdtsConstants;
import ext.module.xdts.common.XdtsSqlParserUtil;
import ext.module.xdts.common.XdtsUtil;
import ext.module.xdts.common.XdtsWords;
import ext.module.xdts.fx.XdtsCheckBoxPane;
import ext.module.xdts.fx.XdtsControlOptionPane;
import ext.module.xdts.fx.XdtsControlUnit;
import ext.module.xdts.fx.XdtsExtractionConditionEditPane;
import ext.module.xdts.fx.XdtsFxCondition;
import ext.module.xdts.fx.XdtsSelectColumnPane;
import ext.module.xdts.fx.XdtsStagePane;
import ext.module.xdts.model.XdtsControlContext;
import ext.module.xdts.model.XdtsUserSetting;
import ext.module.xdts.model.v0001.XdtsExtractionCondition;
import ext.module.xdts.model.v0001.XdtsSelectColumn;
import ext.module.xdts.model.v0001.XdtsSelectContext;
import ext.module.xdts.model.v0001.XdtsSelectElemet;
import ext.module.xdts.swg.XdtsConditionTempPanel;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javafx.embed.swing.JFXPanel;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.ButtonBase;
import javafx.scene.control.Control;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.stage.Window;
import javax.swing.SwingUtilities;

public class XdtsConditionModelToFx
extends BcLoggableObject {
    protected EventHandler<ActionEvent> actionEventHandler = new EventHandler<ActionEvent>(){

        public void handle(ActionEvent ev) {
            try {
                if (ev.getSource() instanceof Node) {
                    Node node = (Node)ev.getSource();
                    XdtsControlUnit controlUnit = (XdtsControlUnit)node.getUserData();
                    XdtsConditionModelToFx.this.optionButtonAction(node, controlUnit);
                }
            }
            catch (Exception ex) {
                SwgUtil.getExceptionHandler().handleException(ex, null);
            }
        }
    };

    protected XdtsControlUnit createControlUnit(XdtsSelectContext selectContext, XdtsControlContext controlContext, XdtsUserSetting userSetting, boolean isEdid) throws Exception {
        FxTextArea textArea;
        FxNodeUnit nodeUnit = new FxNodeUnit();
        String defaultValue = XdtsUtil.getDefaultValue(controlContext, userSetting);
        if (controlContext.contextType == XdtsConstants.ContextType.Select) {
            XdtsSelectColumnPane selectColumnPane = new XdtsSelectColumnPane();
            int i = 0;
            while (i < selectContext.selectColumnList.size()) {
                XdtsSelectColumn selectColumn = selectContext.selectColumnList.get(i);
                ArrayList<Object> row = new ArrayList<Object>();
                row.add(selectColumn.tableColumnName.template);
                row.add(selectColumn.alias);
                row.add(selectColumn.order);
                selectColumnPane.tableModel.addRow(row);
                ++i;
            }
            selectColumnPane.temp();
            selectColumnPane.setPrefSize(580.0, 320.0);
            nodeUnit.addRightNodes(new Node[]{selectColumnPane});
        } else if (controlContext.contextType == XdtsConstants.ContextType.From) {
            textArea = new FxTextArea();
            textArea.setPrefColumnCount(controlContext.columnCount);
            textArea.setPrefRowCount(controlContext.rowCount);
            textArea.setText(selectContext.from.template);
            FxUtil.setPrefSize((Node)textArea);
            nodeUnit.addRightNodes(new Node[]{textArea});
        } else if (controlContext.contextType == XdtsConstants.ContextType.Where) {
            textArea = new FxTextArea();
            textArea.setPrefColumnCount(controlContext.columnCount);
            textArea.setPrefRowCount(controlContext.rowCount);
            textArea.setText(selectContext.whereBase.template);
            FxUtil.setPrefSize((Node)textArea);
            nodeUnit.addRightNodes(new Node[]{textArea});
        } else if (controlContext.contextType == XdtsConstants.ContextType.OrderBy) {
            textArea = new FxTextArea();
            textArea.setPrefColumnCount(controlContext.columnCount);
            textArea.setPrefRowCount(controlContext.rowCount);
            textArea.setText(selectContext.orderBy);
            FxUtil.setPrefSize((Node)textArea);
            nodeUnit.addRightNodes(new Node[]{textArea});
        } else if (controlContext.contextType == XdtsConstants.ContextType.RowLimit) {
            String[] stringArray = new String[8];
            stringArray[0] = "100";
            stringArray[1] = "500";
            stringArray[2] = "1,000";
            stringArray[3] = "5,000";
            stringArray[4] = "10,000";
            stringArray[5] = "50,000";
            stringArray[6] = "100,000";
            String[] options = stringArray;
            FxComboBox comboBox = new FxComboBox();
            comboBox.setEditable(true);
            int i = 0;
            while (i < options.length) {
                comboBox.getItems().add((Object)options[i]);
                ++i;
            }
            if (!BcStringUtil.isEmpty(defaultValue)) {
                comboBox.getSelectionModel().select((Object)defaultValue);
            }
            FxUtil.setPrefSize(comboBox);
            nodeUnit.addRightNodes(new Node[]{comboBox});
        } else if (controlContext.contextType == XdtsConstants.ContextType.General) {
            Region region = this.createReagion(controlContext, defaultValue);
            nodeUnit.addRightNodes(new Node[]{region});
        }
        Tooltip tooltip = null;
        if (!BcStringUtil.isEmpty(controlContext.description)) {
            tooltip = new Tooltip(controlContext.description);
        }
        this.setTooltip(nodeUnit.getRightNodeList(), tooltip);
        FxLabel label = new FxLabel();
        label.setText(controlContext.itemName);
        this.setTooltip((Node)label, tooltip);
        nodeUnit.setLeftNode((Node)label);
        XdtsControlUnit controlUnit = new XdtsControlUnit();
        controlUnit.selectContext = selectContext;
        controlUnit.controlContext = controlContext;
        controlUnit.nodeUnit = nodeUnit;
        controlUnit.userSetting = userSetting;
        if (isEdid) {
            FxButton optionButton = new FxButton();
            optionButton.setOnAction(this.actionEventHandler);
            optionButton.setGraphic((Node)FxImageHelper.createImageView_icon("gear_64x64.png"));
            FxUtil.setFixedSize((Region)optionButton, 20.0, 20.0);
            optionButton.setUserData(controlUnit);
            nodeUnit.addRightNodes(new Node[]{optionButton});
        }
        return controlUnit;
    }

    protected Region createReagion(XdtsControlContext controlContext, String defaultValue) throws Exception {
        Object region = null;
        List<String> optionList = XdtsUtil.createOptionList(controlContext);
        if (controlContext.controlType == XdtsConstants.ControlType.Text) {
            if (BcCollectionUtil.isEmpty(optionList)) {
                if (controlContext.rowCount > 1) {
                    FxTextArea textArea = new FxTextArea();
                    textArea.setPrefColumnCount(controlContext.columnCount);
                    textArea.setPrefRowCount(controlContext.rowCount);
                    textArea.setText(defaultValue);
                    region = textArea;
                } else {
                    FxTextField textField = new FxTextField();
                    textField.setPrefColumnCount(controlContext.columnCount);
                    textField.setText(defaultValue);
                    region = textField;
                }
            } else {
                FxComboBox comboBox = new FxComboBox();
                comboBox.setEditable(true);
                comboBox.columnCount.set(controlContext.columnCount);
                for (String option : optionList) {
                    comboBox.getItems().add((Object)option);
                }
                if (!BcStringUtil.isEmpty(defaultValue)) {
                    comboBox.getSelectionModel().select((Object)defaultValue);
                }
                FxUtil.setPrefSize(comboBox);
                region = comboBox;
            }
        } else if (controlContext.controlType == XdtsConstants.ControlType.CheckBox) {
            XdtsCheckBoxPane checkBoxPane = new XdtsCheckBoxPane(21);
            FxCssUtil.setBackgroundColor(checkBoxPane, Color.RED);
            for (String option : optionList) {
                FxCheckBox checkBox = new FxCheckBox();
                checkBox.setUserData(option);
                checkBox.setText(option);
                FxUtil.setPrefSize((Node)checkBox);
                checkBoxPane.addCheckBox((ButtonBase)checkBox);
                if (!option.equals(defaultValue)) continue;
                checkBox.setSelected(true);
            }
            checkBoxPane.setPrefWidth(checkBoxPane.width);
            checkBoxPane.setPrefHeight(22.0);
            region = checkBoxPane;
        } else if (controlContext.controlType == XdtsConstants.ControlType.RadioButton) {
            FxxRadioButtonControl radioButtonControl = new FxxRadioButtonControl(true);
            FxCssUtil.setBackgroundColor((Region)radioButtonControl, Color.RED);
            if (!BcCollectionUtil.isEmpty(optionList)) {
                String[] keys;
                String[] values = keys = BcStringUtil.toStringArray(optionList);
                radioButtonControl.setData(keys, values);
            }
            radioButtonControl.setUnspecified(true);
            if (!BcStringUtil.isEmpty(defaultValue)) {
                radioButtonControl.setInputText(defaultValue);
            }
            region = radioButtonControl;
        } else if (controlContext.controlType == XdtsConstants.ControlType.DateTime || controlContext.controlType == XdtsConstants.ControlType.Date) {
            FxxPeriodPane periodPane = null;
            if (controlContext.controlType == XdtsConstants.ControlType.DateTime) {
                periodPane = new FxxPeriodPane(2);
            } else if (controlContext.controlType == XdtsConstants.ControlType.Date) {
                periodPane = new FxxPeriodPane(1);
            }
            Calendar calendar1 = null;
            Calendar calendar2 = null;
            if (!BcStringUtil.isEmpty(defaultValue)) {
                List<String> valueList = BcCsvUtil.parseCsvRow(defaultValue, true);
                calendar1 = BcTimeUtil.toCalendar(valueList.get(0));
                calendar2 = BcTimeUtil.toCalendar(valueList.get(1));
            }
            periodPane.dateTimePane1.setCalendar(calendar1);
            periodPane.dateTimePane2.setCalendar(calendar2);
            region = periodPane;
        } else if (controlContext.controlType == XdtsConstants.ControlType.Boolean) {
            FxxRadioButtonControl radioButtonControl = new FxxRadioButtonControl(true);
            radioButtonControl.setUnspecified(true);
            String[] keys = new String[]{Boolean.toString(true), Boolean.toString(false)};
            String[] values = new String[]{"Yes", "No"};
            radioButtonControl.setData(keys, values);
            radioButtonControl.setUnspecified(true);
            if (!BcStringUtil.isEmpty(defaultValue)) {
                boolean bool = BcBooleanUtil.parseBoolean(defaultValue);
                radioButtonControl.setInputText(Boolean.toString(bool));
            }
            region = radioButtonControl;
        } else {
            throw new Exception("controlContext.controlType=" + (Object)((Object)controlContext.controlType));
        }
        return region;
    }

    public void setTooltip(Node node, Tooltip tooltip) throws Exception {
        if (node instanceof Control) {
            Control control = (Control)node;
            control.setTooltip(tooltip);
        }
    }

    public void setTooltip(Collection<Node> nodeCollection, Tooltip tooltip) throws Exception {
        for (Node node : nodeCollection) {
            this.setTooltip(node, tooltip);
        }
    }

    public String conv(XdtsSelectColumn selectColumn) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append(selectColumn.tableColumnName);
        if (!BcStringUtil.isEmpty(selectColumn.alias)) {
            sb.append(" AS ");
            sb.append(selectColumn.alias);
        }
        return sb.toString();
    }

    public XdtsFxCondition createFxCondition(XdtsExtractionCondition extractionCondition, XdtsUserSetting userSetting, boolean isEdit) throws Exception {
        XdtsFxCondition fxCondition = new XdtsFxCondition();
        fxCondition.controlUnitMap1 = new HashMap<Integer, List<XdtsControlUnit>>();
        int i = 0;
        while (i < extractionCondition.selectContextList.size()) {
            XdtsSelectContext selectContext = extractionCondition.selectContextList.get(i);
            List<XdtsControlUnit> controlUnitList1 = this.createControlUnitList(selectContext, selectContext.controlContextList, userSetting, isEdit);
            fxCondition.controlUnitMap1.put(selectContext.id, controlUnitList1);
            ++i;
        }
        return fxCondition;
    }

    protected List<XdtsControlUnit> createControlUnitList(XdtsSelectContext selectContext, List<XdtsControlContext> controlContextList, XdtsUserSetting userSetting, boolean isEdit) throws Exception {
        List<XdtsControlContext> controlContextList2 = XdtsSqlParserUtil.sortControlContext(controlContextList);
        ArrayList<XdtsControlUnit> controlUnitList = new ArrayList<XdtsControlUnit>();
        for (XdtsControlContext controlContext : controlContextList2) {
            if (!isEdit && controlContext.displayOrder <= 0) continue;
            XdtsControlUnit controlUnit = this.createControlUnit(selectContext, controlContext, userSetting, isEdit);
            controlUnitList.add(controlUnit);
        }
        return controlUnitList;
    }

    public static XdtsSelectColumn toSelectColumn(String src) throws Exception {
        XdtsSelectColumn selectColumn = new XdtsSelectColumn();
        selectColumn.tableColumnName = new XdtsSelectElemet();
        selectColumn.tableColumnName.template = src;
        return selectColumn;
    }

    public static XdtsExtractionCondition createExtractionCondition(SqlContext sqlContext, MmdModel mmdModel) throws Exception {
        XdtsExtractionCondition extractionCondition = new XdtsExtractionCondition();
        extractionCondition.name = mmdModel.tableName;
        extractionCondition.sqlTemplate = extractionCondition.sqlOrign = "SELECT * FROM " + mmdModel.tableName;
        extractionCondition.selectContextList = new ArrayList<XdtsSelectContext>();
        XdtsSelectContext selectContext = new XdtsSelectContext();
        extractionCondition.selectContextList.add(selectContext);
        selectContext.controlContextList = new ArrayList<XdtsControlContext>();
        selectContext.selectColumnList = new ArrayList<XdtsSelectColumn>();
        List<String> tableColumnNameList = MmdUtil.toTableColumnNameList(mmdModel);
        int i = 0;
        while (i < tableColumnNameList.size()) {
            String tableColumnName = tableColumnNameList.get(i);
            XdtsSelectColumn selectColumn = XdtsConditionModelToFx.toSelectColumn(tableColumnName);
            selectColumn.order = i + 1;
            selectContext.selectColumnList.add(selectColumn);
            ++i;
        }
        XdtsControlContext controlContext = XdtsSqlParserUtil.createSelectContext();
        selectContext.controlContextList.add(controlContext);
        controlContext = XdtsSqlParserUtil.createFromContext();
        XdtsSelectElemet selectElemet = new XdtsSelectElemet();
        selectElemet.template = selectElemet.orign = mmdModel.tableName;
        selectContext.from = selectElemet;
        selectContext.controlContextList.add(controlContext);
        controlContext = XdtsSqlParserUtil.createWhereContext();
        selectContext.whereBase = selectElemet = new XdtsSelectElemet();
        selectContext.controlContextList.add(controlContext);
        controlContext = XdtsSqlParserUtil.orderByContext();
        selectContext.orderByList = XdtsConditionModelToFx.createOrderByList(mmdModel);
        if (selectContext.orderByList.size() > 0) {
            MmdIndex mmdIndex = selectContext.orderByList.get(0);
            controlContext.defaultValue = EtcSqlConditionUtil.createIndex(mmdIndex);
        }
        selectContext.controlContextList.add(controlContext);
        controlContext = XdtsSqlParserUtil.rowLimitContext();
        controlContext.defaultValue = Integer.toString(100);
        selectContext.controlContextList.add(controlContext);
        List<XdtsControlContext> controlContextList = XdtsSqlParserUtil.createControlContextList(mmdModel.fieldList);
        selectContext.controlContextList.addAll(controlContextList);
        return extractionCondition;
    }

    public static List<MmdIndex> createOrderByList(MmdModel mmdModel) throws Exception {
        ArrayList<MmdIndex> orderByList = new ArrayList<MmdIndex>();
        MmdIndex primaryKey = mmdModel.getPrimaryIndex();
        if (primaryKey != null) {
            MmdIndex mmdIndex2 = (MmdIndex)primaryKey.clone();
            orderByList.add(mmdIndex2);
        }
        for (MmdIndex mmdIndex : mmdModel.indexMap.values()) {
            MmdIndex mmdIndex2 = (MmdIndex)mmdIndex.clone();
            orderByList.add(mmdIndex2);
        }
        return orderByList;
    }

    public static List<XdtsControlUnit> sortControlUnit(Collection<XdtsControlUnit> controlUnitCollection, boolean isDisp) throws Exception {
        BcTableModel sortTable = BcTableUtil.createTableModelByHeaderValues("order", "value");
        for (XdtsControlUnit controlUnit : controlUnitCollection) {
            ArrayList<Object> row = new ArrayList<Object>();
            row.add(controlUnit.controlContext.displayOrder);
            row.add(controlUnit);
            sortTable.addRow(row);
        }
        BcTableUtil.sort(sortTable, true, 0);
        ArrayList<XdtsControlUnit> controlUnitList = new ArrayList<XdtsControlUnit>();
        int i = 0;
        while (i < sortTable.getRowCount()) {
            XdtsControlUnit controlUnit = (XdtsControlUnit)sortTable.getValueAt(i, 1);
            if (isDisp) {
                if (controlUnit.controlContext.displayOrder > 0) {
                    controlUnitList.add(controlUnit);
                }
            } else {
                controlUnitList.add(controlUnit);
            }
            ++i;
        }
        return controlUnitList;
    }

    public void optionButtonAction(Node optionButton, final XdtsControlUnit controlUnit1) throws Exception {
        BcLogUtil.debug("optionButtonAction:controlUnit1.hashCode()=" + controlUnit1.hashCode());
        Object windowObject = FxUtil.getWindow2(optionButton);
        BcLogUtil.debug("windowObject=" + windowObject);
        Window window = null;
        java.awt.Window awtWindow = null;
        if (windowObject instanceof Window) {
            window = (Window)windowObject;
        } else {
            boolean cfr_ignored_0 = windowObject instanceof java.awt.Window;
        }
        final XdtsControlOptionPane controlOptionPane = new XdtsControlOptionPane(null);
        controlOptionPane.setControlContext(controlUnit1.controlContext);
        if (window != null) {
            XdtsStagePane stagePane = new XdtsStagePane();
            stagePane.setCenter((Node)controlOptionPane);
            class CloseEventHandler
            implements BcEventHandler<BcEvent> {
                private final /* synthetic */ XdtsStagePane val$stagePane;

                CloseEventHandler(XdtsStagePane xdtsStagePane) {
                    this.val$stagePane = xdtsStagePane;
                }

                @Override
                public void handle(BcEvent ev) throws Exception {
                    this.val$stagePane.close();
                }
            }
            CloseEventHandler closeEventHandler = new CloseEventHandler(stagePane);
            controlOptionPane.closeHandlerList.addEventHandler(closeEventHandler);
            stagePane.show(window, XdtsWords.getInstance().controlSettings.toPlain());
            if (controlOptionPane.isCompleted) {
                Parent parent;
                XdtsControlUnit controlUnit2 = this.createControlUnit(controlUnit1.selectContext, controlUnit1.controlContext, controlUnit1.userSetting, false);
                Node node = BcCollectionUtil.getLast(controlUnit1.nodeUnit.getRightNodeList());
                controlUnit1.nodeUnit = controlUnit2.nodeUnit;
                controlUnit1.nodeUnit.addRightNodes(node);
                Parent preParent = optionButton.getParent();
                while ((parent = preParent.getParent()) != null) {
                    if (parent instanceof XdtsExtractionConditionEditPane) {
                        XdtsExtractionConditionEditPane extractionConditionEditPane = (XdtsExtractionConditionEditPane)parent;
                        extractionConditionEditPane.repaint();
                        break;
                    }
                    preParent = parent;
                }
            }
        } else {
            final java.awt.Window awtWindow2 = awtWindow;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        FxScene fxScene = new FxScene((Parent)controlOptionPane);
                        JFXPanel jfxPanel = new JFXPanel();
                        jfxPanel.setScene((Scene)fxScene);
                        XdtsConditionTempPanel conditionTempPanel = new XdtsConditionTempPanel();
                        conditionTempPanel.add((Component)jfxPanel, "Center");
                        conditionTempPanel.showAsDialog(awtWindow2, controlUnit1.controlContext.tableColumnName);
                        boolean cfr_ignored_0 = controlOptionPane.isCompleted;
                    }
                    catch (Exception ex) {
                        BcLogUtil.error(ex);
                    }
                }
            });
        }
    }
}

