/*
 * Decompiled with CFR 0.152.
 */
package ext.libx.swg.docviewer;

import ext.base.log.BcLogUtil;
import ext.lib.doc.util.DcfPageReader;
import ext.lib.swg.SwgPanel;
import ext.lib.swg.SwgScrollPane;
import ext.lib.swg.SwgStatusPanel;
import ext.lib.swg.SwgTabbedPane;
import ext.libx.swg.docviewer.DcfDocumentViewer;
import ext.libx.swg.docviewer.DcfPaperPanel;
import ext.libx.swg.docviewer.DcfViewerControlPanel;
import ext.libx.swg.docviewer.DcfViewerEventHandler;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.JDesktopPane;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;

public class DcfViewerPanel
extends SwgPanel
implements DcfViewerEventHandler {
    protected JDesktopPane desktopPane = new JDesktopPane();
    protected JSplitPane splitPane = new JSplitPane();
    protected JPanel southPanel = new JPanel();
    protected SwgTabbedPane westTabbedPane = new SwgTabbedPane();
    protected SwgStatusPanel statusPanel = new SwgStatusPanel();
    protected DcfViewerControlPanel controlPanel;
    protected SwgScrollPane scrollPane1 = new SwgScrollPane(20, 31);
    protected DcfPaperPanel paperPane1;
    protected SwgScrollPane scrollPane2 = new SwgScrollPane();
    protected DcfPaperPanel paperPane2;
    protected boolean pageNoComboEventEnabled;
    protected DcfDocumentViewer viewer;
    protected DcfPageReader pageReader;
    public float thumbnailScale = 0.2f;
    public float mainScale = 1.0f;

    public DcfViewerPanel(DcfDocumentViewer viewer) throws Exception {
        this.viewer = viewer;
        this.desktopPane.addComponentListener(new ComponentListener(){

            @Override
            public void componentHidden(ComponentEvent ev) {
            }

            @Override
            public void componentMoved(ComponentEvent ev) {
            }

            @Override
            public void componentResized(ComponentEvent ev) {
                DcfViewerPanel.this.splitPane.setSize(DcfViewerPanel.this.desktopPane.getSize());
                DcfViewerPanel.this.splitPane.validate();
            }

            @Override
            public void componentShown(ComponentEvent ev) {
            }
        });
        this.southPanel.setLayout(new BorderLayout());
        this.southPanel.setPreferredSize(new Dimension(0, 20));
        this.southPanel.add((Component)this.statusPanel, "Center");
        this.setLayout(new BorderLayout());
        this.controlPanel = new DcfViewerControlPanel(viewer, this);
        this.add((Component)this.controlPanel, "North");
        this.add((Component)this.southPanel, "South");
        this.paperPane1 = new DcfPaperPanel();
        this.paperPane1.setFixedColumnCount(1);
        this.paperPane1.setFitToBase(true);
        this.paperPane1.setScale(this.thumbnailScale);
        this.paperPane1.addViewerEventHandler(this);
        this.paperPane1.setName("\u30b5\u30e0\u30cd\u30a4\u30eb");
        this.scrollPane1.getViewport().add(this.paperPane1);
        this.westTabbedPane.addTab("\u30da\u30fc\u30b8", this.scrollPane1);
        this.splitPane.setDividerSize(2);
        this.splitPane.setDividerLocation(140);
        this.splitPane.add((Component)this.westTabbedPane, "left");
        this.paperPane2 = new DcfPaperPanel();
        this.paperPane2.setFixedColumnCount(-1);
        this.paperPane2.setFitToBase(false);
        this.paperPane2.setScale(this.mainScale);
        this.paperPane2.setName("\u30e1\u30a4\u30f3");
        this.scrollPane2.getViewport().add(this.paperPane2);
        this.splitPane.add((Component)this.scrollPane2, "right");
        this.desktopPane.add((Component)this.splitPane, JLayeredPane.PALETTE_LAYER);
        this.add((Component)this.desktopPane, "Center");
    }

    protected void checkOption() throws Exception {
        this.controlPanel.checkOption();
    }

    public DcfPageReader getPageReader() {
        return this.pageReader;
    }

    public void setPageReader(DcfPageReader pageReader) throws Exception {
        this.pageReader = pageReader;
        this.controlPanel.setPageReader(pageReader);
        this.paperPane1.setPageReader(pageReader);
        this.paperPane2.setPageReader(pageReader);
        if (pageReader.getPageCount() > 0) {
            this.paperPane2.setDispPages(0);
        }
    }

    @Override
    public void pageSelected(Object src, int pageIndex) {
        if (pageIndex == this.controlPanel.getCurrentPageIndex()) {
            return;
        }
        try {
            this.controlPanel.setCurrentPageIndex(pageIndex);
            this.paperPane2.setDispPages(pageIndex);
            this.paperPane2.repaint();
        }
        catch (Exception ex) {
            BcLogUtil.error(ex);
        }
    }

    protected void setScale(float scale) throws Exception {
        this.paperPane2.setScale(scale);
        this.paperPane2.repaint();
    }
}

