/*
 * Decompiled with CFR 0.152.
 */
package ext.lib.sql.context;

import ext.base.core.BcStringUtil;
import ext.lib.sql.SqlConstants;
import ext.lib.sql.context.SqlContext;
import java.util.Map;
import org.h2.api.Interval;

public class SqlContext_H2
extends SqlContext {
    public static final String DRIVER_CLASS_NAME = "org.h2.Driver";
    public static final String[] DRIVER_CLASS_NAMES = new String[]{"org.h2.Driver"};

    public SqlContext_H2(SqlConstants.DatabaseProduct databaseProduct) {
        super(databaseProduct);
    }

    @Override
    public String[] getDriverClassNames() {
        return DRIVER_CLASS_NAMES;
    }

    @Override
    public String reformForMetadata(String objectName) throws Exception {
        if (objectName == null) {
            return null;
        }
        return objectName.toUpperCase();
    }

    @Override
    public String setLimit(String srcSql, int limit, int offset) throws Exception {
        StringBuilder sb = new StringBuilder(srcSql.length() + 20);
        sb.append(srcSql);
        if (limit > 0) {
            sb.append(" LIMIT " + limit);
        }
        if (offset > 0) {
            sb.append(" OFFSET " + offset);
        }
        return sb.toString();
    }

    @Override
    public String convertSql(String srcSql, Map<String, String> paramMap, SqlContext baseSqlContext) throws Exception {
        StringBuilder newSql = new StringBuilder(srcSql);
        newSql = BcStringUtil.replace(newSql, "without time zone", "", false);
        newSql = BcStringUtil.replace(newSql, "USING btree", "", false);
        newSql = BcStringUtil.replace(newSql, "ALTER TABLE ONLY", "ALTER TABLE", false);
        return newSql.toString();
    }

    @Override
    public Object toFieldValue(Object jdbcValue, Class toClass) throws Exception {
        if (jdbcValue == null) {
            return null;
        }
        Class<?> fromClass = jdbcValue.getClass();
        Object fieldValue = null;
        if (Interval.class.isAssignableFrom(fromClass)) {
            Interval interval = (Interval)jdbcValue;
        } else {
            fieldValue = super.toFieldValue(jdbcValue, toClass);
        }
        return fieldValue;
    }

    public static String cretaeUrl(Protocol protocol, String databaseName, boolean ifExists, boolean dbCloseOnExit) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append(protocol.value);
        sb.append(databaseName);
        if (ifExists) {
            sb.append(";IFEXISTS=" + ifExists);
        }
        if (dbCloseOnExit) {
            sb.append(";DB_CLOSE_ON_EXIT=" + dbCloseOnExit);
        }
        return sb.toString();
    }

    public static String cretaeUrlFile(String dbPath) throws Exception {
        return SqlContext_H2.cretaeUrl(Protocol.file, dbPath, true, true);
    }

    public static enum Protocol {
        file("jdbc:h2:file:"),
        mem("jdbc:h2:mem:"),
        tcp("jdbc:h2:tcp:");

        public final String value;

        private Protocol(String value) {
            this.value = value;
        }
    }
}

