/*
 * Decompiled with CFR 0.152.
 */
package ext.lib.sql;

import ext.base.log.BcLoggableObject;
import ext.lib.datasource.DtsConnectionManager;
import ext.lib.sql.SqlCallableStatement;
import ext.lib.sql.SqlPreparedStatement;
import ext.lib.sql.SqlStatement;
import ext.lib.sql.SqlUtil;
import ext.lib.sql.context.SqlContext;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;

public class SqlConnection
extends BcLoggableObject
implements Connection {
    private Connection sqlConn1;
    private Connection sqlConn2;
    private SqlContext sqlContext;
    private DtsConnectionManager connectionManager;
    private Long createTime;
    private int queryTimeout;
    private long lendingTimeout;
    private Long lendingStartTime;
    private Long lendingTimeoutTime;
    public int maxUsage = 2;
    public int usage;
    public long longQueryTime;
    private Object owner;
    public List<SqlStatement> statementList = new ArrayList<SqlStatement>();

    public SqlConnection(Connection sqlConn, SqlContext sqlContext, DtsConnectionManager connectionManager) throws Exception {
        this.sqlConn1 = sqlConn;
        this.sqlContext = sqlContext;
        this.connectionManager = connectionManager;
        this.init();
    }

    @Override
    public SqlStatement createStatement() throws SQLException {
        SqlStatement stmt = this.sqlContext.createStatement(this, this.sqlConn2.createStatement());
        return stmt;
    }

    @Override
    public SqlPreparedStatement prepareStatement(String sql) throws SQLException {
        PreparedStatement ppst1 = this.sqlConn2.prepareStatement(sql);
        SqlPreparedStatement ppst2 = this.createSqlPreparedStatement(ppst1);
        return ppst2;
    }

    @Override
    public SqlCallableStatement prepareCall(String sql) throws SQLException {
        CallableStatement callableStmt1 = this.sqlConn2.prepareCall(sql);
        SqlCallableStatement callableStmt2 = this.createSqlCallableStatement(callableStmt1);
        return callableStmt2;
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        return this.sqlConn2.nativeSQL(sql);
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.sqlConn2.setAutoCommit(autoCommit);
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return this.sqlConn2.getAutoCommit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit() throws SQLException {
        SqlConnection sqlConnection = this;
        synchronized (sqlConnection) {
            this.sqlConn2.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback() throws SQLException {
        SqlConnection sqlConnection = this;
        synchronized (sqlConnection) {
            this.sqlConn2.rollback();
        }
    }

    @Override
    public void close() throws SQLException {
        if (this.sqlConn2 != null) {
            try {
                this.connectionManager.returnConnection(this);
            }
            catch (Exception ex) {
                throw new SQLException(ex);
            }
        } else {
            this.getLogger().warning("Connection flag is already closed. hashCode=" + this.hashCode());
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.sqlConn2 == null;
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        return this.sqlConn2.getMetaData();
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.sqlConn2.setReadOnly(readOnly);
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return this.sqlConn2.isReadOnly();
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.sqlConn2.setCatalog(catalog);
    }

    @Override
    public String getCatalog() throws SQLException {
        return this.sqlConn2.getCatalog();
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.sqlConn2.setTransactionIsolation(level);
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        return this.sqlConn2.getTransactionIsolation();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.sqlConn2.getWarnings();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.sqlConn2.clearWarnings();
    }

    @Override
    public SqlStatement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        Statement stmt1 = this.sqlConn2.createStatement(resultSetType, resultSetConcurrency);
        SqlStatement stmt2 = this.sqlContext.createStatement(this, stmt1);
        return stmt2;
    }

    @Override
    public SqlPreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        PreparedStatement ppst1 = this.sqlConn2.prepareStatement(sql, resultSetType, resultSetConcurrency);
        SqlPreparedStatement ppst2 = this.createSqlPreparedStatement(ppst1);
        return ppst2;
    }

    @Override
    public SqlCallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        CallableStatement callableStmt1 = this.sqlConn2.prepareCall(sql, resultSetType, resultSetConcurrency);
        SqlCallableStatement callableStmt2 = this.createSqlCallableStatement(callableStmt1);
        return callableStmt2;
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        return this.sqlConn2.getTypeMap();
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        this.sqlConn2.setTypeMap(map);
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        this.sqlConn2.setHoldability(holdability);
    }

    @Override
    public int getHoldability() throws SQLException {
        return this.sqlConn2.getHoldability();
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        return this.sqlConn2.setSavepoint();
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        return this.sqlConn2.setSavepoint(name);
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        this.sqlConn2.rollback(savepoint);
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.sqlConn2.releaseSavepoint(savepoint);
    }

    @Override
    public SqlStatement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        Statement stmt1 = this.sqlConn2.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
        SqlStatement stmt2 = this.sqlContext.createStatement(this, stmt1);
        return stmt2;
    }

    @Override
    public SqlPreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        PreparedStatement ppst1 = this.sqlConn2.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        SqlPreparedStatement ppst2 = this.createSqlPreparedStatement(ppst1);
        return ppst2;
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        CallableStatement callableStmt1 = this.sqlConn2.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        SqlCallableStatement callableStmt2 = this.createSqlCallableStatement(callableStmt1);
        return callableStmt2;
    }

    @Override
    public SqlPreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        PreparedStatement ppst1 = this.sqlConn2.prepareStatement(sql, autoGeneratedKeys);
        SqlPreparedStatement ppst2 = this.createSqlPreparedStatement(ppst1);
        return ppst2;
    }

    @Override
    public SqlPreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        PreparedStatement ppst1 = this.sqlConn2.prepareStatement(sql, columnIndexes);
        SqlPreparedStatement ppst2 = this.createSqlPreparedStatement(ppst1);
        return ppst2;
    }

    @Override
    public SqlPreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        PreparedStatement ppst1 = this.sqlConn2.prepareStatement(sql, columnNames);
        SqlPreparedStatement ppst2 = this.createSqlPreparedStatement(ppst1);
        return ppst2;
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        return this.sqlConn2.getClientInfo(name);
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        return this.sqlConn2.getClientInfo();
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        this.sqlConn2.setClientInfo(name, value);
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        this.sqlConn2.setClientInfo(properties);
    }

    @Override
    public Blob createBlob() throws SQLException {
        return this.sqlConn2.createBlob();
    }

    @Override
    public Clob createClob() throws SQLException {
        return this.sqlConn2.createClob();
    }

    @Override
    public NClob createNClob() throws SQLException {
        return this.sqlConn2.createNClob();
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        return this.sqlConn2.createSQLXML();
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        return this.sqlConn2.createArrayOf(typeName, elements);
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        return this.sqlConn2.createStruct(typeName, attributes);
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        boolean isValid = false;
        if (!this.isClosed()) {
            if (this.sqlContext.isSupported(SqlContext.Function.statementIsClosed)) {
                return this.sqlConn2.isValid(timeout);
            }
            try {
                Object respons = SqlUtil.execute(this, this.sqlContext.getValidationQuery());
                this.getLogger().debug("isValid:respons=" + respons);
                isValid = true;
            }
            catch (Exception ex) {
                this.getLogger().error(ex);
            }
        }
        return isValid;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.sqlConn2.isWrapperFor(iface);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this.sqlConn2.unwrap(iface);
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        this.sqlConn2.setSchema(schema);
    }

    @Override
    public String getSchema() throws SQLException {
        return this.sqlConn2.getSchema();
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        this.sqlConn2.abort(executor);
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        this.sqlConn2.setNetworkTimeout(executor, milliseconds);
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        return this.sqlConn2.getNetworkTimeout();
    }

    public void init() throws Exception {
        this.sqlConn1.setAutoCommit(false);
        this.sqlConn2 = this.sqlConn1;
        this.setQueryTimeout(0);
        this.setLendingTimeout(0L);
        this.setLendingStartTime(null);
        this.setLendingTimeoutTime(null);
        this.setOwner(null);
        this.statementList.clear();
    }

    public DtsConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    public Connection getConnection() {
        return this.sqlConn1;
    }

    public synchronized void desturuct() throws SQLException {
        this.sqlConn1.close();
        this.sqlConn1 = null;
        this.sqlConn2 = null;
    }

    public SqlContext getSqlContext() {
        return this.sqlContext;
    }

    public Long getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Long createTime) {
        this.createTime = createTime;
    }

    public int getQueryTimeout() {
        return this.queryTimeout;
    }

    public void setQueryTimeout(int queryTimeout) {
        this.queryTimeout = queryTimeout;
    }

    public long getLendingTimeout() {
        return this.lendingTimeout;
    }

    public void setLendingTimeout(long lendingTimeout) {
        this.lendingTimeout = lendingTimeout;
    }

    public Long getLendingStartTime() {
        return this.lendingStartTime;
    }

    public void setLendingStartTime(Long lendingStartTime) {
        this.lendingStartTime = lendingStartTime;
    }

    public Long getLendingTimeoutTime() {
        return this.lendingTimeoutTime;
    }

    public void setLendingTimeoutTime(Long lendingTimeoutTime) {
        this.lendingTimeoutTime = lendingTimeoutTime;
    }

    public Object getOwner() {
        return this.owner;
    }

    public void setOwner(Object owner) {
        this.owner = owner;
    }

    public long getLongQueryTime() {
        return this.longQueryTime;
    }

    public void setLongQueryTime(long longQueryTime) {
        this.longQueryTime = longQueryTime;
    }

    public boolean removeStatement(SqlStatement statement) throws SQLException {
        return this.statementList.remove(statement);
    }

    protected SqlPreparedStatement createSqlPreparedStatement(PreparedStatement ppst1) throws SQLException {
        SqlPreparedStatement ppst2 = new SqlPreparedStatement(this, ppst1, this.sqlContext);
        ppst2.setQueryTimeout(this.getQueryTimeout());
        ppst2.setLogger(this.getLogger());
        ppst2.setLongQueryTime(this.longQueryTime);
        this.statementList.add(ppst2);
        return ppst2;
    }

    protected SqlCallableStatement createSqlCallableStatement(CallableStatement callableStmt1) throws SQLException {
        SqlCallableStatement callableStmt2 = new SqlCallableStatement(this, callableStmt1, this.sqlContext);
        callableStmt2.setQueryTimeout(this.getQueryTimeout());
        callableStmt2.setLogger(this.getLogger());
        callableStmt2.setLongQueryTime(this.longQueryTime);
        this.statementList.add(callableStmt2);
        return callableStmt2;
    }
}

