/*
 * Decompiled with CFR 0.152.
 */
package ext.lib.sql;

import ext.base.core.BcStringUtil;
import ext.base.util.BcCollectionUtil;
import ext.lib.sql.SqlConditionSpliter;
import ext.lib.sql.SqlConstants;
import ext.lib.sql.context.SqlContext;
import java.util.List;

public final class SqlConditionUtil {
    private SqlConditionUtil() throws Exception {
    }

    public static String createPatternMatchClause(SqlContext sqlContext, String columnName, SqlConstants.PatternMatch patternMatch, boolean isEquals, boolean isAnd, List<String> conditionList) throws Exception {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < conditionList.size()) {
            String condition = conditionList.get(i);
            if (!BcStringUtil.isEmpty(condition)) {
                if (!BcStringUtil.isEmpty(sb)) {
                    if (isAnd) {
                        sb.append(" AND ");
                    } else {
                        sb.append(" OR ");
                    }
                }
                sb.append(columnName);
                sb.append(sqlContext.toCondition_string(patternMatch, isEquals, condition));
            }
            ++i;
        }
        if (!BcStringUtil.isEmpty(sb)) {
            sb.insert(0, "(");
            sb.append(")");
        }
        return sb.toString();
    }

    public static String createKeywordClause(SqlContext sqlContext, List<String> columnNameList, boolean columnAnd, boolean isAnd, List<String> conditionList) throws Exception {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < columnNameList.size()) {
            String sb2;
            String columnName = columnNameList.get(i);
            if (!BcStringUtil.isEmpty(sb)) {
                if (columnAnd) {
                    sb.append(" AND ");
                } else {
                    sb.append(" OR ");
                }
            }
            if (!BcStringUtil.isEmpty(sb2 = SqlConditionUtil.createPatternMatchClause(sqlContext, columnName, SqlConstants.PatternMatch.partialMatch, true, isAnd, conditionList))) {
                sb.append(sb2);
            }
            ++i;
        }
        if (!BcStringUtil.isEmpty(sb)) {
            sb.insert(0, "(");
            sb.append(")");
        }
        return sb.toString();
    }

    public static String createKeywordClause(SqlContext sqlContext, List<String> columnNameList, String condition) throws Exception {
        SqlConditionSpliter conditionSpliter = SqlConditionSpliter.getInstance();
        List<String> conditionList = conditionSpliter.split(condition);
        return SqlConditionUtil.createKeywordClause(sqlContext, columnNameList, false, false, conditionList);
    }

    public static String createKeywordClause(SqlContext sqlContext, String columnName, String condition) throws Exception {
        List<String> columnNameList = BcCollectionUtil.asList(columnName);
        return SqlConditionUtil.createKeywordClause(sqlContext, columnNameList, condition);
    }
}

