/*
 * Decompiled with CFR 0.152.
 */
package ext.lib.fx.control;

import ext.base.core.BcStringUtil;
import ext.base.runtime.BcRuntimeUtil;
import ext.lib.fx.skin.FxCssUtil;
import ext.lib.fx.util.FxUtil;
import ext.lib.swg.SwgUtil;
import java.util.regex.Pattern;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.control.TextField;
import javafx.scene.control.TextInputControl;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;

public class FxTextField
extends TextField {
    private IntegerProperty maxLength;
    private ObjectProperty<Pattern> patternProperty;
    private boolean doTrim = true;
    private boolean isFullWidth;
    private boolean textChanged;
    private boolean isEditing;
    private String firstStyle;
    private boolean styleChangeFlag;
    protected EventHandler<KeyEvent> keyEventHandler = new EventHandler<KeyEvent>(){

        public void handle(KeyEvent ev) {
            try {
                FxTextField.this.keyEvent(ev);
            }
            catch (Exception ex) {
                FxTextField.this.handleException(ex);
            }
        }
    };
    protected EventHandler<MouseEvent> mouseEventHandler = new EventHandler<MouseEvent>(){

        public void handle(MouseEvent ev) {
            try {
                FxTextField.this.mouseEvent(ev);
            }
            catch (Exception ex) {
                FxTextField.this.handleException(ex);
            }
        }
    };

    public void setMaxLength(int value) {
        this.maxLengthProperty().set(value);
    }

    public int getMaxLength() {
        return this.maxLengthProperty().get();
    }

    public IntegerProperty maxLengthProperty() {
        if (this.maxLength == null) {
            this.maxLength = new SimpleIntegerProperty((Object)this, "Maximum Length", -1);
        }
        return this.maxLength;
    }

    public void setPattern(Pattern value) {
        this.patternPropertyProperty().set((Object)value);
    }

    public Pattern getPattern() {
        return (Pattern)this.patternPropertyProperty().get();
    }

    public ObjectProperty<Pattern> patternPropertyProperty() {
        if (this.patternProperty == null) {
            this.patternProperty = new SimpleObjectProperty((Object)this, "Pattern");
        }
        return this.patternProperty;
    }

    public boolean doTrim() {
        return this.doTrim;
    }

    public void setDoTrim(boolean doTrim) {
        this.doTrim = doTrim;
    }

    public boolean isFullWidth() {
        return this.isFullWidth;
    }

    public void setFullWidth(boolean isFullWidth) {
        this.isFullWidth = isFullWidth;
    }

    public boolean isTextChanged() {
        return this.textChanged;
    }

    public FxTextField() {
        this.setAlignment(Pos.CENTER_LEFT);
        this.init();
    }

    public FxTextField(String text) {
        super(text);
        this.setAlignment(Pos.CENTER_LEFT);
        this.init();
    }

    protected void init() {
        this.setOnKeyPressed(this.keyEventHandler);
        this.setOnKeyReleased(this.keyEventHandler);
        this.setOnKeyTyped(this.keyEventHandler);
        this.setOnMouseClicked(this.mouseEventHandler);
        this.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                FxTextField.this.textChanged = true;
                if (!FxTextField.this.isEditing) {
                    try {
                        FxTextField.this.textEdited();
                        FxTextField.this.textChanged = false;
                    }
                    catch (Exception ex) {
                        FxTextField.this.handleException(ex);
                    }
                }
            }
        });
        this.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                try {
                    if (newValue.booleanValue()) {
                        FxTextField.this.focusIn();
                    } else {
                        FxTextField.this.focusOut();
                    }
                }
                catch (Exception ex) {
                    FxTextField.this.handleException(ex);
                }
            }
        });
        this.prefColumnCountProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                try {
                    FxTextField.this.prefColumnCountChanged(oldValue, newValue);
                }
                catch (Exception ex) {
                    FxTextField.this.handleException(ex);
                }
            }
        });
        this.styleProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                try {
                    FxTextField.this.styleChanged(oldValue, newValue);
                }
                catch (Exception ex) {
                    FxTextField.this.handleException(ex);
                }
            }
        });
        if (BcRuntimeUtil.isJava_1_8()) {
            Insets insets = this.getPadding();
            this.setPadding(FxUtil.createInsets(insets, 0.0, 2.0, -1.0, 2.0));
        }
    }

    public void replaceText(int start, int end, String text) {
        if (BcStringUtil.isEmpty(text)) {
            super.replaceText(start, end, text);
        } else if (this.getMaxLength() > 0) {
            if (this.getLength() < this.getMaxLength() && this.isPatternMatchiFind(text)) {
                super.replaceText(start, end, text);
            }
        } else if (this.isPatternMatchiFind(text)) {
            super.replaceText(start, end, text);
        }
    }

    public void replaceSelection(String text) {
        if (BcStringUtil.isEmpty(text)) {
            super.replaceSelection(text);
        } else if (this.getMaxLength() > 0 && this.getLength() < this.getMaxLength()) {
            if (this.isPatternMatchiFind(text)) {
                super.replaceSelection(text);
            }
        } else {
            super.replaceSelection(text);
        }
    }

    protected void keyEvent(KeyEvent ev) throws Exception {
        if (ev.getEventType() == KeyEvent.KEY_PRESSED) {
            if (ev.getCode() == KeyCode.ENTER) {
                Event.fireEvent((EventTarget)this, (Event)new KeyEvent(KeyEvent.KEY_PRESSED, KeyEvent.CHAR_UNDEFINED, "", KeyCode.TAB, false, false, false, false));
            }
        } else if (ev.getEventType() == KeyEvent.KEY_TYPED) {
            this.isEditing = true;
        }
    }

    public void focusIn() throws Exception {
    }

    protected void focusOut() throws Exception {
        if (this.textChanged) {
            this.textEdited();
        }
        this.textChanged = false;
        this.isEditing = false;
    }

    protected void textEdited() throws Exception {
        if (this.doTrim()) {
            this.setText(BcStringUtil.trim(this.getText(), true));
        }
    }

    protected void mouseEvent(MouseEvent ev) throws Exception {
    }

    public boolean isPatternMatchiFind(String text) {
        if (this.getPattern() != null) {
            return this.getPattern().matcher(text).find();
        }
        return true;
    }

    public void prefColumnCountChanged(Number oldValue, Number newValue) throws Exception {
        FxUtil.setPrefSize_TextField(this);
    }

    public void styleChanged(String oldValue, String newValue) throws Exception {
        if (BcStringUtil.isEmpty(this.firstStyle)) {
            this.firstStyle = newValue;
        }
        if (this.styleChangeFlag) {
            this.styleChangeFlag = false;
            return;
        }
        if (!this.isEditable()) {
            this.styleChangeFlag = true;
            FxCssUtil.setStyle_form_01((TextInputControl)this);
        }
        FxUtil.setPrefSize_TextField(this);
    }

    protected void handleException(Throwable throwable) {
        SwgUtil.getExceptionHandler().handleException(throwable, (Object)this);
    }
}

