/*
 * Decompiled with CFR 0.152.
 */
package ext.base.core;

import ext.base.core.BcNumberUtil;
import ext.base.core.BcStringUtil;
import ext.base.core.BcTimeParser;
import ext.base.core.BcUnicode;
import ext.base.log.BcLogUtil;
import ext.base.util.BcCompareUtil;
import ext.base.util.BcPeriod;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;

public final class BcTimeUtil {
    public static final long MILLI_SECONDS_AT_DAY = 86400000L;
    public static final long MILLI_SECONDS_AT_HOUR = 3600000L;
    public static final long MILLI_SECONDS_AT_MINUTE = 60000L;
    public static final long MILLI_SECONDS_AT_SECONDS = 1000L;
    public static final int DAY_COUNT_OF_WEEK = 7;
    public static final int MONTH_COUNT_OF_YEAR = 12;
    public static final String TIME_DELIMITER = BcUnicode.Unicode.COLON.string;
    public static final String MILLIS_DELIMITER = BcUnicode.Unicode.PERIOD.string;
    public static final String FORMAT_yyyy_MM = "yyyy/MM";
    public static final String FORMAT_yyyy_MM_dd = "yyyy/MM/dd";
    public static final String FORMAT_HH_mm = "HH:mm";
    public static final String FORMAT_SSS = "SSS";
    public static final String FORMAT_HH_mm_ss = "HH:mm:ss";
    public static final String FORMAT_millis = "HH:mm:ss.SSS";
    public static final String FORMAT_dateMinute = "yyyy/MM/dd HH:mm";
    public static final String FORMAT_dateTime = "yyyy/MM/dd HH:mm:ss";
    public static final String FORMAT_timeStamp = "yyyy/MM/dd HH:mm:ss.SSS";
    public static final String FORMAT_yyyyMMdd = "yyyyMMdd";
    public static final String FORMAT_yyMMdd = "yyMMdd";
    public static final String FORMAT_HHmmss = "HHmmss";
    public static final String FORMAT_yyyyMMddHHmmssSSS = "yyyyMMddHHmmssSSS";
    public static final int DATE_NULL = 0;
    public static final int DATE_MAX = 100070607;
    public static final int DATE_MAX_yyyy = 10007;
    public static final int DATE_MAX_MM = 6;
    public static final int DATE_MAX_dd = 7;
    public static final int dateNum99999999 = 99999999;
    public static final String dateStr99999999 = "9999/99/99";
    public static final String dateStr00000000 = "0000/00/00";
    public static final int Y2_BASE_DEFAULT = 30;
    public static BcTimeParser timeParser = new BcTimeParser();
    public static final String EMPTY_STRING = "";
    public static final int PERIOD_DATE = 1;
    public static final int PERIOD_DATE_TIME = 2;
    public static final int PERIOD_TIME = 3;
    public static final int PERIOD_YEAR_MONTH = 11;

    private BcTimeUtil() {
    }

    public static String toJavaFormat(String format) {
        return "{0, date, " + format + "}";
    }

    public static Calendar createCalendar() {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setLenient(false);
        return calendar;
    }

    public static int createYyyyMMdd() {
        return BcTimeUtil.toYyyyMMdd(Calendar.getInstance());
    }

    public static int createYyMMdd() {
        return BcTimeUtil.toYyMMdd(Calendar.getInstance());
    }

    public static short createHHmm() {
        return BcTimeUtil.toHHmm(Calendar.getInstance());
    }

    public static Calendar toCalendar(long millis) {
        Calendar calendar = BcTimeUtil.createCalendar();
        calendar.setTimeInMillis(millis);
        return calendar;
    }

    public static Calendar toCalendar(Date date) throws Exception {
        if (date == null) {
            return null;
        }
        return BcTimeUtil.toCalendar(date.getTime());
    }

    public static Calendar toCalendar(String text, String format) throws Exception {
        if (BcStringUtil.isEmpty(text)) {
            return null;
        }
        Calendar calendar = null;
        if (BcStringUtil.isEmpty(format)) {
            calendar = BcTimeUtil.toCalendar(text);
        } else {
            SimpleDateFormat dateFormat = new SimpleDateFormat(format);
            try {
                Date date = dateFormat.parse(text);
                calendar = BcTimeUtil.createCalendar();
                calendar.setTime(date);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return calendar;
    }

    public static Calendar toCalendar(String text, boolean isLenient, boolean isActualMaximum, int y2Base) throws Exception {
        String src2 = BcStringUtil.trim(text);
        if (BcStringUtil.isEmpty(src2)) {
            return null;
        }
        Calendar calendar = timeParser.parseToCalendar(text, isLenient, isActualMaximum, y2Base);
        return calendar;
    }

    public static Calendar toCalendar(String text, boolean isLenient, boolean isActualMaximum) throws Exception {
        return BcTimeUtil.toCalendar(text, isLenient, isActualMaximum, 30);
    }

    public static Calendar toCalendar(String text) throws Exception {
        return BcTimeUtil.toCalendar(text, false, false, 30);
    }

    public static Calendar toCalendar(int yyyyMMdd) throws Exception {
        Calendar calendar;
        if (yyyyMMdd <= 0) {
            return null;
        }
        if (yyyyMMdd == 99999999) {
            return BcTimeUtil.toCalendar(100070607);
        }
        String tmpStr1 = BcStringUtil.fillPrefix(yyyyMMdd, 8, '0');
        int yGap = tmpStr1.length() - 8;
        int yAdd = 0;
        if (yGap > 0) {
            yAdd = Integer.parseInt(tmpStr1.substring(0, yGap));
            tmpStr1 = tmpStr1.substring(yGap);
        }
        if ((calendar = BcTimeUtil.toCalendar(tmpStr1, FORMAT_yyyyMMdd)) != null) {
            calendar.add(1, yAdd * 10000);
        }
        return calendar;
    }

    public static Calendar toCalendar(Integer yyyyMMdd) throws Exception {
        if (yyyyMMdd != null) {
            return BcTimeUtil.toCalendar((int)yyyyMMdd);
        }
        return BcTimeUtil.toCalendar(0);
    }

    public static Calendar toCalendar(int yyyyMMdd, int HHmmss) throws Exception {
        if (yyyyMMdd <= 0) {
            return null;
        }
        String tmpStr1 = BcStringUtil.fillPrefix(yyyyMMdd, 8, '0');
        String tmpStr2 = BcStringUtil.fillPrefix(HHmmss, 6, '0');
        Calendar calendar = BcTimeUtil.toCalendar(String.valueOf(tmpStr1) + tmpStr2, "yyyyMMddHHmmss");
        return calendar;
    }

    public static Calendar toCalendar(int yyyyMMdd, short HHmm) throws Exception {
        return BcTimeUtil.toCalendar(yyyyMMdd, (int)((double)HHmm * Math.pow(10.0, 2.0)));
    }

    public static Calendar toCalendarMonthId(int year, int monthId, int date, int hourOfDay, int minute, int second) {
        Calendar calendar = BcTimeUtil.createCalendar();
        calendar.set(year, monthId, date, hourOfDay, minute, second);
        return calendar;
    }

    public static Calendar toCalendarMonthId(int year, int monthId, int date, int hourOfDay, int minute) {
        Calendar calendar = BcTimeUtil.createCalendar();
        calendar.set(year, monthId, date, hourOfDay, minute);
        return calendar;
    }

    public static Calendar toCalendarMonthId(int year, int monthId, int date) {
        Calendar calendar = BcTimeUtil.createCalendar();
        calendar.set(year, monthId, date);
        return calendar;
    }

    public static Calendar toCalendarFromYyyyMM(int yyyyMM) throws Exception {
        if (yyyyMM <= 0) {
            return null;
        }
        String tmpStr1 = BcStringUtil.fillPrefix(yyyyMM, 6, '0');
        Calendar calendar = BcTimeUtil.toCalendar(String.valueOf(tmpStr1) + "01", FORMAT_yyyyMMdd);
        return calendar;
    }

    public static Calendar toCalendarFromYyyyMM(int yyyy, int MM) throws Exception {
        return BcTimeUtil.toCalendarFromYyyyMM(BcTimeUtil.toYyyyMM(yyyy, MM));
    }

    public static LocalDate toLocalDate(int yyyyMMdd) throws Exception {
        String str = BcStringUtil.fillPrefix(Integer.toString(yyyyMMdd), FORMAT_yyyyMMdd.length(), '0');
        short yyyy = Short.parseShort(str.substring(0, 4));
        short mm = Short.parseShort(str.substring(4, 6));
        short dd = Short.parseShort(str.substring(6, 8));
        return LocalDate.of((int)yyyy, mm, (int)dd);
    }

    public static long toDurationFromHHmmssSSS(String HHmmssSSS) throws Exception {
        String HHmmssSSSwk = BcStringUtil.trim(HHmmssSSS);
        List<Integer> spaceIndexList = BcStringUtil.createIndexList(HHmmssSSSwk, BcUnicode.Unicode.SPACE.string);
        if (spaceIndexList.size() >= 1) {
            throw new IllegalArgumentException("param=" + HHmmssSSS);
        }
        List<Integer> colonIndexList = BcStringUtil.createIndexList(HHmmssSSSwk, BcUnicode.Unicode.COLON.string);
        BcLogUtil.debug("colonIndexList.size()=" + colonIndexList.size());
        if (colonIndexList.size() == 1) {
            List<Integer> periodIndexList = BcStringUtil.createIndexList(HHmmssSSSwk, BcUnicode.Unicode.PERIOD.string);
            if (periodIndexList.size() == 0) {
                HHmmssSSSwk = String.valueOf(HHmmssSSSwk) + ":00";
            } else if (periodIndexList.size() == 1) {
                HHmmssSSSwk = "00:" + HHmmssSSSwk;
            }
        }
        Calendar epochCalendar = BcTimeUtil.createEpochCalendar();
        String yyyyMMdd = BcTimeUtil.toString(epochCalendar, FORMAT_yyyy_MM_dd);
        String yyyyMMdd_HHmmssSSS = String.valueOf(yyyyMMdd) + " " + HHmmssSSSwk;
        Calendar calendarWk = BcTimeUtil.toCalendar(yyyyMMdd_HHmmssSSS, true, false);
        long duration = calendarWk.getTimeInMillis() - epochCalendar.getTimeInMillis();
        return duration;
    }

    public static void setToday(Calendar calendar) {
        Calendar now = BcTimeUtil.createCalendar();
        calendar.set(1, now.get(1));
        calendar.set(2, now.get(2));
        calendar.set(5, now.get(5));
    }

    public static void initTimeField(Calendar calendar) {
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
    }

    public static Calendar toTimeInitializedCalendar(Calendar calendar) {
        Calendar calendar2 = (Calendar)calendar.clone();
        BcTimeUtil.initTimeField(calendar2);
        return calendar2;
    }

    public static Calendar toTimeInitializedCalendar(Date date) {
        Calendar calendar2 = BcTimeUtil.createCalendar();
        calendar2.setTime(date);
        return BcTimeUtil.toTimeInitializedCalendar(calendar2);
    }

    public static void setTimeField(Calendar calendar, int hourOfDay, int minute, int second, int milliSecound) {
        calendar.set(11, hourOfDay);
        calendar.set(12, minute);
        calendar.set(13, second);
        calendar.set(14, milliSecound);
    }

    public static void setTimeField(Calendar calendar, int hourOfDay, int minute, int second) {
        BcTimeUtil.setTimeField(calendar, hourOfDay, minute, second, 0);
    }

    public static void setTimeField(Calendar calendar, int hourOfDay, int minute) {
        BcTimeUtil.setTimeField(calendar, hourOfDay, minute, 0);
    }

    public static void setTimeFieldHHmmssSSS(Calendar calendar, Integer HHmmssSSS) {
        if (HHmmssSSS == null) {
            BcTimeUtil.setTimeField(calendar, 0, 0, 0, 0);
        } else {
            long HH = HHmmssSSS / 10000000;
            long mm = ((long)HHmmssSSS.intValue() - HH * 10000000L) / 100000L;
            long ss = ((long)HHmmssSSS.intValue() - HH * 10000000L - mm * 100000L) / 1000L;
            long SSS = (long)HHmmssSSS.intValue() - HH * 10000000L - mm * 100000L - ss * 1000L;
            BcTimeUtil.setTimeField(calendar, (int)HH, (int)mm, (int)ss, (int)SSS);
        }
    }

    public static void setTimeField(Calendar calendar, Integer HHmmss) {
        if (HHmmss == null) {
            BcTimeUtil.setTimeField(calendar, 0, 0, 0);
        } else {
            int HH = HHmmss / 10000;
            int mm = (HHmmss - HH * 10000) / 100;
            int ss = HHmmss - HH * 10000 - mm * 100;
            BcTimeUtil.setTimeField(calendar, HH, mm, ss);
        }
    }

    public static void setTimeField(Calendar calendar, Short HHmm) {
        if (HHmm == null) {
            BcTimeUtil.setTimeField(calendar, 0, 0, 0);
        } else {
            int HH = HHmm / 100;
            int mm = HHmm - HH * 100;
            BcTimeUtil.setTimeField(calendar, HH, mm, 0);
        }
    }

    public static void copyDateField(Calendar calendar1, Calendar calendar2) {
        calendar2.set(1, calendar1.get(1));
        calendar2.set(2, calendar1.get(2));
        calendar2.set(5, calendar1.get(5));
        BcTimeUtil.copyTimeField(calendar1, calendar2);
    }

    public static void copyTimeField(Calendar calendar1, Calendar calendar2) {
        calendar2.set(11, calendar1.get(11));
        calendar2.set(12, calendar1.get(12));
        calendar2.set(13, calendar1.get(13));
        calendar2.set(14, calendar1.get(14));
    }

    protected static Calendar choice(boolean isMin, Calendar ... calendars) {
        Calendar calendar1 = null;
        int i = 0;
        while (i < calendars.length) {
            Calendar calendar2 = calendars[i];
            if (calendar1 != null) {
                if (calendar2 != null) {
                    if (isMin) {
                        if (calendar2.before(calendar1)) {
                            calendar1 = calendar2;
                        }
                    } else if (calendar2.after(calendar1)) {
                        calendar1 = calendar2;
                    }
                }
            } else if (calendar2 != null) {
                calendar1 = calendar2;
            }
            ++i;
        }
        return calendar1;
    }

    public static Calendar min(Calendar ... calendars) {
        return BcTimeUtil.choice(true, calendars);
    }

    public static Calendar max(Calendar ... calendars) {
        return BcTimeUtil.choice(false, calendars);
    }

    public static int compare(Calendar calendar1, Calendar calendar2) {
        if (calendar1 == null) {
            if (calendar2 == null) {
                return BcCompareUtil.Comparison.equals.value;
            }
            return BcCompareUtil.Comparison.small.value;
        }
        if (calendar2 == null) {
            return BcCompareUtil.Comparison.big.value;
        }
        return calendar1.compareTo(calendar2);
    }

    public static int compareDate(Calendar date1, Calendar date2) {
        int x2;
        int x1 = (date1.get(1) * 100 + date1.get(2) + 1) * 100 + date1.get(5);
        if (x1 > (x2 = (date2.get(1) * 100 + date2.get(2) + 1) * 100 + date2.get(5))) {
            return BcCompareUtil.Comparison.big.value;
        }
        if (x1 == x2) {
            return BcCompareUtil.Comparison.equals.value;
        }
        return BcCompareUtil.Comparison.small.value;
    }

    public static boolean isSameMonth(Calendar calendar1, Calendar calendar2) {
        if (calendar1 == null) {
            return calendar2 == null;
        }
        if (calendar2 == null) {
            return false;
        }
        return calendar1.get(1) == calendar2.get(1) && calendar1.get(2) == calendar2.get(2);
    }

    public static boolean isMaxDate(Calendar calendar) {
        int yyyy = calendar.get(1);
        int MM = calendar.get(2) + 1;
        int dd = calendar.get(5);
        return yyyy == 10007 && MM == 6 && dd == 7;
    }

    public static int toYyyyMM(int yyyy, int MM) {
        int yyyyMM = yyyy * (int)Math.pow(10.0, 2.0) + MM;
        return yyyyMM;
    }

    public static int toYyyyMM(Calendar calendar) {
        if (calendar == null) {
            return 0;
        }
        return BcTimeUtil.toYyyyMM(calendar.get(1), calendar.get(2) + 1);
    }

    public static int toYyyyMMdd(int yyyy, int MM, int dd) {
        if (yyyy == 10007 && MM == 6 && dd == 7) {
            return 99999999;
        }
        if (yyyy == 99999 && MM == 99 && dd == 99) {
            return 99999999;
        }
        int yyyyMM = BcTimeUtil.toYyyyMM(yyyy, MM) * (int)Math.pow(10.0, 2.0) + dd;
        return yyyyMM;
    }

    public static int toYyyyMMdd(String yyyy, String MM, String dd) {
        return BcTimeUtil.toYyyyMMdd(Integer.parseInt(yyyy), Integer.parseInt(MM), Integer.parseInt(dd));
    }

    public static int toYyyyMMdd(Calendar calendar) {
        if (calendar == null) {
            return 0;
        }
        return BcTimeUtil.toYyyyMMdd(calendar.get(1), calendar.get(2) + 1, calendar.get(5));
    }

    public static int toYyyyMMdd(Date date) throws Exception {
        if (date == null) {
            return 0;
        }
        return BcTimeUtil.toYyyyMMdd(BcTimeUtil.toCalendar(date.getTime()));
    }

    public static int toYyyyMMdd(LocalDate localDate) throws Exception {
        if (localDate == null) {
            return 0;
        }
        return BcTimeUtil.toYyyyMMdd(localDate.getYear(), localDate.getMonthValue(), localDate.getDayOfMonth());
    }

    public static int toYyMMdd(Calendar calendar) {
        if (calendar == null) {
            return 0;
        }
        String yyMMddStr = BcTimeUtil.toString(calendar, FORMAT_yyMMdd);
        return Integer.parseInt(yyMMddStr);
    }

    public static short toHHmm(int HH, int mm) {
        int hhmm = HH * (int)Math.pow(10.0, 2.0) + mm;
        return (short)hhmm;
    }

    public static short toHHmm(Calendar calendar) {
        if (calendar == null) {
            return 0;
        }
        return BcTimeUtil.toHHmm(calendar.get(11), calendar.get(12));
    }

    public static short toHHmm(String HH, String mm) throws Exception {
        return BcTimeUtil.toHHmm(Integer.parseInt(HH), Integer.parseInt(mm));
    }

    public static Short toHHmm2(Calendar calendar) throws Exception {
        if (calendar == null) {
            return null;
        }
        return new Short(BcTimeUtil.toHHmm(calendar));
    }

    public static int toHHmmss(int HH, int mm, int ss) {
        int hhmmss = BcTimeUtil.toHHmm(HH, mm) * (int)Math.pow(10.0, 2.0) + ss;
        return hhmmss;
    }

    public static int toHHmmss(Calendar calendar) {
        if (calendar == null) {
            return 0;
        }
        return BcTimeUtil.toHHmmss(calendar.get(11), calendar.get(12), calendar.get(13));
    }

    public static int toHHmmssSSS(int HH, int mm, int ss, int SSS) {
        int hhmmssSSS = BcTimeUtil.toHHmmss(HH, mm, ss) * (int)Math.pow(10.0, 3.0) + SSS;
        return hhmmssSSS;
    }

    public static int toHHmmssSSS(Calendar calendar) {
        if (calendar == null) {
            return 0;
        }
        return BcTimeUtil.toHHmmssSSS(calendar.get(11), calendar.get(12), calendar.get(13), calendar.get(14));
    }

    public static int add_yyyyMMdd(int yyyyMMdd, int field, int amount) throws Exception {
        Calendar calendar = BcTimeUtil.toCalendar(yyyyMMdd);
        calendar.add(field, amount);
        return BcTimeUtil.toYyyyMMdd(calendar);
    }

    public static int dayCount(Calendar calendar1, Calendar calendar2) throws Exception {
        if (calendar1 == null || calendar2 == null) {
            return 0;
        }
        double dayCount = (calendar2.getTimeInMillis() - calendar1.getTimeInMillis()) / 86400000L;
        return (int)dayCount;
    }

    public static int dayCount(int yyyyMMdd1, int yyyyMMdd2) throws Exception {
        Calendar calendar1 = BcTimeUtil.toCalendar(yyyyMMdd1);
        Calendar calendar2 = BcTimeUtil.toCalendar(yyyyMMdd2);
        return BcTimeUtil.dayCount(calendar1, calendar2);
    }

    public static long periodMilliSecounds(Calendar time1, Calendar time2) throws Exception {
        if (time1 == null || time2 == null) {
            return 0L;
        }
        long milliSecounds = time2.getTimeInMillis() - time1.getTimeInMillis();
        return milliSecounds;
    }

    public static long periodMilliSecounds(int yyyyMMdd1, int yyyyMMdd2) throws Exception {
        return BcTimeUtil.periodMilliSecounds(BcTimeUtil.toCalendar(yyyyMMdd1), BcTimeUtil.toCalendar(yyyyMMdd2));
    }

    public static int yyToYbase(int yy, int y2Base) {
        String tmpStr = Integer.toString(yy);
        int baseYear = -1;
        switch (tmpStr.length()) {
            case 0: 
            case 1: 
            case 2: {
                if (yy <= y2Base) {
                    baseYear = 2000;
                    break;
                }
                baseYear = 1900;
                break;
            }
            case 3: {
                baseYear = 1000;
                break;
            }
            case 4: {
                baseYear = 0;
            }
        }
        return baseYear;
    }

    public static int toHourOfDay(int hh, String ampm) throws Exception {
        if (BcStringUtil.isEmpty(ampm)) {
            return hh;
        }
        String ampm2 = ampm.toLowerCase();
        ampm2 = BcStringUtil.toLatinBasic(ampm2, 2).toString();
        if (hh > 12) {
            throw new Exception("hour rang over. '" + hh + "'");
        }
        int resVal = 0;
        if (ampm2.equals("am") || ampm2.equals("\u5348\u524d")) {
            resVal = hh;
        } else if (ampm2.equals("pm") || ampm2.equals("\u5348\u5f8c")) {
            resVal = hh + 12;
        }
        return resVal;
    }

    public static Calendar setMonthStart(Calendar calendar) {
        calendar.set(calendar.get(1), calendar.get(2), 1);
        return calendar;
    }

    public static Calendar toMonthStart(Calendar calendar) {
        Calendar calendar2 = (Calendar)calendar.clone();
        BcTimeUtil.setMonthStart(calendar2);
        return calendar2;
    }

    public static int toMonthStart_YyyyMMdd(Calendar calendar) {
        Calendar calendar2 = BcTimeUtil.toMonthStart(calendar);
        return BcTimeUtil.toYyyyMMdd(calendar2);
    }

    public static int toMonthStart(int yyyyMMdd) throws Exception {
        Calendar calendar = BcTimeUtil.toCalendar(yyyyMMdd);
        return BcTimeUtil.toMonthStart_YyyyMMdd(calendar);
    }

    public static void setMonthEnd(Calendar calendar) {
        calendar.set(calendar.get(1), calendar.get(2), calendar.getActualMaximum(5));
    }

    public static Calendar toMonthEnd(Calendar calendar) {
        Calendar calendar2 = (Calendar)calendar.clone();
        BcTimeUtil.setMonthEnd(calendar2);
        return calendar2;
    }

    public static int toMonthEnd_YyyyMMdd(Calendar calendar) {
        Calendar calendar2 = BcTimeUtil.toMonthEnd(calendar);
        return BcTimeUtil.toYyyyMMdd(calendar2);
    }

    public static int toMonthEnd(int yyyyMMdd) throws Exception {
        Calendar calendar = BcTimeUtil.toCalendar(yyyyMMdd);
        return BcTimeUtil.toMonthEnd_YyyyMMdd(calendar);
    }

    public static boolean isEndOfMonth(Calendar calendar) {
        return calendar.get(5) == calendar.getActualMaximum(5);
    }

    public static int differenceMonth(Calendar cal1, Calendar cal2) {
        Calendar cal1Clone = (Calendar)cal1.clone();
        Calendar cal2Clone = (Calendar)cal2.clone();
        cal1Clone.set(5, 1);
        cal2Clone.set(5, 1);
        int count = 0;
        if (cal1Clone.before(cal2Clone)) {
            while (cal1Clone.before(cal2Clone)) {
                cal1Clone.add(2, 1);
                ++count;
            }
        } else {
            ++count;
            while (!cal1Clone.before(cal2Clone)) {
                cal1Clone.add(2, -1);
                --count;
            }
        }
        return count;
    }

    public static boolean isStrict(Calendar calendar) {
        boolean isStrict = false;
        Calendar calendarWk = (Calendar)calendar.clone();
        calendarWk.setLenient(false);
        try {
            calendarWk.get(1);
            calendarWk.get(2);
            calendarWk.get(5);
            calendarWk.get(11);
            calendarWk.get(12);
            calendarWk.get(13);
            calendarWk.get(14);
            isStrict = true;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return isStrict;
    }

    public static int toHalfId(int startMonthId, int monthId) {
        int tmpMonthId = monthId;
        if (monthId < startMonthId) {
            tmpMonthId = monthId + 12;
        }
        return (tmpMonthId - startMonthId) / 6;
    }

    public static int toFiscalYear(Calendar calendar, int startMonthId) {
        int fiscalYear = calendar.get(1);
        int monthId = calendar.get(2);
        if (monthId < startMonthId) {
            --fiscalYear;
        }
        return fiscalYear;
    }

    public static int toFiscalYear(int yyyyMMdd, int startMonthId) throws Exception {
        Calendar calendar = BcTimeUtil.toCalendar(yyyyMMdd);
        if (calendar == null) {
            return -1;
        }
        return BcTimeUtil.toFiscalYear(calendar, startMonthId);
    }

    public static int[] toFiscalYear(int yyyyMMdd1, int yyyyMMdd2, int startMonthId) throws Exception {
        int[] fiscalYears = new int[2];
        if (yyyyMMdd1 > 0) {
            fiscalYears[0] = BcTimeUtil.toFiscalYear(BcTimeUtil.toCalendar(yyyyMMdd1), startMonthId);
        }
        if (yyyyMMdd2 > 0) {
            fiscalYears[1] = BcTimeUtil.toFiscalYear(BcTimeUtil.toCalendar(yyyyMMdd2), startMonthId);
        }
        return fiscalYears;
    }

    public static Calendar toFiscalYearStart(int year, int startMonthId) {
        Calendar calendar = BcTimeUtil.createCalendar();
        calendar.set(year, startMonthId, 1);
        return calendar;
    }

    public static Calendar toFiscalYearEnd(int year, int startMonthId) {
        Calendar calendar = BcTimeUtil.createCalendar();
        calendar.set(year, startMonthId + 11, 1);
        int dayMax = calendar.getActualMaximum(5);
        calendar.set(year, startMonthId + 11, dayMax);
        return calendar;
    }

    public static int toQuarterId(int startMonthId, int monthId) {
        int tmpMonthId = monthId;
        if (monthId < startMonthId) {
            tmpMonthId = monthId + 12;
        }
        return (tmpMonthId - startMonthId) / 3;
    }

    public static int toQuarterId(int startMonthId, Calendar calendar) {
        return BcTimeUtil.toQuarterId(startMonthId, calendar.get(2));
    }

    public static int toQuarterStartMonthId(int startMonthId, int quarterId) {
        int quarterStartMionthId = quarterId * 3 + startMonthId;
        if (quarterStartMionthId >= 12) {
            quarterStartMionthId -= 12;
        }
        return quarterStartMionthId;
    }

    public static int toQuarterEndMonthId(int startMonthId, int quarterId) {
        int quarterStartMionthId = quarterId * 3 + startMonthId + 2;
        if (quarterStartMionthId >= 12) {
            quarterStartMionthId -= 12;
        }
        return quarterStartMionthId;
    }

    public static int toFfffMM(int startMonthId, int yyyyMMdd) throws Exception {
        Calendar calendar = BcTimeUtil.toCalendar(yyyyMMdd);
        int ffff = calendar.get(1);
        int monthId = calendar.get(2);
        if (monthId < startMonthId) {
            --ffff;
        }
        return BcTimeUtil.toYyyyMM(ffff, monthId + 1);
    }

    public static int toFfffQ(int startMonthId, int yyyyMMdd) throws Exception {
        Calendar calendar = BcTimeUtil.toCalendar(yyyyMMdd);
        int yyyy = calendar.get(1);
        int monthId = calendar.get(2);
        int qId = BcTimeUtil.toQuarterId(startMonthId, monthId);
        if (monthId < startMonthId) {
            --yyyy;
        }
        String str = String.valueOf(Integer.toString(yyyy)) + Integer.toString(qId);
        return Integer.parseInt(str);
    }

    public static Calendar toDayOfWeekMostNearly(Calendar calendar, int dayOfWeekId) throws Exception {
        int gap = calendar.get(7) - dayOfWeekId;
        Calendar calendar2 = (Calendar)calendar.clone();
        calendar2.add(5, gap);
        return calendar2;
    }

    public static String toString(Calendar calendar, DateFormat dateFormat) {
        if (calendar == null) {
            return EMPTY_STRING;
        }
        Calendar calendarWK = (Calendar)calendar.clone();
        calendarWK.setLenient(true);
        return dateFormat.format(calendarWK.getTime());
    }

    public static String toString(Calendar calendar, String format, Locale locale) {
        if (calendar == null) {
            return EMPTY_STRING;
        }
        if (BcStringUtil.isEmpty(format)) {
            format = FORMAT_dateTime;
        }
        if (format.equals("yyyy'\u5e74'M'\u6708'd'\u65e5'")) {
            int yyyy = calendar.get(1);
            int mm = calendar.get(2) + 1;
            int dd = calendar.get(5);
            return String.valueOf(yyyy) + "\u5e74" + mm + "\u6708" + dd + "\u65e5";
        }
        SimpleDateFormat dateFormat = null;
        dateFormat = locale != null ? new SimpleDateFormat(format, locale) : new SimpleDateFormat(format, Locale.getDefault());
        return BcTimeUtil.toString(calendar, dateFormat);
    }

    public static String toString(Calendar calendar, String format) {
        return BcTimeUtil.toString(calendar, format, null);
    }

    public static String toString(Calendar calendar) {
        return BcTimeUtil.toString(calendar, FORMAT_dateTime);
    }

    public static String toString(Date date, String format) {
        Calendar calendar = BcTimeUtil.createCalendar();
        calendar.setTime(date);
        return BcTimeUtil.toString(calendar, format);
    }

    public static String toString(Date date) {
        Calendar calendar = BcTimeUtil.createCalendar();
        calendar.setTime(date);
        return BcTimeUtil.toString(calendar);
    }

    public static String toString(long millis, String format, Locale locale) {
        Calendar calendar = BcTimeUtil.createCalendar();
        calendar.setTimeInMillis(millis);
        return BcTimeUtil.toString(calendar, format, locale);
    }

    public static String toString(long millis, String format) {
        return BcTimeUtil.toString(millis, format, null);
    }

    public static String toString(int yyyyMMdd, String format) throws Exception {
        Calendar calendar = BcTimeUtil.toCalendar(yyyyMMdd);
        return BcTimeUtil.toString(calendar, format, null);
    }

    public static String toString(Integer yyyyMMdd, String format) throws Exception {
        if (yyyyMMdd != null) {
            return BcTimeUtil.toString((int)yyyyMMdd, format);
        }
        return EMPTY_STRING;
    }

    public static String toString(Integer yyyyMMdd, String dateFormat, Short HHmm, String timeFormat) throws Exception {
        StringBuilder sb = new StringBuilder();
        Calendar calendar = BcTimeUtil.toCalendar(yyyyMMdd);
        sb.append(BcTimeUtil.toString(calendar, dateFormat));
        if (HHmm != null) {
            BcTimeUtil.setTimeField(calendar, HHmm);
            sb.append(" ");
            sb.append(BcTimeUtil.toString(calendar, timeFormat));
        }
        return sb.toString();
    }

    public static String toString(Integer yyyyMMdd, Short HHmm) throws Exception {
        return BcTimeUtil.toString(yyyyMMdd, FORMAT_yyyy_MM_dd, HHmm, FORMAT_HH_mm);
    }

    public static String currentTimeToString(String format, Locale locale) throws Exception {
        Calendar calendar = BcTimeUtil.createCalendar();
        return BcTimeUtil.toString(calendar, format, locale);
    }

    public static String currentTimeToString(String format) throws Exception {
        return BcTimeUtil.currentTimeToString(format, null);
    }

    public static String toStringFromHHmmssSSS(int HHmmssSSS, String format) throws Exception {
        Calendar calendar = BcTimeUtil.createCalendar();
        BcTimeUtil.setTimeFieldHHmmssSSS(calendar, HHmmssSSS);
        return BcTimeUtil.toString(calendar, format);
    }

    public static String toStringFromHHmmss(Integer HHmmss, String format) throws Exception {
        Calendar calendar = BcTimeUtil.createCalendar();
        BcTimeUtil.setTimeField(calendar, HHmmss);
        return BcTimeUtil.toString(calendar, format);
    }

    public static String toStringFromHHmm(Short HHmm, String format) throws Exception {
        Calendar calendar = BcTimeUtil.createCalendar();
        BcTimeUtil.setTimeField(calendar, HHmm * 100);
        return BcTimeUtil.toString(calendar, format);
    }

    public static List<Calendar> createStartDateList(int fiscalYear, int startMonth) throws Exception {
        Calendar calendar = BcTimeUtil.toFiscalYearStart(fiscalYear, startMonth);
        ArrayList<Calendar> calendarList = new ArrayList<Calendar>();
        int i = 0;
        while (i < 12) {
            Calendar calendarWk = (Calendar)calendar.clone();
            calendarWk.add(2, i);
            calendarList.add(calendarWk);
            ++i;
        }
        return calendarList;
    }

    public static List<Calendar> createMonthList(Calendar calendar1, Calendar calendar2) throws Exception {
        Calendar calendarWk = (Calendar)calendar1.clone();
        ArrayList<Calendar> calendarList = new ArrayList<Calendar>();
        while (true) {
            calendarList.add(calendarWk);
            if (BcTimeUtil.isSameMonth(calendarWk, calendar2) || calendarWk.after(calendar2)) break;
            calendarWk = (Calendar)calendarWk.clone();
            calendarWk.add(2, 1);
        }
        return calendarList;
    }

    public static List<Calendar> createMonthList_YyyyMM(int yyyyMM1, int yyyyMM2) throws Exception {
        Calendar calendar1 = BcTimeUtil.toCalendarFromYyyyMM(yyyyMM1);
        Calendar calendar2 = BcTimeUtil.toCalendarFromYyyyMM(yyyyMM2);
        return BcTimeUtil.createMonthList(calendar1, calendar2);
    }

    public static List<Calendar> createMonthList_yyyyMMdd(int yyyyMMdd1, int yyyyMMdd2) throws Exception {
        Calendar calendar1 = BcTimeUtil.toCalendar(yyyyMMdd1);
        Calendar calendar2 = BcTimeUtil.toCalendar(yyyyMMdd2);
        return BcTimeUtil.createMonthList(calendar1, calendar2);
    }

    public static long toLong(Calendar calendar, String format, Locale locale) {
        if (calendar == null || BcStringUtil.isEmpty(format) || locale == null) {
            return 0L;
        }
        String strDate = BcTimeUtil.toString(calendar, format, locale);
        return new Long(strDate);
    }

    public static long toLong(Calendar calendar, String format) {
        if (calendar == null || BcStringUtil.isEmpty(format)) {
            return 0L;
        }
        return BcTimeUtil.toLong(calendar, format, Locale.getDefault());
    }

    public static void setEpochDate(Calendar calendar) {
        calendar.set(1, 1970);
        calendar.set(2, 0);
        calendar.set(5, 1);
    }

    public static Calendar createEpochCalendar() {
        Calendar calendar = BcTimeUtil.createCalendar();
        BcTimeUtil.setEpochDate(calendar);
        BcTimeUtil.initTimeField(calendar);
        return calendar;
    }

    public static TimeStructure toTimeStructure(long milliSecounds) {
        TimeStructure timeStructure = new TimeStructure();
        timeStructure.hour = milliSecounds / 3600000L;
        timeStructure.minute = (milliSecounds - 3600000L * timeStructure.hour) / 60000L;
        timeStructure.second = (milliSecounds - 3600000L * timeStructure.hour - 60000L * timeStructure.minute) / 1000L;
        timeStructure.milliSecond = milliSecounds - 3600000L * timeStructure.hour - 60000L * timeStructure.minute - timeStructure.second * 1000L;
        return timeStructure;
    }

    public static String toDurationString(TimeStructure timeStructure, boolean millis) {
        StringBuilder sb = new StringBuilder();
        sb.append(BcStringUtil.fillPrefix((int)timeStructure.hour, 2, '0'));
        sb.append(TIME_DELIMITER);
        sb.append(BcStringUtil.fillPrefix((int)timeStructure.minute, 2, '0'));
        sb.append(TIME_DELIMITER);
        sb.append(BcStringUtil.fillPrefix((int)timeStructure.second, 2, '0'));
        if (millis) {
            sb.append(MILLIS_DELIMITER);
            sb.append(BcStringUtil.fillPrefix((int)timeStructure.second, 2, '0'));
        }
        return sb.toString();
    }

    public static String toDurationString(long milliSecounds, boolean millis) {
        TimeStructure timeStructure = BcTimeUtil.toTimeStructure(milliSecounds);
        return BcTimeUtil.toDurationString(timeStructure, millis);
    }

    public static String toDurationString(long milliSecounds) {
        return BcTimeUtil.toDurationString(milliSecounds, false);
    }

    public static String toDurationString2(long milliSecounds) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append(BcNumberUtil.toString(milliSecounds));
        sb.append("(ms)=");
        sb.append(BcTimeUtil.toDurationString(milliSecounds));
        return sb.toString();
    }

    public static String toDurationString2(int secounds) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append(BcNumberUtil.toString(secounds));
        sb.append("(s)=");
        sb.append(BcTimeUtil.toDurationString(secounds * 1000));
        return sb.toString();
    }

    public static String toPeriodString(Calendar cal1, Calendar cal2, String format, String sep) throws Exception {
        if (cal1 == null && cal2 == null) {
            return EMPTY_STRING;
        }
        StringBuilder sb = new StringBuilder();
        if (cal1 != null) {
            sb.append(BcTimeUtil.toString(cal1, format));
        }
        sb.append(sep);
        if (cal2 != null) {
            sb.append(BcTimeUtil.toString(cal2, format));
        }
        return sb.toString();
    }

    public static String toPeriodString(Calendar time1, Calendar time2, String format) throws Exception {
        return BcTimeUtil.toPeriodString(time1, time2, format, " \uff5e ");
    }

    public static String toPeriodString(int date1, int date2, String format) throws Exception {
        return BcTimeUtil.toPeriodString(BcTimeUtil.toCalendar(date1), BcTimeUtil.toCalendar(date2), format);
    }

    public static String toUsTime(String timeStr) throws Exception {
        Date date = null;
        SimpleDateFormat dateFormat = new SimpleDateFormat(FORMAT_HH_mm_ss, new Locale("en", "US"));
        date = dateFormat.parse(timeStr);
        Calendar calendar = BcTimeUtil.createCalendar();
        calendar.setTime(date);
        String tmp = BcTimeUtil.toString(calendar, "hh:mm:ss a");
        tmp = BcStringUtil.replace((CharSequence)tmp, "\u5348\u524d", "AM").toString();
        tmp = BcStringUtil.replace((CharSequence)tmp, "\u5348\u5f8c", "PM").toString();
        return tmp;
    }

    public static BcPeriod toCalendarPeriod(int year, int month, int startWeekId) throws Exception {
        BcPeriod period = new BcPeriod();
        Calendar monthStart = BcTimeUtil.toCalendarMonthId(year, month - 1, 1);
        Calendar monthEnd = (Calendar)monthStart.clone();
        BcTimeUtil.setMonthEnd(monthEnd);
        int gap1 = startWeekId - monthStart.get(7);
        int gap2 = Math.abs(gap1) * -1;
        period.start = (Calendar)monthStart.clone();
        period.start.add(5, gap2);
        int dayCount = BcTimeUtil.dayCount(period.start, monthEnd) + 1;
        int rowCount = (int)Math.ceil((double)dayCount / 7.0);
        int rest = 7 * rowCount - dayCount;
        BcLogUtil.debug("dayCount=" + dayCount + " rowCount=" + rowCount + " rest=" + rest);
        period.end = (Calendar)monthEnd.clone();
        period.end.add(5, rest);
        return period;
    }

    public static enum Format {
        dateTime_us("MM-dd-yyyy HH:mm:ss", "Date Time US"),
        date_us("MM-dd-yyyy", "Date US"),
        fffffffff("fffffffff", "nano8");

        public final String format;
        public final String note;

        private Format(String format, String note) {
            this.format = format;
            this.note = note;
        }
    }

    public static class TimeStructure {
        public long hour;
        public long minute;
        public long second;
        public long milliSecond;
    }
}

