/*
 * Decompiled with CFR 0.152.
 */
package ext.module.xfil.rmo;

import ext.lib.datasource.DtsSession;
import ext.lib.rmi.common.RmiRemoteMethod;
import ext.lib.rmi.model.RmiRmoArgument;
import ext.lib.rmi.rmo.RmiAbstractRMO;
import ext.lib.sql.SqlConditionParser;
import ext.lib.sql.context.SqlContext;
import ext.lib.sql.model.SqlSelectQuery;
import ext.lib.sql.model.SqlWhereElement;
import ext.module.xfil.common.XfilConstants;
import ext.module.xfil.model.XfilAnalysisCondition;
import ext.module.xfil.server.XfilServerUtil;
import ext.scf3.rmo.ScfSqlUtil;
import ext.scf3.server.ScfQueryTask;
import java.util.ArrayList;

public class XfilCrawlListRMO
extends RmiAbstractRMO {
    String tableName = XfilConstants.TableName.xfil_crawl.name();

    public void crawlList(RmiRmoArgument rmoArg) throws Exception {
        XfilAnalysisCondition analysisCondition = (XfilAnalysisCondition)rmoArg.getRequest().getData();
        DtsSession dtsSession = XfilServerUtil.getInstance().createDtsSession(this);
        SqlContext sqlContext = dtsSession.getSqlContext();
        ScfQueryTask queryTask = ScfSqlUtil.createQueryTask(rmoArg, dtsSession);
        SqlSelectQuery selectQuery = new SqlSelectQuery();
        this.parseCondition(dtsSession, selectQuery, analysisCondition);
        this.getFromClause(selectQuery, analysisCondition, this.tableName);
        this.setColumnNameList(sqlContext, selectQuery, analysisCondition);
        this.setOrderByPhrase();
        queryTask.query = sqlContext.buildSelectQuery(selectQuery);
        queryTask.tableColumnNameList = selectQuery.getSelectColumnList();
        queryTask.tableContext.setConditionList(selectQuery.getConditionList());
        ScfSqlUtil.generalListNew(queryTask, (Object)this);
    }

    public void parseCondition(DtsSession dtsSession, SqlSelectQuery selectQuery, XfilAnalysisCondition analysisCondition) throws Exception {
        SqlContext sqlContext = dtsSession.getSqlContext();
        SqlWhereElement whereElement = SqlConditionParser.getInstance().parseCondition1(sqlContext, String.valueOf(this.tableName) + ".name_", String.valueOf(this.tableName) + ".name_", analysisCondition.crawlName, null, false);
        if (whereElement != null) {
            selectQuery.addWhereElement(whereElement);
        }
        if (analysisCondition.craw\uff4cPeriodStart > 0 || analysisCondition.craw\uff4cPeriodEnd > 0) {
            whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula(sqlContext.toCondition_period_date(String.valueOf(this.tableName) + ".start_date_time", analysisCondition.craw\uff4cPeriodStart, analysisCondition.craw\uff4cPeriodEnd));
            selectQuery.addWhereElement(whereElement);
        }
    }

    public void setColumnNameList(SqlContext sqlContext, SqlSelectQuery selectQuery, XfilAnalysisCondition analysisCondition) throws Exception {
        ArrayList<String> selectColumnNameList = new ArrayList<String>();
        selectColumnNameList.add(sqlContext.createTableColumnName(this.tableName, "id"));
        selectColumnNameList.add(sqlContext.createTableColumnName(this.tableName, "name_"));
        selectColumnNameList.add(sqlContext.createTableColumnName(this.tableName, "directory"));
        selectColumnNameList.add(sqlContext.createTableColumnName(this.tableName, "file_extention"));
        selectColumnNameList.add(sqlContext.createTableColumnName(this.tableName, "sc_interval_sec"));
        selectColumnNameList.add(sqlContext.createTableColumnName(this.tableName, "sc_top_margin_sec"));
        selectColumnNameList.add(sqlContext.createTableColumnName(this.tableName, "sc_botom_margin_sec"));
        selectColumnNameList.add(sqlContext.createTableColumnName(this.tableName, "sc_capturing_count_max"));
        selectColumnNameList.add(sqlContext.createTableColumnName(this.tableName, "sc_capturing_width"));
        selectColumnNameList.add(sqlContext.createTableColumnName(this.tableName, "sc_capturing_height"));
        selectColumnNameList.add(sqlContext.createTableColumnName(this.tableName, "start_date_time"));
        selectColumnNameList.add(sqlContext.createTableColumnName(this.tableName, "end_date_time"));
        selectColumnNameList.add(sqlContext.createTableColumnName(this.tableName, "directory_count"));
        selectColumnNameList.add(sqlContext.createTableColumnName(this.tableName, "file_count"));
        selectColumnNameList.add(sqlContext.createTableColumnName(this.tableName, "missing_count"));
        selectColumnNameList.add(sqlContext.createTableColumnName(this.tableName, "note_"));
        selectQuery.getSelectColumnList().addAll(selectColumnNameList);
    }

    public void getFromClause(SqlSelectQuery selectQuery, XfilAnalysisCondition analysisCondition, String tableName) throws Exception {
        String tmpFromClause = selectQuery.getFromClause();
        StringBuilder sb = new StringBuilder();
        sb.append(tableName);
        selectQuery.setFromClause(sb.toString());
    }

    public void setOrderByPhrase() {
    }

    public static enum Method implements RmiRemoteMethod
    {
        crawlList;


        @Override
        public String getMethodName() {
            return this.name();
        }
    }
}

