/*
 * Decompiled with CFR 0.152.
 */
package ext.module.xfil.common;

import ext.appfw.common.AfbConstants;
import ext.base.log.BcLogUtil;
import ext.base.util.BcCloneUtil;
import ext.base.util.BcProcessExecutor;
import ext.module.xfil.common.FfmpegUtil;
import ext.module.xfil.common.FfpegParam;
import ext.module.xfil.common.XfilCaptureParam;
import ext.module.xfil.model.XfilVCaptureCondition;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public final class XfilCaptureUtil {
    private XfilCaptureUtil() {
    }

    public static Object[] executeFfmpeg(FfpegParam ffpegParam) throws Exception {
        BcProcessExecutor.BcProcessResult processResult = FfmpegUtil.createImage(ffpegParam);
        ArrayList<File> fileList = null;
        if (processResult.exitValue == AfbConstants.ExitCode.OK.code) {
            fileList = new ArrayList<File>();
            fileList.add(new File(ffpegParam.outputPath));
        }
        Object[] res = new Object[]{processResult, fileList};
        return res;
    }

    public static void setParam(XfilCaptureParam videoCaptureParam, FfpegParam ffpegParam) throws Exception {
        ffpegParam.width = videoCaptureParam.width;
        ffpegParam.height = videoCaptureParam.height;
    }

    public static XfilCaptureParam convert(XfilVCaptureCondition videoCaptureCondition) throws Exception {
        XfilCaptureParam videoCaptureParam = new XfilCaptureParam();
        videoCaptureParam.width = videoCaptureCondition.capturingWidth;
        videoCaptureParam.height = videoCaptureCondition.capturingHeight;
        videoCaptureParam.top = videoCaptureCondition.topMarginSec * 1000;
        videoCaptureParam.bottom = videoCaptureCondition.botomMarginSec * 1000;
        videoCaptureParam.intervalMin = 180000L;
        videoCaptureParam.capturingCountMax = videoCaptureCondition.capturingCountMax;
        videoCaptureParam.capturingCountMin = 3;
        videoCaptureParam.interval = videoCaptureCondition.intervalSec * 1000;
        videoCaptureParam.elapsedTime = videoCaptureCondition.elapsedTime;
        videoCaptureParam.elapsedTimeHorizontalPositionId = videoCaptureCondition.elapsedTimeHorizontalPositionId;
        videoCaptureParam.elapsedTimeVerticalPositionId = videoCaptureCondition.elapsedTimeVerticalPositionId;
        return videoCaptureParam;
    }

    public static XfilCaptureParam adjustment(XfilCaptureParam videoCaptureParam1, long srcDuration) throws Exception {
        XfilCaptureParam videoCaptureParam2 = BcCloneUtil.createClone(videoCaptureParam1);
        long mainDuration = srcDuration - videoCaptureParam2.top - videoCaptureParam2.bottom;
        if (mainDuration <= videoCaptureParam2.top + videoCaptureParam2.bottom) {
            mainDuration = srcDuration;
        }
        videoCaptureParam2.capturingCount = (int)(mainDuration / videoCaptureParam2.interval);
        BcLogUtil.debug("#1:mainDuration=" + mainDuration + " interval=" + videoCaptureParam2.interval + " capturingCount=" + videoCaptureParam2.capturingCount);
        if (videoCaptureParam2.capturingCount > videoCaptureParam2.capturingCountMax) {
            videoCaptureParam2.capturingCount = videoCaptureParam2.capturingCountMax;
            videoCaptureParam2.interval = mainDuration / (long)videoCaptureParam2.capturingCount;
        }
        if (videoCaptureParam2.capturingCount < videoCaptureParam2.capturingCountMin) {
            videoCaptureParam2.capturingCount = videoCaptureParam2.capturingCountMin;
            videoCaptureParam2.interval = mainDuration / (long)videoCaptureParam2.capturingCount;
        }
        return videoCaptureParam2;
    }

    public static List<Long> calcStartTime(XfilCaptureParam screenCaptureParam) throws Exception {
        ArrayList<Long> startTimeMillisList = new ArrayList<Long>();
        int i = 0;
        while (i < screenCaptureParam.capturingCount) {
            long startTimeMillis = screenCaptureParam.top + screenCaptureParam.interval * (long)i;
            startTimeMillisList.add(startTimeMillis);
            ++i;
        }
        return startTimeMillisList;
    }
}

