/*
 * Decompiled with CFR 0.152.
 */
package ext.module.xfil.common;

import com.fasterxml.jackson.databind.JsonNode;
import ext.base.core.BcStringUtil;
import ext.base.log.BcLogUtil;
import ext.base.util.BcProcessExecutor;
import ext.lib.json.JacksonUtil;
import ext.module.xfil.common.FfprobeParamBuiler;
import ext.module.xfil.model.MovieInfo;
import java.io.File;
import java.util.List;

public final class FfprobeUtil {
    static BcProcessExecutor processExecutor = new BcProcessExecutor();
    public static String ffprobePath;

    private FfprobeUtil() {
    }

    public static Integer checkVersion() throws Exception {
        FfprobeUtil.checkSetting();
        FfprobeParamBuiler ffprobeParamBuiler = new FfprobeParamBuiler();
        List<String> argList = ffprobeParamBuiler.version().build();
        BcProcessExecutor.BcProcessResult processResult = processExecutor.execute(ffprobePath, argList);
        return processResult.exitValue;
    }

    public static List<String> createArgList(File imputFile) throws Exception {
        FfprobeParamBuiler ffprobeParamBuiler = new FfprobeParamBuiler();
        ffprobeParamBuiler.hide_banner();
        ffprobeParamBuiler.loglevel_error();
        ffprobeParamBuiler.show_streams();
        ffprobeParamBuiler.show_format();
        ffprobeParamBuiler.print_format(PrintFormat.json);
        List<String> argList = ffprobeParamBuiler.build();
        argList.add(imputFile.getPath());
        return argList;
    }

    public static MovieInfo getMovieInfo(File file) throws Exception {
        FfprobeUtil.checkSetting();
        List<String> argList = FfprobeUtil.createArgList(file);
        BcProcessExecutor.BcProcessResult processResult = processExecutor.execute(ffprobePath, argList);
        MovieInfo movieInfo = null;
        if (processResult.exitValue == 0) {
            movieInfo = FfprobeUtil.parce(processResult.out);
        }
        return movieInfo;
    }

    public static MovieInfo parce(String jsonStr) throws Exception {
        JsonNode jsonNode = null;
        try {
            jsonNode = JacksonUtil.getObjectMapper().readTree(jsonStr);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        JsonNode streams = jsonNode.get("streams");
        JsonNode stream_video = null;
        int i = 0;
        while (i < streams.size()) {
            JsonNode stream = streams.get(i);
            JsonNode codec_type = stream.get("codec_type");
            if (codec_type.asText().equals("video")) {
                stream_video = stream;
                break;
            }
            ++i;
        }
        MovieInfo movieInfo = new MovieInfo();
        movieInfo.note = jsonStr;
        movieInfo.width = -1;
        try {
            JsonNode width = stream_video.get("width");
            movieInfo.width = width.asInt();
        }
        catch (Exception width) {
            // empty catch block
        }
        movieInfo.height = -1;
        try {
            JsonNode height = stream_video.get("height");
            movieInfo.height = height.asInt();
        }
        catch (Exception height) {
            // empty catch block
        }
        BcLogUtil.debug("movieInfo.width=" + movieInfo.width + " movieInfo.height=" + movieInfo.height);
        JsonNode format = jsonNode.get("format");
        movieInfo.durationSec = -1.0;
        try {
            JsonNode duration = format.get("duration");
            movieInfo.durationSec = duration.asDouble();
        }
        catch (Exception exception) {
            // empty catch block
        }
        BcLogUtil.debug("movieInfo.durationSec=" + movieInfo.durationSec);
        return movieInfo;
    }

    public static void checkSetting() throws Exception {
        if (BcStringUtil.isEmpty(ffprobePath)) {
            throw new Exception("ffprobePath is empty.");
        }
        File file = new File(ffprobePath);
        if (!file.exists()) {
            throw new Exception("ffprobePath not exists.");
        }
    }

    public static enum PrintFormat {
        json;

    }
}

