/*
 * Decompiled with CFR 0.152.
 */
package ext.module.conp.dao;

import ext.base.util.BcCollectionUtil;
import ext.lib.datasource.DtsSession;
import ext.lib.orm.dao.OrmAbstractDAO;
import ext.lib.sql.SqlUtil;
import ext.lib.sql.context.SqlContext;
import ext.lib.sql.model.SqlSelectQuery;
import ext.lib.sql.model.SqlWhereElement;
import ext.module.conp.model.ConpGame;
import java.util.List;

public class ConpGameDAO
extends OrmAbstractDAO<ConpGame> {
    private ConpGameDAO() {
        super(new ConpGame[0]);
        this.setTableName("conp_game");
    }

    public static ConpGameDAO getInstance() {
        return SingletonHolder.instance;
    }

    public SqlSelectQuery createSelectSql(SqlContext sqlContext, Mode mode, String alias, long id, long tournamentId) throws Exception {
        SqlWhereElement whereElement;
        String aliasWk = SqlUtil.tableAliasToNotNull(alias);
        SqlSelectQuery selectQuery = new SqlSelectQuery();
        if (id > 0L) {
            whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula(String.valueOf(aliasWk) + "id = " + id);
            selectQuery.addWhereElement(whereElement);
        }
        if (tournamentId > 0L) {
            whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula(String.valueOf(aliasWk) + "tournament_id = " + tournamentId);
            selectQuery.addWhereElement(whereElement);
        }
        selectQuery.setFromClause(String.valueOf(this.getTableName()) + " AS " + alias);
        selectQuery.getOrderByList().add(String.valueOf(aliasWk) + mode.orderBy);
        return selectQuery;
    }

    public <T> List<T> getList(DtsSession dtsSession, Mode mode, long id, long tournamentId) throws Exception {
        SqlContext sqlContext = dtsSession.getSqlContext();
        String alias = "game";
        SqlSelectQuery selectQuery = this.createSelectSql(sqlContext, mode, alias, id, tournamentId);
        selectQuery.getSelectColumnList().addAll(this.getColumnNameList(alias));
        String query = sqlContext.buildSelectQuery(selectQuery);
        return this.getEntityList(dtsSession, query);
    }

    public <T> List<T> getListByTournamentId(DtsSession dtsSession, long tournamentId) throws Exception {
        long id = -1L;
        return this.getList(dtsSession, Mode.tournamentId, id, tournamentId);
    }

    public <T> T getById(DtsSession dtsSession, long id) throws Exception {
        long tournamentId = -1L;
        List<T> entityList = this.getList(dtsSession, Mode.id, id, tournamentId);
        return BcCollectionUtil.getFirst(entityList);
    }

    /* synthetic */ ConpGameDAO(ConpGameDAO conpGameDAO) {
        this();
    }

    public static enum Mode {
        id("id"),
        tournamentId("tournament_id, id");

        public final String orderBy;

        private Mode(String orderBy) {
            this.orderBy = orderBy;
        }
    }

    private static final class SingletonHolder {
        private static final ConpGameDAO instance = new ConpGameDAO(null);

        private SingletonHolder() {
        }
    }
}

