/*
 * Decompiled with CFR 0.152.
 */
package ext.lib.sql.context;

import ext.base.log.BcLoggableObject;
import ext.lib.sql.SqlConstants;
import ext.lib.sql.context.SqlContext;
import ext.lib.sql.context.SqlContext_Access;
import ext.lib.sql.context.SqlContext_DB2;
import ext.lib.sql.context.SqlContext_Derby;
import ext.lib.sql.context.SqlContext_H2;
import ext.lib.sql.context.SqlContext_HSQLDB;
import ext.lib.sql.context.SqlContext_MySQL;
import ext.lib.sql.context.SqlContext_Oracle;
import ext.lib.sql.context.SqlContext_PostgreSQL;
import ext.lib.sql.context.SqlContext_SQLServer;
import ext.lib.sql.context.SqlContext_UCanAccess;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

public class SqlContextFactory
extends BcLoggableObject {
    public static Map<String, SqlContext> sqlContextMap = new HashMap<String, SqlContext>();

    private SqlContextFactory() {
    }

    public static SqlConstants.DatabaseProduct getDatabaseProduct(String productName) throws Exception {
        SqlConstants.DatabaseProduct[] databaseProductArray = SqlConstants.DatabaseProduct.values();
        int n = databaseProductArray.length;
        int n2 = 0;
        while (n2 < n) {
            SqlConstants.DatabaseProduct databaseProduct = databaseProductArray[n2];
            if (productName.toUpperCase().startsWith(databaseProduct.productName.toUpperCase())) {
                return databaseProduct;
            }
            ++n2;
        }
        throw new SQLException("Not suppoted. productName=" + productName);
    }

    public static SqlContext createSqlContext(SqlConstants.DatabaseProduct databaseProduct) throws Exception {
        SqlContext sqlContext = null;
        switch (databaseProduct) {
            case H2: {
                sqlContext = new SqlContext_H2(databaseProduct);
                break;
            }
            case PostgreSQL: {
                sqlContext = new SqlContext_PostgreSQL(databaseProduct);
                break;
            }
            case MySQL: {
                sqlContext = new SqlContext_MySQL(databaseProduct);
                break;
            }
            case Oracle: {
                sqlContext = new SqlContext_Oracle(databaseProduct);
                break;
            }
            case DB2: {
                sqlContext = new SqlContext_DB2(databaseProduct);
                break;
            }
            case SQLServer: {
                sqlContext = new SqlContext_SQLServer(databaseProduct);
                break;
            }
            case Derby: {
                sqlContext = new SqlContext_Derby(databaseProduct);
                break;
            }
            case HSQLDB: {
                sqlContext = new SqlContext_HSQLDB(databaseProduct);
                break;
            }
            case Access: {
                sqlContext = new SqlContext_Access(databaseProduct);
                break;
            }
            case UCanAccess: {
                sqlContext = new SqlContext_UCanAccess(databaseProduct);
            }
        }
        return sqlContext;
    }

    public static SqlContext getSqlContext(SqlConstants.DatabaseProduct databaseProduct) throws Exception {
        SqlContext sqlContext = sqlContextMap.get(databaseProduct.productName);
        if (sqlContext == null) {
            sqlContext = SqlContextFactory.createSqlContext(databaseProduct);
            sqlContextMap.put(databaseProduct.productName, sqlContext);
        }
        return sqlContext;
    }

    public static SqlContext getSqlContext(Connection sqlConn) throws Exception {
        String productName = sqlConn.getMetaData().getDatabaseProductName();
        SqlConstants.DatabaseProduct databaseProduct = SqlContextFactory.getDatabaseProduct(productName);
        return SqlContextFactory.getSqlContext(databaseProduct);
    }

    public static SqlContext getSqlContext(int productId) throws Exception {
        SqlConstants.DatabaseProduct databaseProduct = SqlConstants.DatabaseProduct.getById(productId);
        return SqlContextFactory.getSqlContext(databaseProduct);
    }
}

