/*
 * Decompiled with CFR 0.152.
 */
package ext.lib.sql;

import ext.base.util.BcAbstractWords;
import ext.base.util.BcISO;
import ext.base.util.BcLocaleUtil;
import ext.base.util.BcWordPack;
import ext.base.util.BcWords;
import java.io.Serializable;

public class SqlWords
extends BcAbstractWords
implements Serializable {
    private static final long serialVersionUID = 8853036407113894149L;
    private static final SqlWords en = new SqlWords();
    private static SqlWords ja;
    public String dataSource = "Data Source";
    public String dataSourceName = String.valueOf(this.dataSource) + " Name";
    public BcWordPack dataType;
    public String driverClass;
    public String executeQuery;
    public String extractColumn;
    public String fromClause;
    public String jdbcUrl;
    public String key;
    public String orderByClause;
    public String product;
    public String productId;
    public String productName;
    public String query;
    public String index;
    public String insertSql;
    public String instance_;
    public String jdbcDriver;
    public String schema;
    public String sql;
    public String sql_TRUNCATE_TABLE;
    public String sql_DROP_TABLE;
    public String sql_DROP_VIEW;
    public BcWordPack sqlType;
    public String columnDefine;
    public String generate;
    public String updateQuery;
    public String generateInsertQuery;
    public String createTableSql;
    public String generateCreateTableSql;
    public String dataView;
    public String whereClause;
    public String sort;
    public String sortColumn;
    public String commit;
    public String jdbcType;
    public String view;
    public BcWordPack truncateTable;

    private SqlWords() {
        this.dataType = new BcWordPack(false, BcWords.getInstance().data, BcWords.getInstance().type);
        this.driverClass = "Driver Class";
        this.executeQuery = "Execute Query";
        this.extractColumn = "Extract Column";
        this.fromClause = "FROM Clause";
        this.jdbcUrl = "JDBC URL";
        this.key = "Key";
        this.orderByClause = "ORDER BY Clause";
        this.product = "Product";
        this.productId = String.valueOf(this.product) + " ID";
        this.productName = String.valueOf(this.product) + " " + BcWords.getInstance().name;
        this.query = "Query";
        this.index = "Index";
        this.insertSql = "'INSERT' SQL";
        this.instance_ = "Instance";
        this.jdbcDriver = "JDBC Driver";
        this.schema = "Schema";
        this.sql = "SQL";
        this.sql_TRUNCATE_TABLE = "TRUNCATE TABLE";
        this.sql_DROP_TABLE = "DROP TABLE";
        this.sql_DROP_VIEW = "DROP VIEW";
        this.sqlType = new BcWordPack(false, this.sql, "Type");
        this.columnDefine = String.valueOf(BcWords.getInstance().column) + " " + BcWords.getInstance().define;
        this.generate = "Generate";
        this.updateQuery = "UPDATE " + this.sql;
        this.generateInsertQuery = String.valueOf(this.generate) + " " + this.insertSql;
        this.createTableSql = "'CREATE TABLE' " + this.sql;
        this.generateCreateTableSql = String.valueOf(this.generate) + " " + this.createTableSql;
        this.dataView = "Data View";
        this.whereClause = "WHERE Clause";
        this.sort = "Sort";
        this.sortColumn = String.valueOf(this.sort) + " " + BcWords.getInstance().column;
        this.commit = "Commit";
        this.jdbcType = "JDBC Type";
        this.view = "View";
        this.truncateTable = new BcWordPack(false, "Truncate", BcWords.getInstance().table);
        this.setIso639(BcISO.ISO_639.English);
    }

    public static SqlWords getInstance(String langageCode) {
        SqlWords words = en;
        if (BcISO.ISO_639.Japanese.code.equalsIgnoreCase(langageCode)) {
            if (ja == null) {
                ja = new SqlWords();
                ja.setJapanese();
            }
            words = ja;
        }
        return words;
    }

    public static SqlWords getInstance(BcAbstractWords words) {
        return SqlWords.getInstance(words.getIso639().code);
    }

    public static SqlWords getInstance() {
        return SqlWords.getInstance(BcLocaleUtil.getIso639().code);
    }

    public void setJapanese() {
        this.setIso639(BcISO.ISO_639.Japanese);
        String langageCode = this.getIso639().code;
        this.dataSource = "\u30c7\u30fc\u30bf\u30bd\u30fc\u30b9";
        this.dataSourceName = String.valueOf(this.dataSource) + "\u540d";
        this.driverClass = "\u30c9\u30e9\u30a4\u30d0\u30af\u30e9\u30b9";
        this.executeQuery = "\u30af\u30a8\u30ea\u5b9f\u884c";
        this.extractColumn = "\u62bd\u51fa\u5217";
        this.fromClause = "FROM\u53e5";
        this.jdbcDriver = "JDBC\u30c9\u30e9\u30a4\u30d0";
        this.orderByClause = "ORDER BY\u53e5";
        this.product = "\u88fd\u54c1";
        this.productId = String.valueOf(this.product) + BcWords.getInstance((String)langageCode).id;
        this.productName = String.valueOf(this.product) + BcWords.getInstance((String)langageCode).name;
        this.query = "\u30af\u30a8\u30ea";
        this.instance_ = "\u30a4\u30f3\u30b9\u30bf\u30f3\u30b9";
        this.schema = "\u30b9\u30ad\u30fc\u30de";
        this.sqlType = new BcWordPack(false, this.sql, "\u30bf\u30a4\u30d7");
        this.columnDefine = String.valueOf(BcWords.getInstance((String)langageCode).column) + BcWords.getInstance((String)langageCode).define;
        this.updateQuery = "\u66f4\u65b0SQL";
        this.generateInsertQuery = "INSERT \u30af\u30a8\u30ea\u751f\u6210";
        this.generateCreateTableSql = "CREATE TABLE \u30af\u30a8\u30ea\u751f\u6210";
        this.dataView = "\u30c7\u30fc\u30bf\u30d3\u30e5\u30fc";
        this.sql = "SQL";
        this.whereClause = "WHERE\u53e5";
        this.sort = "\u30bd\u30fc\u30c8";
        this.sortColumn = String.valueOf(this.sort) + BcWords.getInstance((String)langageCode).column;
        this.commit = "\u30b3\u30df\u30c3\u30c8";
        this.jdbcType = "JDBC\u578b";
        this.view = "\u30d3\u30e5\u30fc";
    }
}

