/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.codec.video.cinepak;

import com.ibm.media.codec.video.VideoCodec;
import com.sun.media.JMFSecurityManager;
import com.sun.media.NBA;
import com.sun.media.util.Arch;
import java.awt.Dimension;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.ResourceUnavailableException;
import javax.media.format.RGBFormat;
import javax.media.format.VideoFormat;

public final class NativeDecoder
extends VideoCodec {
    private int rMask = 255;
    private int gMask = 65280;
    private int bMask = 0xFF0000;
    private NBA refData;
    private int nativeData;
    private int[] colorMap = null;

    private native boolean initNative(int var1, int var2, int var3, int var4);

    private native boolean freeNative();

    private native boolean decodeNative(int var1, Object var2, long var3, Object var5, long var6, int var8);

    public NativeDecoder() {
        this.supportedInputFormats = new VideoFormat[]{new VideoFormat("cvid")};
        this.defaultOutputFormats = new VideoFormat[]{new RGBFormat(null, -1, Format.intArray, -1.0f, 32, 255, 65280, 0xFF0000, 1, -1, 0, -1), new RGBFormat(null, -1, Format.intArray, -1.0f, 32, 0xFF0000, 65280, 255, 1, -1, 0, -1), new RGBFormat(null, -1, Format.shortArray, -1.0f, 16, 63488, 2016, 31, 1, -1, 0, -1), new RGBFormat(null, -1, Format.shortArray, -1.0f, 16, 31744, 992, 31, 1, -1, 0, -1), new RGBFormat(null, -1, Format.byteArray, -1.0f, 24, 1, 2, 3, 3, -1, 0, -1), new RGBFormat(null, -1, Format.byteArray, -1.0f, 24, 3, 2, 1, 3, -1, 0, -1)};
        this.PLUGIN_NAME = "Cinepak Decoder";
    }

    protected Format[] getMatchingOutputFormats(Format in) {
        VideoFormat ivf = (VideoFormat)in;
        Dimension inSize = ivf.getSize();
        int lineStride = inSize.width + 3 & 0xFFFFFFFC;
        int rowStride = inSize.height + 3 & 0xFFFFFFFC;
        int length = lineStride * rowStride;
        this.supportedOutputFormats = new VideoFormat[]{new RGBFormat(inSize, length, Format.intArray, ivf.getFrameRate(), 32, 255, 65280, 0xFF0000, 1, lineStride, 0, -1), new RGBFormat(inSize, length, Format.intArray, ivf.getFrameRate(), 32, 0xFF0000, 65280, 255, 1, lineStride, 0, -1), new RGBFormat(inSize, length, Format.shortArray, ivf.getFrameRate(), 16, 63488, 2016, 31, 1, lineStride, 0, -1), new RGBFormat(inSize, length, Format.shortArray, ivf.getFrameRate(), 16, 31744, 992, 31, 1, lineStride, 0, -1), new RGBFormat(inSize, length * 3, Format.byteArray, ivf.getFrameRate(), 24, 1, 2, 3, 3, lineStride * 3, 0, -1), new RGBFormat(inSize, length * 3, Format.byteArray, ivf.getFrameRate(), 24, 3, 2, 1, 3, lineStride * 3, 0, -1)};
        return this.supportedOutputFormats;
    }

    public void open() throws ResourceUnavailableException {
        try {
            this.initDecoder();
            super.open();
            return;
        }
        catch (Throwable throwable) {
            System.err.println("could not open " + this.PLUGIN_NAME);
            throw new ResourceUnavailableException("could not open " + this.PLUGIN_NAME);
        }
    }

    public void close() {
        this.freeNative();
        super.close();
    }

    public void reset() {
    }

    public Format setInputFormat(Format input) {
        Format ret = super.setInputFormat(input);
        if (ret == null) {
            return null;
        }
        if (this.opened) {
            Dimension size = ((VideoFormat)input).getSize();
            RGBFormat oldFormat = (RGBFormat)this.outputFormat;
            int lineStride = (size.width + 3 & 0xFFFFFFFC) * oldFormat.getPixelStride();
            int rowStride = size.height + 3 & 0xFFFFFFFC;
            int length = lineStride * rowStride;
            this.outputFormat = new RGBFormat(size, length, oldFormat.getDataType(), ((VideoFormat)input).getFrameRate(), oldFormat.getBitsPerPixel(), oldFormat.getRedMask(), oldFormat.getGreenMask(), oldFormat.getBlueMask(), oldFormat.getPixelStride(), lineStride, oldFormat.getFlipped(), oldFormat.getEndian());
        }
        return ret;
    }

    protected void videoResized() {
        this.initDecoder();
    }

    protected void initDecoder() {
        RGBFormat ovf = (RGBFormat)this.outputFormat;
        this.rMask = ovf.getRedMask();
        this.gMask = ovf.getGreenMask();
        this.bMask = ovf.getBlueMask();
        int bitsPerPixel = ovf.getBitsPerPixel();
        if (bitsPerPixel == 24 && ovf.getDataType() == Format.byteArray) {
            int bypp = bitsPerPixel / 8;
            if (Arch.isLittleEndian()) {
                this.rMask = 255 << (this.rMask - 1) * 8;
                this.gMask = 255 << (this.gMask - 1) * 8;
                this.bMask = 255 << (this.bMask - 1) * 8;
            } else {
                this.rMask = 255 << (this.rMask - 1) * 8;
                this.gMask = 255 << (this.gMask - 1) * 8;
                this.bMask = 255 << (this.bMask - 1) * 8;
            }
        }
        this.initNative(bitsPerPixel, this.rMask, this.gMask, this.bMask);
    }

    public int process(Buffer inputBuffer, Buffer outputBuffer) {
        if (!this.checkInputBuffer(inputBuffer)) {
            return 1;
        }
        if (this.isEOM(inputBuffer)) {
            this.propagateEOM(outputBuffer);
            return 0;
        }
        VideoFormat ivf = (VideoFormat)inputBuffer.getFormat();
        int inLength = inputBuffer.getLength();
        int inMaxLength = ivf.getMaxDataLength();
        int outMaxLength = this.outputFormat.getMaxDataLength();
        Class outputClass = this.outputFormat.getDataType();
        outputBuffer.setFormat(this.outputFormat);
        byte[] inData = (byte[])inputBuffer.getData();
        Object outData = this.validateData(outputBuffer, 0, true);
        int bytesPerPixel = ((RGBFormat)this.outputFormat).getBitsPerPixel() / 8;
        long outDataBytes = 0L;
        if (outData instanceof NBA) {
            outDataBytes = ((NBA)outData).getNativeData();
        }
        if (this.refData == null || this.refData.getSize() < outMaxLength) {
            this.refData = new NBA(this.outputFormat.getDataType(), outMaxLength);
        }
        this.decodeNative(bytesPerPixel, inData, this.refData.getNativeData(), outData, outDataBytes, outMaxLength);
        this.updateOutput(outputBuffer, this.outputFormat, outMaxLength, 0);
        return 0;
    }

    static {
        JMFSecurityManager.loadLibrary("jmutil");
        JMFSecurityManager.loadLibrary("jmcvid");
    }
}

