/*
 * Decompiled with CFR 0.152.
 */
package ext.base.io;

import ext.base.core.BcStringUtil;
import ext.base.io.BcFileCircuiter;
import ext.base.io.BcFileUtil;
import ext.base.io.BcStreamTransmitter;
import ext.base.log.BcLogUtil;
import java.io.File;

public class BcFileCopier
extends BcFileCircuiter {
    private BcStreamTransmitter streamTransmitter = new BcStreamTransmitter();
    private File fromFile;
    private File toDir;
    public boolean doOverwrite;

    public void doCopy(File fromFile, File toDir) throws Exception {
        this.fromFile = fromFile;
        this.toDir = toDir;
        this.start(fromFile);
    }

    @Override
    public void fileWasFound(File targetFile, int dirCount, int fileCount) throws Exception {
        super.fileWasFound(targetFile, dirCount, fileCount);
        if (targetFile.isDirectory()) {
            boolean isSuccess;
            File destFile = this.toDestFile(targetFile);
            if (!destFile.exists() && !(isSuccess = destFile.mkdirs())) {
                throw new Exception("Can't create dir." + destFile.getPath());
            }
        } else {
            boolean isSuccess;
            File destFile = this.toDestFile(targetFile);
            if (destFile.exists() && this.doOverwrite && !(isSuccess = destFile.delete())) {
                throw new Exception("Can't delete " + destFile.getPath());
            }
            BcFileUtil.copyFile(targetFile, destFile, this.streamTransmitter);
        }
    }

    protected File toDestFile(File targetFile) throws Exception {
        String pathLower = "";
        pathLower = BcStringUtil.equals(this.fromFile.getPath(), targetFile.getPath()) ? String.valueOf(BcFileUtil.fileSep) + targetFile.getName() : BcStringUtil.replace((CharSequence)targetFile.getPath(), this.fromFile.getParentFile().getPath(), "").toString();
        String destFilePath = String.valueOf(this.toDir.getPath()) + pathLower;
        BcLogUtil.debug("toDestFile:destFilePath=" + destFilePath);
        return new File(destFilePath);
    }
}

