/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLType;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import oracle.jdbc.OracleData;
import oracle.jdbc.OracleDataFactory;
import oracle.jdbc.OracleResultSet;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.jdbc.driver.DBConversion;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.InsensitiveScrollableResultSet;
import oracle.jdbc.driver.JavaToJavaConverter;
import oracle.jdbc.driver.LogicalConnection;
import oracle.jdbc.driver.OraclePreparedStatement;
import oracle.jdbc.driver.OraclePreparedStatementWrapper;
import oracle.jdbc.driver.OracleResultSet;
import oracle.jdbc.driver.OracleResultSetMetaData;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.SQLUtil;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.internal.OracleLargeObject;
import oracle.jdbc.proxy.ProxyFactory;
import oracle.jdbc.proxy._Proxy_;
import oracle.sql.ARRAY;
import oracle.sql.BFILE;
import oracle.sql.BLOB;
import oracle.sql.CHAR;
import oracle.sql.CLOB;
import oracle.sql.CustomDatum;
import oracle.sql.CustomDatumFactory;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.INTERVALDS;
import oracle.sql.INTERVALYM;
import oracle.sql.NCLOB;
import oracle.sql.NUMBER;
import oracle.sql.OPAQUE;
import oracle.sql.ORAData;
import oracle.sql.ORADataFactory;
import oracle.sql.RAW;
import oracle.sql.REF;
import oracle.sql.ROWID;
import oracle.sql.STRUCT;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMESTAMPTZ;

class OldUpdatableResultSet
extends OracleResultSet {
    private static final String CLASS_NAME = OldUpdatableResultSet.class.getName();
    protected static final int MAX_CHAR_BUFFER_SIZE = 1024;
    protected static final int MAX_BYTE_BUFFER_SIZE = 1024;
    protected static final int ASCII_STREAM = 1;
    protected static final int BINARY_STREAM = 2;
    protected static final int UNICODE_STREAM = 3;
    protected static final int VALUE_NULL = 1;
    protected static final int VALUE_NOT_NULL = 2;
    protected static final int VALUE_UNKNOWN = 3;
    protected static final int VALUE_IN_RSET = 4;
    static final int concurrencyType = 1008;
    static final int BEGIN_COLUMN_INDEX = 0;
    private int wasNull;
    private static int _MIN_STREAM_SIZE = 4000;
    OracleResultSet resultSet;
    boolean isRowDeleted = false;
    boolean isCachedRset;
    OracleStatement scrollStmt;
    ResultSetMetaData rsetMetaData;
    private int columnCount;
    private OraclePreparedStatement deleteStmt;
    private OraclePreparedStatement insertStmt;
    private OraclePreparedStatement updateStmt;
    private int[] indexColsChanged;
    private Object[] rowBuffer;
    private boolean[] m_nullIndicator;
    private int[][] typeInfo;
    private boolean isInserting;
    private boolean isUpdating;
    ArrayList<Clob> tempClobsToFree = null;
    ArrayList<Blob> tempBlobsToFree = null;

    OldUpdatableResultSet(OracleStatement stmt, OracleResultSet rset) throws SQLException {
        super(stmt.connection);
        this.resultSet = rset;
        this.scrollStmt = stmt;
        this.deleteStmt = null;
        this.insertStmt = null;
        this.updateStmt = null;
        this.indexColsChanged = null;
        this.rowBuffer = null;
        this.m_nullIndicator = null;
        this.typeInfo = null;
        this.isInserting = false;
        this.isUpdating = false;
        this.wasNull = -1;
        this.rsetMetaData = null;
        this.columnCount = 0;
        this.getInternalMetadata();
        this.isCachedRset = true;
    }

    void ensureOpen() throws SQLException {
        if (this.closed) {
            if (this.connection.isClosed()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8).fillInStackTrace();
            }
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10).fillInStackTrace();
        }
        if (this.resultSet == null || this.scrollStmt == null || this.scrollStmt.closed) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
        }
    }

    @Override
    public void close() throws SQLException {
        if (this.closed) {
            return;
        }
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            super.close();
            if (this.resultSet != null) {
                this.resultSet.close();
            }
            if (this.insertStmt != null) {
                this.insertStmt.close();
            }
            if (this.updateStmt != null) {
                this.updateStmt.close();
            }
            if (this.deleteStmt != null) {
                this.deleteStmt.close();
            }
            if (this.scrollStmt != null) {
                this.scrollStmt.notifyCloseRset();
            }
            this.cancelRowInserts();
            this.connection = LogicalConnection.closedConnection;
            this.resultSet = null;
            this.scrollStmt = null;
            this.rsetMetaData = null;
            this.scrollStmt = null;
            this.deleteStmt = null;
            this.insertStmt = null;
            this.updateStmt = null;
            this.indexColsChanged = null;
            this.rowBuffer = null;
            this.m_nullIndicator = null;
            this.typeInfo = null;
        }
    }

    @Override
    public int getCursorId() throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            int n = this.scrollStmt.cursorId;
            return n;
        }
    }

    @Override
    public boolean wasNull() throws SQLException {
        Throwable throwable = null;
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            switch (this.wasNull) {
                case 1: {
                    boolean bl = true;
                    return bl;
                }
                case 2: {
                    boolean bl = false;
                    return bl;
                }
                case 4: {
                    boolean bl = this.resultSet.wasNull();
                    return bl;
                }
            }
            try {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 24).fillInStackTrace();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    @Override
    public Statement getStatement() throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            OracleStatement oracleStatement = this.scrollStmt;
            return oracleStatement;
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            SQLWarning innerWarnings = this.resultSet.getWarnings();
            if (this.sqlWarning == null) {
                SQLWarning sQLWarning = innerWarnings;
                return sQLWarning;
            }
            SQLWarning thisWarning = this.sqlWarning;
            while (thisWarning.getNextWarning() != null) {
                thisWarning = thisWarning.getNextWarning();
            }
            thisWarning.setNextWarning(innerWarnings);
            SQLWarning sQLWarning = this.sqlWarning;
            return sQLWarning;
        }
    }

    @Override
    public void clearWarnings() throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            this.sqlWarning = null;
            this.resultSet.clearWarnings();
        }
    }

    @Override
    public OracleResultSet.AuthorizationIndicator getAuthorizationIndicator(int columnIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82).fillInStackTrace();
            }
            OracleResultSet.AuthorizationIndicator authorizationIndicator = this.resultSet.getAuthorizationIndicator(columnIndex);
            return authorizationIndicator;
        }
    }

    @Override
    public boolean next() throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            this.cancelRowChanges();
            if (this.isRowDeleted) {
                this.isRowDeleted = false;
                boolean bl = this.resultSet.isValidRow();
                return bl;
            }
            boolean bl = this.resultSet.next();
            return bl;
        }
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            if (this.isRowDeleted) {
                boolean bl = this.resultSet.isFirst();
                return bl;
            }
            boolean bl = this.resultSet.isBeforeFirst();
            return bl;
        }
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            boolean bl = this.resultSet.isAfterLast();
            return bl;
        }
    }

    @Override
    public boolean isFirst() throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82).fillInStackTrace();
            }
            boolean bl = this.resultSet.isFirst();
            return bl;
        }
    }

    @Override
    public boolean isLast() throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82).fillInStackTrace();
            }
            boolean bl = this.resultSet.isLast();
            return bl;
        }
    }

    @Override
    public void beforeFirst() throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            this.cancelRowChanges();
            this.isRowDeleted = false;
            this.resultSet.beforeFirst();
        }
    }

    @Override
    public void afterLast() throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            this.cancelRowChanges();
            this.isRowDeleted = false;
            this.resultSet.afterLast();
        }
    }

    @Override
    public boolean first() throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            this.cancelRowChanges();
            this.isRowDeleted = false;
            boolean bl = this.resultSet.first();
            return bl;
        }
    }

    @Override
    public boolean last() throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            this.cancelRowChanges();
            this.isRowDeleted = false;
            boolean bl = this.resultSet.last();
            return bl;
        }
    }

    @Override
    public int getRow() throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82).fillInStackTrace();
            }
            int n = this.resultSet.getRow();
            return n;
        }
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            this.cancelRowChanges();
            this.isRowDeleted = false;
            boolean bl = this.resultSet.absolute(row);
            return bl;
        }
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            this.cancelRowChanges();
            if (this.isRowDeleted) {
                --rows;
                this.isRowDeleted = false;
            }
            boolean bl = this.resultSet.relative(rows);
            return bl;
        }
    }

    @Override
    public boolean previous() throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            this.cancelRowChanges();
            this.isRowDeleted = false;
            boolean bl = this.resultSet.previous();
            return bl;
        }
    }

    void addToTempLobsToFree(Clob tclob) {
        if (this.tempClobsToFree == null) {
            this.tempClobsToFree = new ArrayList();
        }
        this.tempClobsToFree.add(tclob);
    }

    void addToTempLobsToFree(Blob tblob) {
        if (this.tempBlobsToFree == null) {
            this.tempBlobsToFree = new ArrayList();
        }
        this.tempBlobsToFree.add(tblob);
    }

    void cleanTempLobs() {
        this.cleanTempClobs(this.tempClobsToFree);
        this.cleanTempBlobs(this.tempBlobsToFree);
        this.tempClobsToFree = null;
        this.tempBlobsToFree = null;
    }

    void cleanTempBlobs(ArrayList<Blob> x) {
        if (x != null) {
            Iterator<Blob> iter = x.iterator();
            while (iter.hasNext()) {
                try {
                    ((OracleLargeObject)((Object)iter.next())).freeLOB();
                }
                catch (SQLException e) {
                    this.debug(Level.WARNING, SecurityLabel.UNKNOWN, CLASS_NAME, "cleanTempBlobs", "exception={0}. ", (String)null, (Throwable)null, (Object)e.getMessage());
                }
            }
        }
    }

    void cleanTempClobs(ArrayList<Clob> x) {
        if (x != null) {
            Iterator<Clob> iter = x.iterator();
            while (iter.hasNext()) {
                try {
                    ((OracleLargeObject)((Object)iter.next())).freeLOB();
                }
                catch (SQLException e) {
                    this.debug(Level.WARNING, SecurityLabel.UNKNOWN, CLASS_NAME, "cleanTempClobs", "exception={0}. ", (String)null, (Throwable)null, (Object)e.getMessage());
                }
            }
        }
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            ResultSetMetaData resultSetMetaData = this.resultSet.getMetaData();
            return resultSetMetaData;
        }
    }

    @Override
    public int findColumn(String columnName) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            int n = this.resultSet.findColumn(columnName);
            return n;
        }
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            this.resultSet.setFetchDirection(direction);
        }
    }

    @Override
    public int getFetchDirection() throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            int n = this.resultSet.getFetchDirection();
            return n;
        }
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            this.resultSet.setFetchSize(rows);
        }
    }

    @Override
    public int getFetchSize() throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            int n = this.resultSet.getFetchSize();
            return n;
        }
    }

    @Override
    public int getType() throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            int n = this.scrollStmt.realRsetType.getType();
            return n;
        }
    }

    @Override
    protected int doGetType() {
        return this.scrollStmt.realRsetType.getType();
    }

    @Override
    public int getConcurrency() throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            int n = 1008;
            return n;
        }
    }

    @Override
    public String getCursorName() throws SQLException {
        Monitor.CloseableLock lock = this.connection.acquireCloseableLock();
        Throwable throwable = null;
        try {
            try {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 23, "getCursorName").fillInStackTrace();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (Throwable throwable3) {
            if (lock != null) {
                if (throwable != null) {
                    try {
                        lock.close();
                    }
                    catch (Throwable throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                } else {
                    lock.close();
                }
            }
            throw throwable3;
        }
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            boolean bl = false;
            return bl;
        }
    }

    @Override
    public boolean rowInserted() throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            boolean bl = false;
            return bl;
        }
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            boolean bl = this.isRowDeleted;
            return bl;
        }
    }

    @Override
    public void insertRow() throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82).fillInStackTrace();
            }
            if (!this.isOnInsertRow()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 83).fillInStackTrace();
            }
            this.prepareInsertRowStatement();
            this.prepareInsertRowBinds();
            this.executeInsertRow();
        }
    }

    @Override
    public void updateRow() throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82).fillInStackTrace();
            }
            if (this.isOnInsertRow()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 84).fillInStackTrace();
            }
            if (this.isBeforeFirst()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14).fillInStackTrace();
            }
            if (this.isAfterLast()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 289).fillInStackTrace();
            }
            int numColumnsChanged = this.getNumColumnsChanged();
            if (numColumnsChanged > 0) {
                this.prepareUpdateRowStatement(numColumnsChanged);
                this.prepareUpdateRowBinds(numColumnsChanged);
                this.executeUpdateRow();
            }
        }
    }

    @Override
    public void deleteRow() throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            if (this.isBeforeFirst()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14).fillInStackTrace();
            }
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82).fillInStackTrace();
            }
            if (this.isOnInsertRow()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 84).fillInStackTrace();
            }
            if (this.isAfterLast()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 289).fillInStackTrace();
            }
            this.prepareDeleteRowStatement();
            this.prepareDeleteRowBinds();
            this.executeDeleteRow();
            this.isRowDeleted = true;
        }
    }

    @Override
    public void refreshRow() throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82).fillInStackTrace();
            }
            if (this.isOnInsertRow()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 84).fillInStackTrace();
            }
            if (this.isBeforeFirst()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14).fillInStackTrace();
            }
            if (this.isAfterLast()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 289).fillInStackTrace();
            }
            this.resultSet.refreshRow();
        }
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            if (this.isUpdating) {
                this.isUpdating = false;
                this.clearRowBuffer();
            }
        }
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            if (this.isOnInsertRow()) {
                return;
            }
            this.isRowDeleted = false;
            this.isInserting = true;
            if (this.rowBuffer == null) {
                this.rowBuffer = new Object[this.getColumnCount()];
            }
            if (this.m_nullIndicator == null) {
                this.m_nullIndicator = new boolean[this.getColumnCount()];
            }
            this.clearRowBuffer();
        }
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82).fillInStackTrace();
            }
            this.cancelRowInserts();
        }
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            assert (type != null) : "type: null";
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82).fillInStackTrace();
            }
            T value = null;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
                Datum datum = this.getRowBufferDatumAt(columnIndex);
                this.setIsNull(datum == null);
                if (datum != null) {
                    value = datum.toClass(type);
                }
            } else {
                this.setIsNull(4);
                value = this.resultSet.getObject(columnIndex, type);
            }
            T t = value;
            return t;
        }
    }

    @Override
    public void updateNull(int columnIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82).fillInStackTrace();
            }
            this.setRowBufferAt(columnIndex, null);
        }
    }

    @Override
    int getColumnCount() throws SQLException {
        if (this.columnCount == 0) {
            this.columnCount = this.resultSet.getColumnCount();
        }
        return this.columnCount;
    }

    ResultSetMetaData getInternalMetadata() throws SQLException {
        if (this.rsetMetaData == null) {
            this.rsetMetaData = this.resultSet.getMetaData();
        }
        return this.rsetMetaData;
    }

    private void cancelRowChanges() throws SQLException {
        this.connection.assertLockHeldByCurrentThread();
        if (this.isInserting) {
            this.cancelRowInserts();
        }
        if (this.isUpdating) {
            this.cancelRowUpdates();
        }
    }

    boolean isOnInsertRow() {
        return this.isInserting;
    }

    private void cancelRowInserts() {
        if (this.isInserting) {
            this.isInserting = false;
            this.clearRowBuffer();
        }
    }

    boolean isUpdatingRow() {
        return this.isUpdating;
    }

    private void clearRowBuffer() {
        int i;
        if (this.rowBuffer != null) {
            for (i = 0; i < this.rowBuffer.length; ++i) {
                this.rowBuffer[i] = null;
            }
        }
        if (this.m_nullIndicator != null) {
            for (i = 0; i < this.m_nullIndicator.length; ++i) {
                this.m_nullIndicator[i] = false;
            }
        }
        if (this.typeInfo != null) {
            for (i = 0; i < this.typeInfo.length; ++i) {
                if (this.typeInfo[i] == null) continue;
                for (int j = 0; j < this.typeInfo[i].length; ++j) {
                    this.typeInfo[i][j] = 0;
                }
            }
        }
        this.cleanTempLobs();
    }

    protected void setRowBufferAt(int idx, Datum value) throws SQLException {
        this.setRowBufferAt(idx, value, null);
    }

    protected void setRowBufferAt(int idx, Object value, int[] info) throws SQLException {
        if (!this.isInserting) {
            if (this.isBeforeFirst() || this.isAfterLast() || this.getRow() == 0) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82).fillInStackTrace();
            }
            this.isUpdating = true;
        }
        if (idx < 1 || idx > this.getColumnCount()) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "setRowBufferAt").fillInStackTrace();
        }
        if (this.rowBuffer == null) {
            this.rowBuffer = new Object[this.getColumnCount()];
        }
        if (this.m_nullIndicator == null) {
            this.m_nullIndicator = new boolean[this.getColumnCount()];
            for (int i = 0; i < this.getColumnCount(); ++i) {
                this.m_nullIndicator[i] = false;
            }
        }
        if (info != null) {
            if (this.typeInfo == null) {
                this.typeInfo = new int[this.getColumnCount()][];
            }
            this.typeInfo[idx - 1] = info;
        }
        this.rowBuffer[idx - 1] = value;
        this.m_nullIndicator[idx - 1] = value == null;
    }

    protected Datum getRowBufferDatumAt(int idx) throws SQLException {
        Object value;
        if (idx < 1 || idx > this.getColumnCount()) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "getRowBufferDatumAt").fillInStackTrace();
        }
        Datum datum = null;
        if (this.rowBuffer != null && (value = this.rowBuffer[idx - 1]) != null) {
            if (value instanceof Datum) {
                datum = (Datum)value;
            } else {
                OracleResultSetMetaData rsmd = (OracleResultSetMetaData)this.getInternalMetadata();
                datum = SQLUtil.makeOracleDatum(this.connection, value, rsmd.getColumnType(idx), null, rsmd.isNCHAR(idx));
                this.rowBuffer[idx - 1] = datum;
            }
        }
        return datum;
    }

    protected Object getRowBufferAt(int idx) throws SQLException {
        if (idx < 1 || idx > this.getColumnCount()) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "getRowBufferDatumAt").fillInStackTrace();
        }
        if (this.rowBuffer != null) {
            return this.rowBuffer[idx - 1];
        }
        return null;
    }

    protected boolean isRowBufferUpdatedAt(int idx) throws SQLException {
        if (idx < 1 || idx > this.getColumnCount()) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "getRowBufferDatumAt").fillInStackTrace();
        }
        if (this.rowBuffer == null) {
            return false;
        }
        return this.rowBuffer[idx - 1] != null || this.m_nullIndicator[idx - 1];
    }

    private void prepareInsertRowStatement() throws SQLException {
        if (this.insertStmt == null) {
            String sql = this.scrollStmt.sqlObject.getInsertSqlForUpdatableResultSet(this);
            PreparedStatement ps = this.connection.prepareStatement(sql);
            this.insertStmt = (OraclePreparedStatement)((OraclePreparedStatementWrapper)ps).preparedStatement;
            this.insertStmt.setQueryTimeout(this.scrollStmt.getQueryTimeout());
            if (this.scrollStmt.sqlObject.generatedSqlNeedEscapeProcessing()) {
                this.insertStmt.setEscapeProcessing(true);
            }
        }
    }

    private void prepareInsertRowBinds() throws SQLException {
        int bindIndex = 1;
        bindIndex = this.prepareSubqueryBinds(this.insertStmt, bindIndex);
        OracleResultSetMetaData rsmd = (OracleResultSetMetaData)this.getInternalMetadata();
        for (int col = 1; col <= this.getColumnCount(); ++col) {
            Object value = this.getRowBufferAt(col);
            if (value != null) {
                if (value instanceof Reader) {
                    if (rsmd.isNCHAR(col)) {
                        this.insertStmt.setFormOfUse(bindIndex + col - 1, (short)2);
                    }
                    this.insertStmt.setCharacterStream(bindIndex + col - 1, (Reader)value, this.typeInfo[col - 1][0]);
                    continue;
                }
                if (value instanceof InputStream) {
                    if (this.typeInfo[col - 1][1] == 2) {
                        this.insertStmt.setBinaryStream(bindIndex + col - 1, (InputStream)value, this.typeInfo[col - 1][0]);
                        continue;
                    }
                    if (this.typeInfo[col - 1][1] != 1) continue;
                    this.insertStmt.setAsciiStream(bindIndex + col - 1, (InputStream)value, this.typeInfo[col - 1][0]);
                    continue;
                }
                Datum datum = this.getRowBufferDatumAt(col);
                if (rsmd.isNCHAR(col)) {
                    this.insertStmt.setFormOfUse(bindIndex + col - 1, (short)2);
                }
                this.insertStmt.setOracleObject(bindIndex + col - 1, datum);
                continue;
            }
            int colType = this.getInternalMetadata().getColumnType(col);
            if (colType == 2006 || colType == 2002 || colType == 2008 || colType == 2007 || colType == 2003 || colType == 2009) {
                this.insertStmt.setNull(bindIndex + col - 1, colType, this.getInternalMetadata().getColumnTypeName(col));
                continue;
            }
            this.insertStmt.setNull(bindIndex + col - 1, colType);
        }
    }

    private void executeInsertRow() throws SQLException {
        if (this.insertStmt.executeUpdate() != 1) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 85).fillInStackTrace();
        }
    }

    private int getNumColumnsChanged() throws SQLException {
        int numColumnsChanged = 0;
        if (this.indexColsChanged == null) {
            this.indexColsChanged = new int[this.getColumnCount()];
        }
        if (this.rowBuffer != null) {
            for (int i = 0; i < this.getColumnCount(); ++i) {
                if (this.rowBuffer[i] == null && (this.rowBuffer[i] != null || !this.m_nullIndicator[i])) continue;
                this.indexColsChanged[numColumnsChanged++] = i;
            }
        }
        return numColumnsChanged;
    }

    private void prepareUpdateRowStatement(int numColumnsChanged) throws SQLException {
        if (this.updateStmt != null) {
            this.updateStmt.close();
        }
        String sql = this.scrollStmt.sqlObject.getUpdateSqlForUpdatableResultSet(this, numColumnsChanged, this.rowBuffer, this.indexColsChanged);
        PreparedStatement ps = this.connection.prepareStatement(sql);
        this.updateStmt = (OraclePreparedStatement)((OraclePreparedStatementWrapper)ps).preparedStatement;
        this.updateStmt.setQueryTimeout(this.scrollStmt.getQueryTimeout());
        if (this.scrollStmt.sqlObject.generatedSqlNeedEscapeProcessing()) {
            this.updateStmt.setEscapeProcessing(true);
        }
    }

    private void prepareUpdateRowBinds(int numColumnsChanged) throws SQLException {
        int bindIndex = 1;
        bindIndex = this.prepareSubqueryBinds(this.updateStmt, bindIndex);
        OracleResultSetMetaData rsmd = (OracleResultSetMetaData)this.getInternalMetadata();
        for (int i = 0; i < numColumnsChanged; ++i) {
            int idx = this.indexColsChanged[i];
            Object value = this.getRowBufferAt(idx + 1);
            if (value != null) {
                if (value instanceof Reader) {
                    if (rsmd.isNCHAR(idx + 1)) {
                        this.updateStmt.setFormOfUse(bindIndex, (short)2);
                    }
                    this.updateStmt.setCharacterStream(bindIndex++, (Reader)value, this.typeInfo[idx][0]);
                    continue;
                }
                if (value instanceof InputStream) {
                    if (this.typeInfo[idx][1] == 2) {
                        this.updateStmt.setBinaryStream(bindIndex++, (InputStream)value, this.typeInfo[idx][0]);
                        continue;
                    }
                    if (this.typeInfo[idx][1] != 1) continue;
                    this.updateStmt.setAsciiStream(bindIndex++, (InputStream)value, this.typeInfo[idx][0]);
                    continue;
                }
                Datum datum = this.getRowBufferDatumAt(idx + 1);
                if (rsmd.isNCHAR(idx + 1)) {
                    this.updateStmt.setFormOfUse(bindIndex, (short)2);
                }
                this.updateStmt.setOracleObject(bindIndex++, datum);
                continue;
            }
            int colType = this.getInternalMetadata().getColumnType(idx + 1);
            if (colType == 2006 || colType == 2002 || colType == 2008 || colType == 2007 || colType == 2003 || colType == 2009) {
                this.updateStmt.setNull(bindIndex++, colType, this.getInternalMetadata().getColumnTypeName(idx + 1));
                continue;
            }
            if (rsmd.isNCHAR(idx + 1)) {
                this.updateStmt.setFormOfUse(bindIndex, (short)2);
            }
            this.updateStmt.setNull(bindIndex++, colType);
        }
        this.prepareCompareSelfBinds(this.updateStmt, bindIndex);
    }

    private void executeUpdateRow() throws SQLException {
        try {
            if (this.updateStmt.executeUpdate() == 0) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 85).fillInStackTrace();
            }
            if (this.isCachedRset) {
                this.refreshRows(this.getRow(), 1);
                this.cancelRowUpdates();
            }
        }
        finally {
            if (this.updateStmt != null) {
                this.updateStmt.close();
                this.updateStmt = null;
            }
        }
    }

    @Override
    int refreshRows(long firstRow, int numberOfRows) throws SQLException {
        return this.resultSet.refreshRows(firstRow - 1L, numberOfRows);
    }

    private void prepareDeleteRowStatement() throws SQLException {
        if (this.deleteStmt == null) {
            String sql = this.scrollStmt.sqlObject.getDeleteSqlForUpdatableResultSet(this);
            PreparedStatement ps = this.connection.prepareStatement(sql);
            this.deleteStmt = (OraclePreparedStatement)((OraclePreparedStatementWrapper)ps).preparedStatement;
            this.deleteStmt.setQueryTimeout(this.scrollStmt.getQueryTimeout());
            if (this.scrollStmt.sqlObject.generatedSqlNeedEscapeProcessing()) {
                this.deleteStmt.setEscapeProcessing(true);
            }
        }
    }

    private void prepareDeleteRowBinds() throws SQLException {
        int bindIndex = 1;
        bindIndex = this.prepareSubqueryBinds(this.deleteStmt, bindIndex);
        this.prepareCompareSelfBinds(this.deleteStmt, bindIndex);
    }

    private void executeDeleteRow() throws SQLException {
        if (this.deleteStmt.executeUpdate() == 0) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 85).fillInStackTrace();
        }
        if (this.isCachedRset) {
            this.removeCurrentRowFromCache();
        }
    }

    @Override
    void removeCurrentRowFromCache() throws SQLException {
        this.resultSet.removeCurrentRowFromCache();
    }

    @Override
    public boolean isFromResultSetCache() throws SQLException {
        return this.resultSet instanceof InsensitiveScrollableResultSet ? ((InsensitiveScrollableResultSet)this.resultSet).isFromResultSetCache() : false;
    }

    @Override
    public byte[] getCompileKey() throws SQLException {
        return this.scrollStmt.getCompileKey();
    }

    @Override
    public byte[] getRuntimeKey() throws SQLException {
        return this.scrollStmt.getRuntimeKey();
    }

    private int prepareCompareSelfBinds(OraclePreparedStatement pstmt, int bindIndex) throws SQLException {
        pstmt.setRowId(bindIndex, ((InsensitiveScrollableResultSet)this.resultSet).getPrependedRowId());
        return bindIndex + 1;
    }

    private int prepareSubqueryBinds(OraclePreparedStatement pstmt, int bindIndex) throws SQLException {
        return bindIndex + this.scrollStmt.copyBinds(pstmt, bindIndex - 1);
    }

    protected void setIsNull(int status) {
        this.wasNull = status;
    }

    protected void setIsNull(boolean isNull) {
        this.setIsNull(isNull ? 1 : 2);
    }

    @Override
    protected void doneFetchingRows(boolean fromPrepareForNewResult) throws SQLException {
        this.resultSet.doneFetchingRows(fromPrepareForNewResult);
    }

    @Override
    OracleStatement getOracleStatement() throws SQLException {
        return this.resultSet == null ? null : this.resultSet.getOracleStatement();
    }

    @Override
    public Datum getOracleObject(int columnIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82).fillInStackTrace();
            }
            Datum value = null;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
                value = this.getRowBufferDatumAt(columnIndex);
                this.setIsNull(value == null);
            } else {
                value = this.resultSet.getOracleObject(columnIndex);
                this.setIsNull(4);
            }
            Datum datum = value;
            return datum;
        }
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82).fillInStackTrace();
            }
            String value = null;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
                Datum datum = this.getRowBufferDatumAt(columnIndex);
                this.setIsNull(datum == null);
                if (datum != null) {
                    value = datum.stringValue(this.connection);
                }
            } else {
                this.setIsNull(4);
                value = this.resultSet.getString(columnIndex);
            }
            String string = value;
            return string;
        }
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82).fillInStackTrace();
            }
            boolean value = false;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
                Datum datum = this.getRowBufferDatumAt(columnIndex);
                this.setIsNull(datum == null);
                if (datum != null) {
                    value = datum.booleanValue();
                }
            } else {
                this.setIsNull(4);
                value = this.resultSet.getBoolean(columnIndex);
            }
            boolean bl = value;
            return bl;
        }
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82).fillInStackTrace();
            }
            byte value = 0;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
                Datum datum = this.getRowBufferDatumAt(columnIndex);
                this.setIsNull(datum == null);
                if (datum != null) {
                    value = datum.byteValue();
                }
            } else {
                this.setIsNull(4);
                value = this.resultSet.getByte(columnIndex);
            }
            byte by = value;
            return by;
        }
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82).fillInStackTrace();
            }
            short value = 0;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
                long longvalue = this.getLong(columnIndex);
                if (longvalue > 65537L || longvalue < -65538L) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 26, "getShort").fillInStackTrace();
                }
                value = (short)longvalue;
            } else {
                this.setIsNull(4);
                value = this.resultSet.getShort(columnIndex);
            }
            short s = value;
            return s;
        }
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82).fillInStackTrace();
            }
            int value = 0;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
                Datum datum = this.getRowBufferDatumAt(columnIndex);
                this.setIsNull(datum == null);
                if (datum != null) {
                    value = datum.intValue();
                }
            } else {
                this.setIsNull(4);
                value = this.resultSet.getInt(columnIndex);
            }
            int n = value;
            return n;
        }
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82).fillInStackTrace();
            }
            long value = 0L;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
                Datum datum = this.getRowBufferDatumAt(columnIndex);
                this.setIsNull(datum == null);
                if (datum != null) {
                    value = datum.longValue();
                }
            } else {
                this.setIsNull(4);
                value = this.resultSet.getLong(columnIndex);
            }
            long l = value;
            return l;
        }
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82).fillInStackTrace();
            }
            float value = 0.0f;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
                Datum datum = this.getRowBufferDatumAt(columnIndex);
                this.setIsNull(datum == null);
                if (datum != null) {
                    value = datum.floatValue();
                }
            } else {
                this.setIsNull(4);
                value = this.resultSet.getFloat(columnIndex);
            }
            float f = value;
            return f;
        }
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82).fillInStackTrace();
            }
            double value = 0.0;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
                Datum datum = this.getRowBufferDatumAt(columnIndex);
                this.setIsNull(datum == null);
                if (datum != null) {
                    value = datum.doubleValue();
                }
            } else {
                this.setIsNull(4);
                value = this.resultSet.getDouble(columnIndex);
            }
            double d = value;
            return d;
        }
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82).fillInStackTrace();
            }
            BigDecimal value = null;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
                Datum datum = this.getRowBufferDatumAt(columnIndex);
                this.setIsNull(datum == null);
                if (datum != null) {
                    value = datum.bigDecimalValue();
                }
            } else {
                this.setIsNull(4);
                value = this.resultSet.getBigDecimal(columnIndex);
            }
            BigDecimal bigDecimal = value;
            return bigDecimal;
        }
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82).fillInStackTrace();
            }
            byte[] value = null;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
                Datum datum = this.getRowBufferDatumAt(columnIndex);
                this.setIsNull(datum == null);
                if (datum != null) {
                    value = datum.getBytes();
                }
            } else {
                this.setIsNull(4);
                value = this.resultSet.getBytes(columnIndex);
            }
            byte[] byArray = value;
            return byArray;
        }
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82).fillInStackTrace();
            }
            Date value = null;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
                Datum datum = this.getRowBufferDatumAt(columnIndex);
                this.setIsNull(datum == null);
                if (datum != null) {
                    value = datum.dateValue();
                }
            } else {
                this.setIsNull(4);
                value = this.resultSet.getDate(columnIndex);
            }
            Date date = value;
            return date;
        }
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82).fillInStackTrace();
            }
            Time value = null;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
                Datum datum = this.getRowBufferDatumAt(columnIndex);
                this.setIsNull(datum == null);
                if (datum != null) {
                    value = datum.timeValue();
                }
            } else {
                this.setIsNull(4);
                value = this.resultSet.getTime(columnIndex);
            }
            Time time = value;
            return time;
        }
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82).fillInStackTrace();
            }
            Timestamp value = null;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
                Datum datum = this.getRowBufferDatumAt(columnIndex);
                this.setIsNull(datum == null);
                if (datum != null) {
                    value = datum.timestampValue();
                }
            } else {
                this.setIsNull(4);
                value = this.resultSet.getTimestamp(columnIndex);
            }
            Timestamp timestamp = value;
            return timestamp;
        }
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82).fillInStackTrace();
            }
            InputStream value = null;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
                Object obj = this.getRowBufferAt(columnIndex);
                this.setIsNull(obj == null);
                if (obj != null) {
                    if (obj instanceof InputStream) {
                        value = (InputStream)obj;
                    } else {
                        Datum datum = this.getRowBufferDatumAt(columnIndex);
                        value = datum.asciiStreamValue();
                    }
                }
            } else {
                this.setIsNull(4);
                value = this.resultSet.getAsciiStream(columnIndex);
            }
            InputStream inputStream = value;
            return inputStream;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82).fillInStackTrace();
            }
            InputStream value = null;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
                Object obj = this.getRowBufferAt(columnIndex);
                this.setIsNull(obj == null);
                if (obj != null) {
                    if (obj instanceof InputStream) {
                        value = (InputStream)obj;
                    } else {
                        Datum datum = this.getRowBufferDatumAt(columnIndex);
                        DBConversion dbconv = this.connection.conversion;
                        byte[] bytes = datum.shareBytes();
                        if (datum instanceof RAW) {
                            value = dbconv.ConvertStream(new ByteArrayInputStream(bytes), 3, this.connection);
                        } else {
                            if (!(datum instanceof CHAR)) throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getUnicodeStream").fillInStackTrace();
                            value = dbconv.ConvertStream(new ByteArrayInputStream(bytes), 1, this.connection);
                        }
                    }
                }
            } else {
                this.setIsNull(4);
                value = this.resultSet.getUnicodeStream(columnIndex);
            }
            InputStream inputStream = value;
            return inputStream;
        }
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82).fillInStackTrace();
            }
            InputStream value = null;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
                Object obj = this.getRowBufferAt(columnIndex);
                this.setIsNull(obj == null);
                if (obj != null) {
                    if (obj instanceof InputStream) {
                        value = (InputStream)obj;
                    } else {
                        Datum datum = this.getRowBufferDatumAt(columnIndex);
                        value = datum.binaryStreamValue();
                    }
                }
            } else {
                this.setIsNull(4);
                value = this.resultSet.getBinaryStream(columnIndex);
            }
            InputStream inputStream = value;
            return inputStream;
        }
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82).fillInStackTrace();
            }
            Object value = null;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
                Datum datum = this.getOracleObject(columnIndex);
                this.setIsNull(datum == null);
                if (datum != null) {
                    value = datum.toJdbc();
                }
            } else {
                this.setIsNull(4);
                value = this.resultSet.getObject(columnIndex);
            }
            Object object = value;
            return object;
        }
    }

    @Override
    public Object getObject(int columnIndex, OracleDataFactory oracleDataFactory) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82).fillInStackTrace();
            }
            if (oracleDataFactory == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
            }
            Object value = null;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
                Object data = this.getObject(columnIndex);
                this.setIsNull(data == null);
                value = oracleDataFactory.create(data, 0);
            } else {
                this.setIsNull(4);
                value = this.resultSet.getObject(columnIndex, oracleDataFactory);
            }
            Object object = value;
            return object;
        }
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82).fillInStackTrace();
            }
            Reader value = null;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
                Object obj = this.getRowBufferAt(columnIndex);
                this.setIsNull(obj == null);
                if (obj != null) {
                    if (obj instanceof Reader) {
                        value = (Reader)obj;
                    } else {
                        Datum datum = this.getRowBufferDatumAt(columnIndex);
                        value = datum.characterStreamValue();
                    }
                }
            } else {
                this.setIsNull(4);
                value = this.resultSet.getCharacterStream(columnIndex);
            }
            Reader reader = value;
            return reader;
        }
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82).fillInStackTrace();
            }
            BigDecimal value = null;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
                Datum datum = this.getRowBufferDatumAt(columnIndex);
                this.setIsNull(datum == null);
                if (datum != null) {
                    value = datum.bigDecimalValue();
                }
            } else {
                this.setIsNull(4);
                value = this.resultSet.getBigDecimal(columnIndex);
            }
            BigDecimal bigDecimal = value;
            return bigDecimal;
        }
    }

    @Override
    public Object getObject(int columnIndex, Map<String, Class<?>> map) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82).fillInStackTrace();
            }
            Object value = null;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
                Datum datum = this.getOracleObject(columnIndex);
                this.setIsNull(datum == null);
                if (datum != null) {
                    value = datum instanceof STRUCT ? ((STRUCT)datum).toJdbc((Map)map) : datum.toJdbc();
                }
            } else {
                this.setIsNull(4);
                value = this.resultSet.getObject(columnIndex, map);
            }
            Object object = value;
            return object;
        }
    }

    @Override
    public Ref getRef(int columnIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82).fillInStackTrace();
            }
            REF rEF = this.getREF(columnIndex);
            return rEF;
        }
    }

    @Override
    public Blob getBlob(int columnIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82).fillInStackTrace();
            }
            BLOB bLOB = this.getBLOB(columnIndex);
            return bLOB;
        }
    }

    @Override
    public Clob getClob(int columnIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82).fillInStackTrace();
            }
            CLOB cLOB = this.getCLOB(columnIndex);
            return cLOB;
        }
    }

    @Override
    public Array getArray(int columnIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82).fillInStackTrace();
            }
            ARRAY aRRAY = this.getARRAY(columnIndex);
            return aRRAY;
        }
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82).fillInStackTrace();
            }
            Date value = null;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
                Datum datum = this.getOracleObject(columnIndex);
                this.setIsNull(datum == null);
                if (datum != null) {
                    if (datum instanceof DATE) {
                        value = ((DATE)datum).dateValue(cal);
                    } else if (datum instanceof TIMESTAMP) {
                        Timestamp ts = ((TIMESTAMP)datum).timestampValue(cal);
                        long millis = ts.getTime();
                        value = new Date(millis);
                    } else {
                        DATE d = new DATE(datum.stringValue(this.connection));
                        if (d != null) {
                            value = d.dateValue(cal);
                        }
                    }
                }
            } else {
                this.setIsNull(4);
                value = this.resultSet.getDate(columnIndex, cal);
            }
            Date date = value;
            return date;
        }
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82).fillInStackTrace();
            }
            Time value = null;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
                Datum datum = this.getOracleObject(columnIndex);
                this.setIsNull(datum == null);
                if (datum != null) {
                    if (datum instanceof DATE) {
                        value = ((DATE)datum).timeValue(cal);
                    } else if (datum instanceof TIMESTAMP) {
                        Timestamp ts = ((TIMESTAMP)datum).timestampValue(cal);
                        long millis = ts.getTime();
                        value = new Time(millis);
                    } else {
                        DATE d = new DATE(datum.stringValue(this.connection));
                        if (d != null) {
                            value = d.timeValue(cal);
                        }
                    }
                }
            } else {
                this.setIsNull(4);
                value = this.resultSet.getTime(columnIndex, cal);
            }
            Time time = value;
            return time;
        }
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82).fillInStackTrace();
            }
            Timestamp value = null;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
                Datum datum = this.getOracleObject(columnIndex);
                this.setIsNull(datum == null);
                if (datum != null) {
                    if (datum instanceof DATE) {
                        value = ((DATE)datum).timestampValue(cal);
                    } else if (datum instanceof TIMESTAMP) {
                        value = ((TIMESTAMP)datum).timestampValue(cal);
                    } else {
                        DATE d = new DATE(datum.stringValue(this.connection));
                        if (d != null) {
                            value = d.timestampValue(cal);
                        }
                    }
                }
            } else {
                this.setIsNull(4);
                value = this.resultSet.getTimestamp(columnIndex, cal);
            }
            Timestamp timestamp = value;
            return timestamp;
        }
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82).fillInStackTrace();
            }
            URL result = null;
            int colType = this.getInternalMetadata().getColumnType(columnIndex);
            int dbTypeCode = SQLUtil.getInternalType(colType);
            if (dbTypeCode == 96 || dbTypeCode == 1 || dbTypeCode == 8) {
                try {
                    String val = this.getString(columnIndex);
                    if (val == null) {
                        result = null;
                    }
                    result = new URL(val);
                }
                catch (MalformedURLException exc) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 136).fillInStackTrace();
                }
            } else {
                throw (SQLException)DatabaseError.createSQLFeatureNotSupportedException("getURL").fillInStackTrace();
            }
            URL uRL = result;
            return uRL;
        }
    }

    @Override
    public ResultSet getCursor(int columnIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82).fillInStackTrace();
            }
            ResultSet value = null;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
                Datum datum = this.getOracleObject(columnIndex);
                this.setIsNull(datum == null);
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getCursor").fillInStackTrace();
            }
            this.setIsNull(4);
            ResultSet resultSet = value = this.resultSet.getCursor(columnIndex);
            return resultSet;
        }
    }

    @Override
    public ROWID getROWID(int columnIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82).fillInStackTrace();
            }
            ROWID value = null;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
                Datum datum = this.getRowBufferDatumAt(columnIndex);
                this.setIsNull(datum == null);
                if (datum != null && !(datum instanceof ROWID)) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getROWID").fillInStackTrace();
                }
                value = (ROWID)datum;
            } else {
                this.setIsNull(4);
                value = this.resultSet.getROWID(columnIndex);
            }
            ROWID rOWID = value;
            return rOWID;
        }
    }

    @Override
    public NUMBER getNUMBER(int columnIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82).fillInStackTrace();
            }
            NUMBER value = null;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
                Datum datum = this.getRowBufferDatumAt(columnIndex);
                this.setIsNull(datum == null);
                if (datum != null && !(datum instanceof NUMBER)) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getNUMBER").fillInStackTrace();
                }
                value = (NUMBER)datum;
            } else {
                this.setIsNull(4);
                value = this.resultSet.getNUMBER(columnIndex);
            }
            NUMBER nUMBER = value;
            return nUMBER;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public DATE getDATE(int columnIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82).fillInStackTrace();
            }
            DATE value = null;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
                Datum datum = this.getRowBufferDatumAt(columnIndex);
                if (datum != null) {
                    if (datum instanceof DATE) {
                        value = (DATE)datum;
                    } else {
                        if (!(datum instanceof TIMESTAMP)) throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getDATE").fillInStackTrace();
                        Timestamp ts = ((TIMESTAMP)datum).timestampValue();
                        value = new DATE(ts);
                    }
                } else {
                    this.setIsNull(datum == null);
                }
            } else {
                this.setIsNull(4);
                value = this.resultSet.getDATE(columnIndex);
            }
            DATE dATE = value;
            return dATE;
        }
    }

    @Override
    public TIMESTAMP getTIMESTAMP(int columnIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82).fillInStackTrace();
            }
            TIMESTAMP value = null;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
                Datum datum = this.getRowBufferDatumAt(columnIndex);
                this.setIsNull(datum == null);
                if (datum != null && !(datum instanceof TIMESTAMP)) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getTIMESTAMP").fillInStackTrace();
                }
                value = (TIMESTAMP)datum;
            } else {
                this.setIsNull(4);
                value = this.resultSet.getTIMESTAMP(columnIndex);
            }
            TIMESTAMP tIMESTAMP = value;
            return tIMESTAMP;
        }
    }

    @Override
    public TIMESTAMPTZ getTIMESTAMPTZ(int columnIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82).fillInStackTrace();
            }
            TIMESTAMPTZ value = null;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
                Datum datum = this.getRowBufferDatumAt(columnIndex);
                this.setIsNull(datum == null);
                if (datum != null && !(datum instanceof TIMESTAMPTZ)) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getTIMESTAMPTZ").fillInStackTrace();
                }
                value = (TIMESTAMPTZ)datum;
            } else {
                this.setIsNull(4);
                value = this.resultSet.getTIMESTAMPTZ(columnIndex);
            }
            TIMESTAMPTZ tIMESTAMPTZ = value;
            return tIMESTAMPTZ;
        }
    }

    @Override
    public TIMESTAMPLTZ getTIMESTAMPLTZ(int columnIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82).fillInStackTrace();
            }
            TIMESTAMPLTZ value = null;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
                Datum datum = this.getRowBufferDatumAt(columnIndex);
                this.setIsNull(datum == null);
                if (datum != null && !(datum instanceof TIMESTAMPLTZ)) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getTIMESTAMPLTZ").fillInStackTrace();
                }
                value = (TIMESTAMPLTZ)datum;
            } else {
                this.setIsNull(4);
                value = this.resultSet.getTIMESTAMPLTZ(columnIndex);
            }
            TIMESTAMPLTZ tIMESTAMPLTZ = value;
            return tIMESTAMPLTZ;
        }
    }

    @Override
    public INTERVALDS getINTERVALDS(int columnIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82).fillInStackTrace();
            }
            INTERVALDS value = null;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
                Datum datum = this.getRowBufferDatumAt(columnIndex);
                this.setIsNull(datum == null);
                if (datum != null && !(datum instanceof INTERVALDS)) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getINTERVALDS").fillInStackTrace();
                }
                value = (INTERVALDS)datum;
            } else {
                this.setIsNull(4);
                value = this.resultSet.getINTERVALDS(columnIndex);
            }
            INTERVALDS iNTERVALDS = value;
            return iNTERVALDS;
        }
    }

    @Override
    public INTERVALYM getINTERVALYM(int columnIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82).fillInStackTrace();
            }
            INTERVALYM value = null;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
                Datum datum = this.getRowBufferDatumAt(columnIndex);
                this.setIsNull(datum == null);
                if (datum != null && !(datum instanceof INTERVALYM)) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getINTERVALYM").fillInStackTrace();
                }
                value = (INTERVALYM)datum;
            } else {
                this.setIsNull(4);
                value = this.resultSet.getINTERVALYM(columnIndex);
            }
            INTERVALYM iNTERVALYM = value;
            return iNTERVALYM;
        }
    }

    @Override
    public ARRAY getARRAY(int columnIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82).fillInStackTrace();
            }
            ARRAY value = null;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
                Datum datum = this.getRowBufferDatumAt(columnIndex);
                this.setIsNull(datum == null);
                if (datum != null && !(datum instanceof ARRAY)) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getARRAY").fillInStackTrace();
                }
                value = (ARRAY)datum;
            } else {
                this.setIsNull(4);
                value = this.resultSet.getARRAY(columnIndex);
            }
            ARRAY aRRAY = value;
            return aRRAY;
        }
    }

    @Override
    public STRUCT getSTRUCT(int columnIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82).fillInStackTrace();
            }
            STRUCT value = null;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
                Datum datum = this.getRowBufferDatumAt(columnIndex);
                this.setIsNull(datum == null);
                if (datum != null && !(datum instanceof STRUCT)) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getSTRUCT").fillInStackTrace();
                }
                value = (STRUCT)datum;
            } else {
                this.setIsNull(4);
                value = this.resultSet.getSTRUCT(columnIndex);
            }
            STRUCT sTRUCT = value;
            return sTRUCT;
        }
    }

    @Override
    public OPAQUE getOPAQUE(int columnIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82).fillInStackTrace();
            }
            OPAQUE value = null;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
                Datum datum = this.getRowBufferDatumAt(columnIndex);
                this.setIsNull(datum == null);
                if (datum != null && !(datum instanceof OPAQUE)) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getOPAQUE").fillInStackTrace();
                }
                value = (OPAQUE)datum;
            } else {
                this.setIsNull(4);
                value = this.resultSet.getOPAQUE(columnIndex);
            }
            OPAQUE oPAQUE = value;
            return oPAQUE;
        }
    }

    @Override
    public REF getREF(int columnIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82).fillInStackTrace();
            }
            REF value = null;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
                Datum datum = this.getRowBufferDatumAt(columnIndex);
                this.setIsNull(datum == null);
                if (datum != null && !(datum instanceof REF)) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getREF").fillInStackTrace();
                }
                value = (REF)datum;
            } else {
                this.setIsNull(4);
                value = this.resultSet.getREF(columnIndex);
            }
            REF rEF = value;
            return rEF;
        }
    }

    @Override
    public CHAR getCHAR(int columnIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82).fillInStackTrace();
            }
            CHAR value = null;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
                Datum datum = this.getRowBufferDatumAt(columnIndex);
                this.setIsNull(datum == null);
                if (datum != null && !(datum instanceof CHAR)) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getCHAR").fillInStackTrace();
                }
                value = (CHAR)datum;
            } else {
                this.setIsNull(4);
                value = this.resultSet.getCHAR(columnIndex);
            }
            CHAR cHAR = value;
            return cHAR;
        }
    }

    @Override
    public RAW getRAW(int columnIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82).fillInStackTrace();
            }
            RAW value = null;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
                Datum datum = this.getRowBufferDatumAt(columnIndex);
                this.setIsNull(datum == null);
                if (datum != null && !(datum instanceof RAW)) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getRAW").fillInStackTrace();
                }
                value = (RAW)datum;
            } else {
                this.setIsNull(4);
                value = this.resultSet.getRAW(columnIndex);
            }
            RAW rAW = value;
            return rAW;
        }
    }

    @Override
    public BLOB getBLOB(int columnIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82).fillInStackTrace();
            }
            BLOB value = null;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
                Datum datum = this.getRowBufferDatumAt(columnIndex);
                this.setIsNull(datum == null);
                if (datum != null && !(datum instanceof BLOB)) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getBLOB").fillInStackTrace();
                }
                value = (BLOB)datum;
            } else {
                this.setIsNull(4);
                value = this.resultSet.getBLOB(columnIndex);
            }
            BLOB bLOB = value;
            return bLOB;
        }
    }

    public NCLOB getNCLOB(int columnIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82).fillInStackTrace();
            }
            NCLOB value = null;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
                Datum datum = this.getRowBufferDatumAt(columnIndex);
                this.setIsNull(datum == null);
                if (datum != null && !(datum instanceof NCLOB)) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getCLOB").fillInStackTrace();
                }
                value = (NCLOB)datum;
            } else {
                this.setIsNull(4);
                value = (NCLOB)this.resultSet.getNClob(columnIndex);
            }
            NCLOB nCLOB = value;
            return nCLOB;
        }
    }

    @Override
    public CLOB getCLOB(int columnIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82).fillInStackTrace();
            }
            CLOB value = null;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
                Datum datum = this.getRowBufferDatumAt(columnIndex);
                this.setIsNull(datum == null);
                if (datum != null && !(datum instanceof CLOB)) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getCLOB").fillInStackTrace();
                }
                value = (CLOB)datum;
            } else {
                this.setIsNull(4);
                value = this.resultSet.getCLOB(columnIndex);
            }
            CLOB cLOB = value;
            return cLOB;
        }
    }

    @Override
    public BFILE getBFILE(int columnIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82).fillInStackTrace();
            }
            BFILE value = null;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
                Datum datum = this.getRowBufferDatumAt(columnIndex);
                this.setIsNull(datum == null);
                if (datum != null && !(datum instanceof BFILE)) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getBFILE").fillInStackTrace();
                }
                value = (BFILE)datum;
            } else {
                this.setIsNull(4);
                value = this.resultSet.getBFILE(columnIndex);
            }
            BFILE bFILE = value;
            return bFILE;
        }
    }

    @Override
    public BFILE getBfile(int columnIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82).fillInStackTrace();
            }
            BFILE bFILE = this.getBFILE(columnIndex);
            return bFILE;
        }
    }

    @Override
    public CustomDatum getCustomDatum(int columnIndex, CustomDatumFactory factory) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82).fillInStackTrace();
            }
            if (factory == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
            }
            CustomDatum value = null;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
                Datum datum = this.getRowBufferDatumAt(columnIndex);
                this.setIsNull(datum == null);
                value = factory.create(datum, 0);
            } else {
                this.setIsNull(4);
                value = this.resultSet.getCustomDatum(columnIndex, factory);
            }
            CustomDatum customDatum = value;
            return customDatum;
        }
    }

    @Override
    public ORAData getORAData(int columnIndex, ORADataFactory factory) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82).fillInStackTrace();
            }
            if (factory == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
            }
            ORAData value = null;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
                Datum datum = this.getRowBufferDatumAt(columnIndex);
                this.setIsNull(datum == null);
                value = factory.create(datum, 0);
            } else {
                this.setIsNull(4);
                value = this.resultSet.getORAData(columnIndex, factory);
            }
            ORAData oRAData = value;
            return oRAData;
        }
    }

    @Override
    public NClob getNClob(int columnIndex) throws SQLException {
        NCLOB c = this.getNCLOB(columnIndex);
        if (c == null) {
            return null;
        }
        if (!(c instanceof NClob)) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 184).fillInStackTrace();
        }
        return c;
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        return this.getString(columnIndex);
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        return this.getCharacterStream(columnIndex);
    }

    @Override
    public RowId getRowId(int columnIndex) throws SQLException {
        return this.getROWID(columnIndex);
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82).fillInStackTrace();
            }
            SQLXML value = null;
            this.setIsNull(3);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
                Datum datum = this.getRowBufferDatumAt(columnIndex);
                this.setIsNull(datum == null);
                if (datum != null && !(datum instanceof SQLXML)) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getSQLXML").fillInStackTrace();
                }
                value = (SQLXML)((Object)datum);
            } else {
                this.setIsNull(4);
                value = this.resultSet.getSQLXML(columnIndex);
            }
            SQLXML sQLXML = value;
            return sQLXML;
        }
    }

    @Override
    public void updateRowId(int columnIndex, RowId x) throws SQLException {
        this.updateROWID(columnIndex, (ROWID)x);
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        this.updateCharacterStream(columnIndex, x, length);
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x) throws SQLException {
        this.updateCharacterStream(columnIndex, x);
    }

    @Override
    public void updateSQLXML(int columnIndex, SQLXML x) throws SQLException {
        this.updateOracleObject(columnIndex, (Datum)((Object)x));
    }

    @Override
    public void updateNString(int columnIndex, String value) throws SQLException {
        this.updateString(columnIndex, value);
    }

    @Override
    public void updateNClob(int columnIndex, NClob value) throws SQLException {
        this.updateClob(columnIndex, (Clob)value);
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream stream, long length) throws SQLException {
        this.updateAsciiStream(columnIndex, stream, (int)length);
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream stream) throws SQLException {
        this.updateAsciiStream(columnIndex, stream, Integer.MAX_VALUE);
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream stream, long length) throws SQLException {
        this.updateBinaryStream(columnIndex, stream, (int)length);
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream stream) throws SQLException {
        this.updateBinaryStream(columnIndex, stream, Integer.MAX_VALUE);
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader reader, long length) throws SQLException {
        this.updateCharacterStream(columnIndex, reader, (int)length);
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader reader) throws SQLException {
        this.updateCharacterStream(columnIndex, reader, Integer.MAX_VALUE);
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inStream) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (inStream == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "updateBlob").fillInStackTrace();
            }
            Blob lob = this.connection.createBlob();
            this.addToTempLobsToFree(lob);
            int bufferSize = ((BLOB)lob).getBufferSize();
            OutputStream outStream = lob.setBinaryStream(1L);
            byte[] buffer = new byte[bufferSize];
            try {
                int lengthRead;
                while ((lengthRead = inStream.read(buffer)) != -1) {
                    outStream.write(buffer, 0, lengthRead);
                }
                outStream.close();
                this.updateBlob(columnIndex, lob);
            }
            catch (IOException iox) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iox).fillInStackTrace();
            }
        }
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inStream, long length) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (inStream == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "updateBlob").fillInStackTrace();
            }
            Blob lob = this.connection.createBlob();
            this.addToTempLobsToFree(lob);
            int bufferSize = ((BLOB)lob).getBufferSize();
            OutputStream outStream = lob.setBinaryStream(1L);
            byte[] buffer = new byte[bufferSize];
            try {
                int lengthRead;
                for (long lengthRemaining = length; lengthRemaining > 0L && (lengthRead = inStream.read(buffer, 0, Math.min(bufferSize, (int)lengthRemaining))) != -1; lengthRemaining -= (long)lengthRead) {
                    outStream.write(buffer, 0, lengthRead);
                }
                outStream.close();
                this.updateBlob(columnIndex, lob);
            }
            catch (IOException iox) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iox).fillInStackTrace();
            }
        }
    }

    @Override
    public void updateClob(int columnIndex, Reader reader, long length) throws SQLException {
        this.updateClob(columnIndex, reader, length, (short)1);
    }

    void updateClob(int columnIndex, Reader reader, long length, short formOfUse) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (reader == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "updateClob").fillInStackTrace();
            }
            Clob lob = formOfUse == 1 ? this.connection.createClob() : this.connection.createNClob();
            this.addToTempLobsToFree(lob);
            int bufferSize = ((CLOB)lob).getBufferSize();
            Writer writer = lob.setCharacterStream(1L);
            char[] buffer = new char[bufferSize];
            try {
                int lengthRead;
                for (long lengthRemaining = length; lengthRemaining > 0L && (lengthRead = reader.read(buffer, 0, Math.min(bufferSize, (int)lengthRemaining))) != -1; lengthRemaining -= (long)lengthRead) {
                    writer.write(buffer, 0, lengthRead);
                }
                writer.close();
                this.updateClob(columnIndex, lob);
            }
            catch (IOException iox) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iox).fillInStackTrace();
            }
        }
    }

    @Override
    public void updateClob(int columnIndex, Reader reader) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (reader == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "updateClob").fillInStackTrace();
            }
            Clob lob = this.connection.createClob();
            this.addToTempLobsToFree(lob);
            int bufferSize = ((CLOB)lob).getBufferSize();
            Writer writer = lob.setCharacterStream(1L);
            char[] buffer = new char[bufferSize];
            try {
                int lengthRead;
                while ((lengthRead = reader.read(buffer)) != -1) {
                    writer.write(buffer, 0, lengthRead);
                }
                writer.close();
                this.updateClob(columnIndex, lob);
            }
            catch (IOException iox) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iox).fillInStackTrace();
            }
        }
    }

    void updateClob(int columnIndex, InputStream inStream, int length) throws SQLException {
        this.updateClob(columnIndex, inStream, length, (short)1);
    }

    void updateClob(int columnIndex, InputStream inStream, int length, short formOfUse) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (inStream == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "updateClob").fillInStackTrace();
            }
            Clob lob = formOfUse == 1 ? this.connection.createClob() : this.connection.createNClob();
            this.addToTempLobsToFree(lob);
            int bufferSize = ((CLOB)lob).getBufferSize();
            OutputStream outStream = lob.setAsciiStream(1L);
            byte[] buffer = new byte[bufferSize];
            try {
                int lengthRead;
                for (long lengthRemaining = (long)length; lengthRemaining > 0L && (lengthRead = inStream.read(buffer, 0, Math.min(bufferSize, (int)lengthRemaining))) != -1; lengthRemaining -= (long)lengthRead) {
                    outStream.write(buffer, 0, lengthRead);
                }
                outStream.close();
                this.updateClob(columnIndex, lob);
            }
            catch (IOException iox) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iox).fillInStackTrace();
            }
        }
    }

    void updateNClob(int columnIndex, InputStream inStream, int length) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (inStream == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "updateNClob").fillInStackTrace();
            }
            NClob lob = this.connection.createNClob();
            this.addToTempLobsToFree(lob);
            int bufferSize = ((NCLOB)lob).getBufferSize();
            OutputStream outStream = lob.setAsciiStream(1L);
            byte[] buffer = new byte[bufferSize];
            try {
                int lengthRead;
                for (long lengthRemaining = (long)length; lengthRemaining > 0L && (lengthRead = inStream.read(buffer, 0, Math.min(bufferSize, (int)lengthRemaining))) != -1; lengthRemaining -= (long)lengthRead) {
                    outStream.write(buffer, 0, lengthRead);
                }
                outStream.close();
                this.updateNClob(columnIndex, lob);
            }
            catch (IOException iox) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iox).fillInStackTrace();
            }
        }
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader, long length) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (reader == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "updateNClob").fillInStackTrace();
            }
            NClob lob = this.connection.createNClob();
            this.addToTempLobsToFree(lob);
            int bufferSize = ((CLOB)((Object)lob)).getBufferSize();
            Writer writer = lob.setCharacterStream(1L);
            char[] buffer = new char[bufferSize];
            try {
                int lengthRead;
                for (long lengthRemaining = length; lengthRemaining > 0L && (lengthRead = reader.read(buffer, 0, Math.min(bufferSize, (int)lengthRemaining))) != -1; lengthRemaining -= (long)lengthRead) {
                    writer.write(buffer, 0, lengthRead);
                }
                writer.close();
                this.updateNClob(columnIndex, lob);
            }
            catch (IOException iox) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iox).fillInStackTrace();
            }
        }
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (reader == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "updateNClob").fillInStackTrace();
            }
            NClob lob = this.connection.createNClob();
            this.addToTempLobsToFree(lob);
            int bufferSize = ((CLOB)((Object)lob)).getBufferSize();
            Writer writer = lob.setCharacterStream(1L);
            char[] buffer = new char[bufferSize];
            try {
                int lengthRead;
                while ((lengthRead = reader.read(buffer)) != -1) {
                    writer.write(buffer, 0, lengthRead);
                }
                writer.close();
                this.updateNClob(columnIndex, lob);
            }
            catch (IOException iox) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iox).fillInStackTrace();
            }
        }
    }

    @Override
    public void updateString(int columnIndex, String x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (x == null || x.length() == 0) {
                this.updateNull(columnIndex);
            } else {
                this.updateObject(columnIndex, (Object)x);
            }
        }
    }

    @Override
    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        this.updateObject(columnIndex, (Object)x);
    }

    @Override
    public void updateByte(int columnIndex, byte x) throws SQLException {
        this.updateObject(columnIndex, (Object)x);
    }

    @Override
    public void updateShort(int columnIndex, short x) throws SQLException {
        this.updateObject(columnIndex, (Object)x);
    }

    @Override
    public void updateInt(int columnIndex, int x) throws SQLException {
        this.updateObject(columnIndex, (Object)x);
    }

    @Override
    public void updateLong(int columnIndex, long x) throws SQLException {
        this.updateObject(columnIndex, (Object)x);
    }

    @Override
    public void updateFloat(int columnIndex, float x) throws SQLException {
        this.updateObject(columnIndex, (Object)Float.valueOf(x));
    }

    @Override
    public void updateDouble(int columnIndex, double x) throws SQLException {
        this.updateObject(columnIndex, (Object)x);
    }

    @Override
    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        this.updateObject(columnIndex, (Object)x);
    }

    @Override
    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        this.updateObject(columnIndex, (Object)x);
    }

    @Override
    public void updateDate(int columnIndex, Date x) throws SQLException {
        this.updateObject(columnIndex, (Object)x);
    }

    @Override
    public void updateTime(int columnIndex, Time x) throws SQLException {
        this.updateObject(columnIndex, (Object)x);
    }

    @Override
    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        this.updateObject(columnIndex, (Object)x);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82).fillInStackTrace();
            }
            OracleResultSetMetaData metadata = (OracleResultSetMetaData)this.getInternalMetadata();
            int type = metadata.getColumnType(columnIndex);
            if (x != null && length > 0) {
                StringBuilder inStr;
                switch (type) {
                    case 2005: {
                        this.updateClob(columnIndex, x, length);
                        return;
                    }
                    case 2011: {
                        this.updateNClob(columnIndex, x, length);
                        return;
                    }
                    case 2004: {
                        this.updateBlob(columnIndex, x, (long)length);
                        return;
                    }
                    case -1: {
                        int[] infoArray = new int[]{length, 1};
                        this.setRowBufferAt(columnIndex, x, infoArray);
                        return;
                    }
                }
                try {
                    int lengthRemaining;
                    int len = 0;
                    byte[] asciiBytes = new byte[1024];
                    char[] charBuf = new char[1024];
                    inStr = new StringBuilder(1024);
                    for (lengthRemaining = length; lengthRemaining > 0 && (len = lengthRemaining >= 1024 ? x.read(asciiBytes) : x.read(asciiBytes, 0, lengthRemaining)) != -1; lengthRemaining -= len) {
                        DBConversion.asciiBytesToJavaChars(asciiBytes, len, charBuf);
                        inStr.append(charBuf, 0, len);
                    }
                    x.close();
                    if (lengthRemaining == length) {
                        this.updateNull(columnIndex);
                        return;
                    }
                }
                catch (IOException e) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), e).fillInStackTrace();
                }
                {
                    this.updateString(columnIndex, inStr.toString());
                    return;
                }
            }
            this.setRowBufferAt(columnIndex, null);
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82).fillInStackTrace();
            }
            int type = this.getInternalMetadata().getColumnType(columnIndex);
            if (x != null && length > 0) {
                ByteArrayOutputStream bstream;
                switch (type) {
                    case 2004: {
                        this.updateBlob(columnIndex, x, (long)length);
                        return;
                    }
                    case -4: {
                        int[] infoArray = new int[]{length, 2};
                        this.setRowBufferAt(columnIndex, x, infoArray);
                        return;
                    }
                }
                try {
                    int lengthRemaining;
                    int len = 0;
                    byte[] rawBytes = new byte[1024];
                    bstream = new ByteArrayOutputStream(1024);
                    for (lengthRemaining = length; lengthRemaining > 0 && (len = lengthRemaining >= 1024 ? x.read(rawBytes) : x.read(rawBytes, 0, lengthRemaining)) != -1; lengthRemaining -= len) {
                        bstream.write(rawBytes, 0, len);
                    }
                    x.close();
                    if (lengthRemaining == length) {
                        this.updateNull(columnIndex);
                        return;
                    }
                }
                catch (IOException e) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), e).fillInStackTrace();
                }
                {
                    this.updateBytes(columnIndex, bstream.toByteArray());
                    return;
                }
            }
            this.setRowBufferAt(columnIndex, null);
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            int len = 0;
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82).fillInStackTrace();
            }
            OracleResultSetMetaData metadata = (OracleResultSetMetaData)this.getInternalMetadata();
            int type = metadata.getColumnType(columnIndex);
            if (x != null && length > 0) {
                StringBuilder inStr;
                switch (type) {
                    case 2005: {
                        this.updateClob(columnIndex, x, (long)length);
                        return;
                    }
                    case 2011: {
                        this.updateNClob(columnIndex, x, (long)length);
                        return;
                    }
                    case -1: {
                        int[] infoArray = new int[]{length};
                        this.setRowBufferAt(columnIndex, x, infoArray);
                        return;
                    }
                }
                try {
                    int lengthRemaining;
                    char[] chars = new char[1024];
                    inStr = new StringBuilder(1024);
                    for (lengthRemaining = length; lengthRemaining > 0 && (len = lengthRemaining >= 1024 ? x.read(chars) : x.read(chars, 0, lengthRemaining)) != -1; lengthRemaining -= len) {
                        inStr.append(chars, 0, len);
                    }
                    x.close();
                    if (lengthRemaining == length) {
                        this.updateNull(columnIndex);
                        return;
                    }
                }
                catch (IOException e) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), e).fillInStackTrace();
                }
                {
                    this.updateString(columnIndex, inStr.toString());
                    return;
                }
            }
            this.setRowBufferAt(columnIndex, null);
            return;
        }
    }

    @Override
    public void updateObject(int columnIndex, Object x, int scale) throws SQLException {
        this.updateObject(columnIndex, x);
    }

    @Override
    public void updateObject(int columnIndex, Object x, SQLType targetSqlType) throws SQLException {
        if (targetSqlType == null) {
            throw new IllegalArgumentException("null SQLType");
        }
        int oracleType = targetSqlType.getVendorTypeNumber();
        this.updateObject(columnIndex, x, oracleType, false);
    }

    @Override
    public void updateObject(int columnIndex, Object x, SQLType targetSqlType, int scaleOrLength) throws SQLException {
        this.updateObject(columnIndex, x, targetSqlType);
    }

    @Override
    public void updateObject(int columnIndex, Object x) throws SQLException {
        this.updateObject(columnIndex, x, 0, true);
    }

    private void updateObject(int columnIndex, Object x, int targetVendorType, boolean useColumnType) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82).fillInStackTrace();
            }
            if (x != null && x instanceof Reader) {
                this.updateCharacterStream(columnIndex, (Reader)x);
            } else {
                Datum datum = null;
                if (x != null) {
                    if (x instanceof OracleData) {
                        Object jdbcObject = ((OracleData)x).toJDBCObject(this.connection);
                        if (jdbcObject instanceof _Proxy_) {
                            final _Proxy_ proxiedJDBCObject = (_Proxy_)jdbcObject;
                            jdbcObject = AccessController.doPrivileged(new PrivilegedAction<Object>(){

                                @Override
                                public Object run() {
                                    return ProxyFactory.extractDelegate(proxiedJDBCObject);
                                }
                            });
                        }
                        x = jdbcObject;
                    }
                    if (x instanceof Datum) {
                        datum = (Datum)x;
                    } else {
                        OracleResultSetMetaData rsmd = (OracleResultSetMetaData)this.getInternalMetadata();
                        int idx = columnIndex;
                        int columnType = useColumnType ? rsmd.getColumnType(idx) : targetVendorType;
                        switch (columnType) {
                            case -15: 
                            case -9: 
                            case -1: 
                            case 1: 
                            case 12: {
                                if (x instanceof byte[]) {
                                    byte[] xTemp = (byte[])x;
                                    char[] xChars = new char[xTemp.length * 3];
                                    int xCharsLength = DBConversion.RAWBytesToHexChars(xTemp, xTemp.length, xChars);
                                    x = new String(xChars, 0, xCharsLength);
                                    break;
                                }
                                if (!(x instanceof Boolean)) break;
                                x = "" + ((Boolean)x != false ? 1 : 0);
                                break;
                            }
                            case 93: {
                                if (!(x instanceof Calendar)) break;
                                x = JavaToJavaConverter.convert(x, TIMESTAMP.class, this.connection, 0, null);
                                break;
                            }
                            case 91: {
                                if (!(x instanceof String)) break;
                                x = Date.valueOf((String)x);
                            }
                        }
                        datum = SQLUtil.makeOracleDatum(this.connection, x, columnType, null, rsmd.isNCHAR(idx));
                    }
                }
                this.setRowBufferAt(columnIndex, datum);
            }
        }
    }

    @Override
    public void updateOracleObject(int columnIndex, Datum x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.doUpdateOracleObject(columnIndex, x);
        }
    }

    private void doUpdateOracleObject(int columnIndex, Datum x) throws SQLException {
        this.setRowBufferAt(columnIndex, x);
    }

    @Override
    public void updateROWID(int columnIndex, ROWID x) throws SQLException {
        this.updateOracleObject(columnIndex, (Datum)x);
    }

    @Override
    public void updateNUMBER(int columnIndex, NUMBER x) throws SQLException {
        this.updateOracleObject(columnIndex, (Datum)x);
    }

    @Override
    public void updateDATE(int columnIndex, DATE x) throws SQLException {
        this.updateOracleObject(columnIndex, (Datum)x);
    }

    @Override
    public void updateINTERVALYM(int columnIndex, INTERVALYM x) throws SQLException {
        this.updateOracleObject(columnIndex, (Datum)x);
    }

    @Override
    public void updateINTERVALDS(int columnIndex, INTERVALDS x) throws SQLException {
        this.updateOracleObject(columnIndex, (Datum)x);
    }

    @Override
    public void updateTIMESTAMP(int columnIndex, TIMESTAMP x) throws SQLException {
        this.updateOracleObject(columnIndex, (Datum)x);
    }

    @Override
    public void updateTIMESTAMPTZ(int columnIndex, TIMESTAMPTZ x) throws SQLException {
        this.updateOracleObject(columnIndex, (Datum)x);
    }

    @Override
    public void updateTIMESTAMPLTZ(int columnIndex, TIMESTAMPLTZ x) throws SQLException {
        this.updateOracleObject(columnIndex, (Datum)x);
    }

    @Override
    public void updateARRAY(int columnIndex, ARRAY x) throws SQLException {
        this.updateOracleObject(columnIndex, (Datum)x);
    }

    @Override
    public void updateSTRUCT(int columnIndex, STRUCT x) throws SQLException {
        this.updateOracleObject(columnIndex, (Datum)x);
    }

    public void updateOPAQUE(int columnIndex, OPAQUE x) throws SQLException {
        this.updateOracleObject(columnIndex, (Datum)x);
    }

    @Override
    public void updateREF(int columnIndex, REF x) throws SQLException {
        this.updateOracleObject(columnIndex, (Datum)x);
    }

    @Override
    public void updateCHAR(int columnIndex, CHAR x) throws SQLException {
        this.updateOracleObject(columnIndex, (Datum)x);
    }

    @Override
    public void updateRAW(int columnIndex, RAW x) throws SQLException {
        this.updateOracleObject(columnIndex, (Datum)x);
    }

    @Override
    public void updateBLOB(int columnIndex, BLOB x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.doUpdateOracleObject(columnIndex, x);
        }
    }

    @Override
    public void updateCLOB(int columnIndex, CLOB x) throws SQLException {
        this.updateOracleObject(columnIndex, (Datum)x);
    }

    @Override
    public void updateBFILE(int columnIndex, BFILE x) throws SQLException {
        this.updateOracleObject(columnIndex, (Datum)x);
    }

    @Override
    public void updateBfile(int columnIndex, BFILE x) throws SQLException {
        this.updateOracleObject(columnIndex, (Datum)x);
    }

    @Override
    public void updateCustomDatum(int columnIndex, CustomDatum x) throws SQLException {
        throw new Error("wanna do datum = ((CustomDatum) x).toDatum(m_comm)");
    }

    @Override
    public void updateORAData(int columnIndex, ORAData x) throws SQLException {
        Datum d = x.toDatum(this.connection);
        this.updateOracleObject(columnIndex, d);
    }

    @Override
    public void updateRef(int columnIndex, Ref x) throws SQLException {
        this.updateREF(columnIndex, (REF)x);
    }

    @Override
    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        this.updateBLOB(columnIndex, (BLOB)x);
    }

    @Override
    public void updateClob(int columnIndex, Clob x) throws SQLException {
        this.updateCLOB(columnIndex, (CLOB)x);
    }

    @Override
    public void updateArray(int columnIndex, Array x) throws SQLException {
        this.updateARRAY(columnIndex, (ARRAY)x);
    }
}

