/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.protocol.dsound;

import com.sun.media.JMFSecurityManager;
import com.sun.media.protocol.BasicPushBufferDataSource;
import com.sun.media.protocol.dsound.DirectSoundStream;
import java.io.IOException;
import javax.media.CaptureDeviceInfo;
import javax.media.CaptureDeviceManager;
import javax.media.Duration;
import javax.media.Time;
import javax.media.control.FormatControl;
import javax.media.protocol.CaptureDevice;
import javax.media.protocol.PushBufferStream;
import javax.media.protocol.RateConfiguration;
import javax.media.protocol.RateConfigureable;
import javax.media.protocol.RateRange;
import javax.media.protocol.SourceStream;

public class DataSource
extends BasicPushBufferDataSource
implements CaptureDevice,
RateConfigureable {
    PushBufferStream[] streams = new PushBufferStream[0];
    DirectSoundStream sourceStream = null;
    String contentType;
    Time duration;
    boolean started = false;
    public static String NAME = "DirectSoundCapture";
    static String ContentType = "raw";

    public DataSource() {
        JMFSecurityManager.checkCapture();
        this.contentType = ContentType;
        this.duration = Duration.DURATION_UNBOUNDED;
        this.sourceStream = new DirectSoundStream(this);
        this.streams = new PushBufferStream[1];
        this.streams[0] = this.sourceStream;
    }

    public CaptureDeviceInfo getCaptureDeviceInfo() {
        CaptureDeviceInfo cdi = CaptureDeviceManager.getDevice(NAME);
        return cdi;
    }

    public FormatControl[] getFormatControls() {
        FormatControl[] fc = new FormatControl[]{(FormatControl)this.sourceStream.getControl("javax.media.control.FormatControl")};
        return fc;
    }

    public PushBufferStream[] getStreams() {
        if (this.streams == null) {
            System.err.println("DataSource needs to be connected before calling getStreams");
        }
        return this.streams;
    }

    public void connect() throws IOException {
        if (this.sourceStream.isConnected()) {
            return;
        }
        if (this.getLocator() != null) {
            this.sourceStream.setFormat(DirectSoundStream.parseLocator(this.getLocator()));
        }
        this.sourceStream.connect();
    }

    public void disconnect() {
        this.sourceStream.disconnect();
    }

    public void start() throws IOException {
        this.sourceStream.start();
    }

    public void stop() throws IOException {
        this.sourceStream.stop();
    }

    public String getContentType() {
        return this.contentType;
    }

    public Time getDuration() {
        return this.duration;
    }

    boolean getStarted() {
        return this.started;
    }

    public Object[] getControls() {
        Object[] o2 = this.sourceStream.getControls();
        return o2;
    }

    public Object getControl(String name) {
        return this.sourceStream.getControl(name);
    }

    public RateConfiguration[] getRateConfigurations() {
        RateConfiguration[] config = new RateConfiguration[]{new OneRateConfig()};
        return config;
    }

    public RateConfiguration setRateConfiguration(RateConfiguration config) {
        return config;
    }

    class OneRateConfig
    implements RateConfiguration {
        OneRateConfig() {
        }

        public RateRange getRate() {
            return new RateRange(1.0f, 1.0f, 1.0f, true);
        }

        public SourceStream[] getStreams() {
            SourceStream[] ss = new SourceStream[]{DataSource.this.sourceStream};
            return ss;
        }
    }
}

