/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.generic;

import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.Select;
import org.apache.bcel.generic.Visitor;
import org.apache.bcel.util.ByteSequence;

public class LOOKUPSWITCH
extends Select {
    LOOKUPSWITCH() {
    }

    public LOOKUPSWITCH(int[] match, InstructionHandle[] targets, InstructionHandle defaultTarget) {
        super((short)171, match, targets, defaultTarget);
        short _length = (short)(9 + this.getMatch_length() * 8);
        super.setLength(_length);
        this.setFixed_length(_length);
    }

    @Override
    public void dump(DataOutputStream out) throws IOException {
        super.dump(out);
        int _match_length = this.getMatch_length();
        out.writeInt(_match_length);
        int i = 0;
        while (i < _match_length) {
            out.writeInt(super.getMatch(i));
            out.writeInt(this.setIndices(i, this.getTargetOffset(super.getTarget(i))));
            ++i;
        }
    }

    @Override
    protected void initFromFile(ByteSequence bytes, boolean wide) throws IOException {
        super.initFromFile(bytes, wide);
        int _match_length = bytes.readInt();
        this.setMatch_length(_match_length);
        short _fixed_length = (short)(9 + _match_length * 8);
        this.setFixed_length(_fixed_length);
        short _length = (short)(_match_length + super.getPadding());
        super.setLength(_length);
        super.setMatches(new int[_match_length]);
        super.setIndices(new int[_match_length]);
        super.setTargets(new InstructionHandle[_match_length]);
        int i = 0;
        while (i < _match_length) {
            super.setMatch(i, bytes.readInt());
            super.setIndices(i, bytes.readInt());
            ++i;
        }
    }

    @Override
    public void accept(Visitor v) {
        v.visitVariableLengthInstruction(this);
        v.visitStackConsumer(this);
        v.visitBranchInstruction(this);
        v.visitSelect(this);
        v.visitLOOKUPSWITCH(this);
    }
}

