/*
 * Decompiled with CFR 0.152.
 */
package ext.module.xfil.fx;

import javafx.animation.Animation;
import javafx.animation.FadeTransition;
import javafx.animation.Interpolator;
import javafx.animation.ParallelTransition;
import javafx.application.Platform;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.Slider;
import javafx.scene.control.ToolBar;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Region;
import javafx.scene.media.MediaPlayer;
import javafx.scene.media.MediaView;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.util.Duration;

public class PlayerPane
extends Region {
    private MediaPlayer mp;
    private MediaView mediaView;
    private final boolean repeat = false;
    private boolean stopRequested = false;
    private boolean atEndOfMedia = false;
    private Duration duration;
    private Slider timeSlider;
    private Label playTime;
    private Slider volumeSlider;
    private ToolBar topBar = new ToolBar();
    private ToolBar bottomBar = new ToolBar();
    private HBox mediaTopBar;
    private HBox mediaBottomBar;
    private ParallelTransition transition = null;
    final double mediaWidth = 480.0;
    final double mediaHeight = 270.0;

    protected void layoutChildren() {
        double controlHeight = 40.0;
        double controlOffset = 115.0;
        this.mediaView.relocate(0.0, 0.0);
        this.mediaView.setFitWidth(480.0);
        this.mediaView.setFitHeight(270.0);
        this.topBar.resizeRelocate(0.0, 0.0, 480.0, 40.0);
        this.bottomBar.resizeRelocate(115.0, 230.0, 480.0, 40.0);
    }

    protected double computeMinWidth(double height) {
        return this.mediaBottomBar.prefWidth(-1.0);
    }

    protected double computeMinHeight(double width) {
        return 200.0;
    }

    protected double computePrefWidth(double height) {
        return Math.max((double)this.mp.getMedia().getWidth(), this.mediaBottomBar.prefWidth(height));
    }

    protected double computePrefHeight(double width) {
        return (double)this.mp.getMedia().getHeight() + this.mediaBottomBar.prefHeight(width);
    }

    protected double computeMaxWidth(double height) {
        return Double.MAX_VALUE;
    }

    protected double computeMaxHeight(double width) {
        return Double.MAX_VALUE;
    }

    public PlayerPane(MediaPlayer mp) {
        this.mp = mp;
        this.setId("player-pane");
        this.mediaView = new MediaView(mp);
        this.mediaTopBar = new HBox();
        this.mediaTopBar.setPadding(new Insets(5.0, 10.0, 5.0, 10.0));
        this.mediaTopBar.setAlignment(Pos.CENTER);
        this.mediaTopBar.setOpacity(1.0);
        this.topBar.setId("top-bar");
        this.topBar.setStyle("-fx-background-color: rgb(0,0,0.0,0.0);");
        this.bottomBar.setStyle("-fx-background-color: rgb(0,0,0.0,0.0);");
        this.setOnMouseEntered(t -> {
            if (this.transition != null) {
                this.transition.stop();
            }
            FadeTransition fadeTransition1 = new FadeTransition(Duration.millis((double)200.0), (Node)this.topBar);
            fadeTransition1.setToValue(1.0);
            fadeTransition1.setInterpolator(Interpolator.EASE_OUT);
            FadeTransition fadeTransition2 = new FadeTransition(Duration.millis((double)200.0), (Node)this.bottomBar);
            fadeTransition2.setToValue(1.0);
            fadeTransition2.setInterpolator(Interpolator.EASE_OUT);
            this.transition = new ParallelTransition(new Animation[]{fadeTransition1, fadeTransition2});
            this.transition.play();
        });
        this.setOnMouseExited(t -> {
            if (this.transition != null) {
                this.transition.stop();
            }
            FadeTransition fadeTransitionTop = new FadeTransition(Duration.millis((double)800.0), (Node)this.topBar);
            fadeTransitionTop.setToValue(0.0);
            fadeTransitionTop.setInterpolator(Interpolator.EASE_OUT);
            FadeTransition fadeTransitionBottom = new FadeTransition(Duration.millis((double)800.0), (Node)this.bottomBar);
            fadeTransitionBottom.setToValue(0.0);
            fadeTransitionBottom.setInterpolator(Interpolator.EASE_OUT);
            this.transition = new ParallelTransition(new Animation[]{fadeTransitionTop, fadeTransitionBottom});
            this.transition.play();
        });
        mp.currentTimeProperty().addListener((observable, oldValue, newValue) -> this.updateValues());
        mp.setOnPlaying(() -> {
            if (this.stopRequested) {
                mp.pause();
                this.stopRequested = false;
            }
        });
        mp.setOnReady(() -> {
            this.duration = mp.getMedia().getDuration();
            this.updateValues();
        });
        mp.setOnEndOfMedia(() -> {
            this.stopRequested = true;
            this.atEndOfMedia = true;
        });
        mp.setCycleCount(1);
        Label timeLabel = new Label("Time");
        timeLabel.setMinWidth(Double.NEGATIVE_INFINITY);
        timeLabel.setTextFill((Paint)Color.WHITE);
        this.mediaTopBar.getChildren().add((Object)timeLabel);
        this.timeSlider = new Slider();
        this.timeSlider.setId("media-slider");
        this.timeSlider.setMinWidth(200.0);
        this.timeSlider.setMaxWidth(Double.MAX_VALUE);
        this.timeSlider.valueProperty().addListener(ov -> {
            if (this.timeSlider.isValueChanging()) {
                if (this.duration != null) {
                    mp.seek(this.duration.multiply(this.timeSlider.getValue() / 100.0));
                }
                this.updateValues();
            }
        });
        this.mediaTopBar.getChildren().add((Object)this.timeSlider);
        this.playTime = new Label();
        this.playTime.setPrefWidth(75.0);
        this.playTime.setMinWidth(75.0);
        this.playTime.setTextFill((Paint)Color.WHITE);
        this.mediaTopBar.getChildren().add((Object)this.playTime);
        Label volumeLabel = new Label("Vol");
        volumeLabel.setMinWidth(Double.NEGATIVE_INFINITY);
        volumeLabel.setTextFill((Paint)Color.WHITE);
        this.mediaTopBar.getChildren().add((Object)volumeLabel);
        this.volumeSlider = new Slider();
        this.volumeSlider.setId("media-slider");
        this.volumeSlider.setPrefWidth(120.0);
        this.volumeSlider.setMinWidth(30.0);
        this.volumeSlider.setMaxWidth(Double.NEGATIVE_INFINITY);
        this.volumeSlider.valueProperty().addListener(ov -> {});
        this.volumeSlider.valueProperty().addListener((observable, oldValue, newValue) -> {
            if (this.volumeSlider.isValueChanging()) {
                mp.setVolume(this.volumeSlider.getValue() / 100.0);
            }
        });
        this.mediaTopBar.getChildren().add((Object)this.volumeSlider);
        EventHandler backAction = e -> mp.seek(Duration.ZERO);
        EventHandler stopAction = e -> mp.stop();
        EventHandler playAction = e -> mp.play();
        EventHandler pauseAction = e -> mp.pause();
        EventHandler forwardAction = e -> {
            Duration currentTime = mp.getCurrentTime();
            mp.seek(Duration.seconds((double)(currentTime.toSeconds() + 5.0)));
        };
        this.mediaBottomBar = new HBox();
        this.mediaBottomBar.setId("bottom");
        this.mediaBottomBar.setSpacing(0.0);
        this.mediaBottomBar.setAlignment(Pos.CENTER);
        Button backButton = new Button("Back");
        backButton.setId("back-button");
        backButton.setOnAction(backAction);
        Button stopButton = new Button("Stop");
        stopButton.setId("stop-button");
        stopButton.setOnAction(stopAction);
        Button playButton = new Button("Play");
        playButton.setId("play-button");
        playButton.setOnAction(playAction);
        Button pauseButton = new Button("Pause");
        pauseButton.setId("pause-button");
        pauseButton.setOnAction(pauseAction);
        Button forwardButton = new Button("Forward");
        forwardButton.setId("forward-button");
        forwardButton.setOnAction(forwardAction);
        this.mediaBottomBar.getChildren().addAll((Object[])new Node[]{backButton, stopButton, playButton, pauseButton, forwardButton});
        this.topBar.getItems().add((Object)this.mediaTopBar);
        this.bottomBar.getItems().add((Object)this.mediaBottomBar);
        this.getChildren().addAll((Object[])new Node[]{this.mediaView, this.topBar, this.bottomBar});
        this.topBar.setOpacity(0.0);
        this.bottomBar.setOpacity(0.0);
    }

    protected void updateValues() {
        if (this.playTime != null && this.timeSlider != null && this.volumeSlider != null && this.duration != null) {
            Platform.runLater(() -> {
                Duration currentTime = this.mp.getCurrentTime();
                this.playTime.setText(PlayerPane.formatTime(currentTime, this.duration));
                this.timeSlider.setDisable(this.duration.isUnknown());
                if (!this.timeSlider.isDisabled() && this.duration.greaterThan(Duration.ZERO) && !this.timeSlider.isValueChanging()) {
                    this.timeSlider.setValue(currentTime.divide(this.duration).toMillis() * 100.0);
                }
                if (!this.volumeSlider.isValueChanging()) {
                    this.volumeSlider.setValue((double)((int)Math.round(this.mp.getVolume() * 100.0)));
                }
            });
        }
    }

    private static String formatTime(Duration elapsed, Duration duration) {
        int intElapsed = (int)Math.floor(elapsed.toSeconds());
        int elapsedHours = intElapsed / 3600;
        if (elapsedHours > 0) {
            intElapsed -= elapsedHours * 60 * 60;
        }
        int elapsedMinutes = intElapsed / 60;
        int elapsedSeconds = intElapsed - elapsedHours * 60 * 60 - elapsedMinutes * 60;
        if (duration.greaterThan(Duration.ZERO)) {
            int intDuration = (int)Math.floor(duration.toSeconds());
            int durationHours = intDuration / 3600;
            if (durationHours > 0) {
                intDuration -= durationHours * 60 * 60;
            }
            int durationMinutes = intDuration / 60;
            int durationSeconds = intDuration - durationHours * 60 * 60 - durationMinutes * 60;
            if (durationHours > 0) {
                return String.format("%d:%02d:%02d", elapsedHours, elapsedMinutes, elapsedSeconds);
            }
            return String.format("%02d:%02d", elapsedMinutes, elapsedSeconds);
        }
        if (elapsedHours > 0) {
            return String.format("%d:%02d:%02d", elapsedHours, elapsedMinutes, elapsedSeconds);
        }
        return String.format("%02d:%02d", elapsedMinutes, elapsedSeconds);
    }
}

