/*
 * Decompiled with CFR 0.152.
 */
package ext.module.xfil.dao;

import ext.base.core.BcStringUtil;
import ext.base.util.BcCollectionUtil;
import ext.lib.datasource.DtsSession;
import ext.lib.orm.dao.OrmAbstractDAO;
import ext.lib.sql.SqlConditionUtil;
import ext.lib.sql.SqlConstants;
import ext.lib.sql.SqlUtil;
import ext.lib.sql.context.SqlContext;
import ext.lib.sql.model.SqlSelectQuery;
import ext.lib.sql.model.SqlWhereElement;
import ext.module.xfil.model.XfilUriEntity;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class XfilUriEntityDAO
extends OrmAbstractDAO<XfilUriEntity> {
    private static Map<String, XfilUriEntityDAO> instanceMap = new HashMap<String, XfilUriEntityDAO>();

    private XfilUriEntityDAO() {
        super(new XfilUriEntity[0]);
    }

    public static XfilUriEntityDAO getInstance(String tableName) {
        XfilUriEntityDAO instance = instanceMap.get(tableName);
        if (instance == null) {
            instance = new XfilUriEntityDAO();
            instance.setTableName(tableName);
            instanceMap.put(tableName, instance);
        }
        return instance;
    }

    public SqlSelectQuery createSelectSql(SqlContext sqlContext, Mode mode, String alias, long entityId, long crawlId, String directory, String name, Short status, int rowLimit, boolean isFuzzy) throws Exception {
        String formula;
        ArrayList<String> conditionValueList;
        SqlWhereElement whereElement;
        String aliasWk = SqlUtil.tableAliasToNotNull(alias);
        SqlSelectQuery selectQuery = new SqlSelectQuery();
        if (entityId > 0L) {
            whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula(String.valueOf(alias) + ".id = " + entityId);
            selectQuery.addWhereElement(whereElement);
        }
        if (crawlId > 0L) {
            whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula(String.valueOf(alias) + ".crawl_id = " + crawlId);
            selectQuery.addWhereElement(whereElement);
        }
        if (!BcStringUtil.isEmpty(directory)) {
            whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            if (isFuzzy) {
                conditionValueList = new ArrayList<String>();
                conditionValueList.add(directory);
                formula = SqlConditionUtil.createPatternMatchClause(sqlContext, "path_", SqlConstants.PatternMatch.partialMatch, true, false, conditionValueList);
                whereElement.setFormula(formula);
            } else {
                whereElement.setFormula(String.valueOf(alias) + ".directory_" + sqlContext.toCondition_string("=", directory));
            }
            selectQuery.addWhereElement(whereElement);
        }
        if (!BcStringUtil.isEmpty(name)) {
            whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            if (isFuzzy) {
                conditionValueList = new ArrayList();
                conditionValueList.add(name);
                formula = SqlConditionUtil.createPatternMatchClause(sqlContext, String.valueOf(alias) + ".name_", SqlConstants.PatternMatch.partialMatch, true, false, conditionValueList);
                whereElement.setFormula(formula);
            } else {
                whereElement.setFormula(String.valueOf(alias) + ".name_" + sqlContext.toCondition_string("=", name));
            }
            selectQuery.addWhereElement(whereElement);
        }
        if (mode == Mode.createThumbnail) {
            whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula(String.valueOf(alias) + ".width" + " > 0");
            selectQuery.addWhereElement(whereElement);
            whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula(String.valueOf(alias) + ".thumbnail_datetime" + " Is Null");
            selectQuery.addWhereElement(whereElement);
            whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula(String.valueOf(alias) + ".missing_datetime" + " Is Null");
            selectQuery.addWhereElement(whereElement);
        } else if (mode == Mode.missing) {
            whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula(String.valueOf(alias) + ".missing_datetime" + " Is Not Null");
            selectQuery.addWhereElement(whereElement);
        }
        if (status != null) {
            whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula(String.valueOf(alias) + ".short_01 = " + status);
            selectQuery.addWhereElement(whereElement);
        }
        selectQuery.setFromClause(String.valueOf(this.getTableName()) + " AS " + alias);
        if (mode == Mode.name) {
            selectQuery.getOrderByList().add(String.valueOf(aliasWk) + "name_");
            selectQuery.getOrderByList().add(String.valueOf(aliasWk) + "directory_");
        } else {
            selectQuery.getOrderByList().add(String.valueOf(aliasWk) + mode.orderBy);
        }
        selectQuery.rowLimit = rowLimit;
        return selectQuery;
    }

    public <T> List<T> getList(DtsSession dtsSession, Mode mode, long entityId, long crawlId, String directory, String name, Short status, int rowLimit, boolean isFuzzy) throws Exception {
        SqlContext sqlContext = dtsSession.getSqlContext();
        String alias = "uri";
        SqlSelectQuery selectQuery = this.createSelectSql(sqlContext, mode, alias, entityId, crawlId, directory, name, status, rowLimit, isFuzzy);
        selectQuery.getSelectColumnList().addAll(this.getColumnNameList(alias));
        String sql = sqlContext.buildSelectQuery(selectQuery);
        return this.getEntityList(dtsSession, sql);
    }

    public <T> List<T> getListByLimit(DtsSession dtsSession, int rowLimit) throws Exception {
        SqlContext sqlContext = dtsSession.getSqlContext();
        String alias = "uri";
        long entityId = -1L;
        long crawlId = -1L;
        String directory = null;
        String name = null;
        Short status = null;
        boolean isFuzzy = false;
        SqlSelectQuery selectQuery = this.createSelectSql(sqlContext, Mode.id, alias, entityId, crawlId, directory, name, status, rowLimit, isFuzzy);
        selectQuery.getSelectColumnList().addAll(this.getColumnNameList(alias));
        String sql = sqlContext.buildSelectQuery(selectQuery);
        return this.getEntityList(dtsSession, sql);
    }

    public <T> T getById(DtsSession dtsSession, long entityId) throws Exception {
        long crawlId = -1L;
        String directory = null;
        String fileName = null;
        Short status = null;
        int rowLimit = -1;
        boolean isFuzzy = false;
        List<T> entityList = this.getList(dtsSession, Mode.id, entityId, crawlId, directory, fileName, status, rowLimit, isFuzzy);
        return BcCollectionUtil.getFirst(entityList);
    }

    public <T> List<T> getListByPath(DtsSession dtsSession, long crawlId, String directory, String fileName, boolean isFuzzy) throws Exception {
        if (BcStringUtil.isEmpty(directory) || BcStringUtil.isEmpty(fileName)) {
            throw new Exception("directory=" + directory + " fileName=" + fileName);
        }
        long entityId = -1L;
        Short status = null;
        int rowLimit = -1;
        List<T> entityList = this.getList(dtsSession, Mode.name, entityId, crawlId, directory, fileName, status, rowLimit, isFuzzy);
        return entityList;
    }

    public <T> T getByName(DtsSession dtsSession, String directory, String name) throws Exception {
        if (BcStringUtil.isEmpty(name)) {
            return null;
        }
        long entityId = -1L;
        long crawlId = -1L;
        Short status = null;
        int rowLimit = -1;
        boolean isFuzzy = false;
        List<T> entityList = this.getList(dtsSession, Mode.name, entityId, crawlId, directory, name, status, rowLimit, isFuzzy);
        return BcCollectionUtil.getFirst(entityList);
    }

    public <T> List<T> getListByName(DtsSession dtsSession, String name, boolean isFuzzy) throws Exception {
        if (BcStringUtil.isEmpty(name)) {
            return null;
        }
        long entityId = -1L;
        long crawlId = -1L;
        String directory = null;
        Short status = null;
        int rowLimit = -1;
        List<T> entityList = this.getList(dtsSession, Mode.name, entityId, crawlId, directory, name, status, rowLimit, isFuzzy);
        return entityList;
    }

    public <T> List<T> getListByDirectory(DtsSession dtsSession, String directory, boolean isFuzzy) throws Exception {
        if (BcStringUtil.isEmpty(directory)) {
            return null;
        }
        long entityId = -1L;
        long crawlId = -1L;
        String name = null;
        Short status = null;
        int rowLimit = -1;
        List<T> entityList = this.getList(dtsSession, Mode.name, entityId, crawlId, directory, name, status, rowLimit, isFuzzy);
        return entityList;
    }

    public <T> T getForCreateThumbnail(DtsSession dtsSession) throws Exception {
        long entityId = -1L;
        long crawlId = -1L;
        String directory = null;
        String name = null;
        Short status = null;
        int rowLimit = -1;
        boolean isFuzzy = false;
        List<T> entityList = this.getList(dtsSession, Mode.createThumbnail, entityId, crawlId, directory, name, status, rowLimit, isFuzzy);
        return BcCollectionUtil.getFirst(entityList);
    }

    public int deleteBylId(DtsSession dtsSession, long entityId) throws Exception {
        String sql = "DELETE FROM " + this.getTableName() + " WHERE id = " + entityId;
        return SqlUtil.executeUpdate(dtsSession.getConnection(), sql);
    }

    public int deleteByCrawlId(DtsSession dtsSession, long crawlId, long entityId, boolean missing) throws Exception {
        String sql = "DELETE FROM " + this.getTableName() + " WHERE crawl_id = " + crawlId;
        if (entityId > 0L) {
            sql = String.valueOf(sql) + " AND id = " + entityId;
        }
        if (missing) {
            sql = String.valueOf(sql) + " AND missing_datetime Is Not NUll";
        }
        return SqlUtil.executeUpdate(dtsSession.getConnection(), sql);
    }

    public static enum Mode {
        id("id"),
        name("name_"),
        createThumbnail("id"),
        missing("id");

        public final String orderBy;

        private Mode(String orderBy) {
            this.orderBy = orderBy;
        }
    }
}

