/*
 * Decompiled with CFR 0.152.
 */
package ext.module.scrp.rmo;

import ext.base.log.BcLogUtil;
import ext.lib.datasource.DtsSession;
import ext.lib.rmi.model.RmiRmoArgument;
import ext.lib.rmi.rmo.RmiAbstractRMO;
import ext.module.scrp.dao.ScrpScriptDAO;
import ext.module.scrp.model.ScrpScript;
import java.util.List;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;

public class ScrpScriptRMO
extends RmiAbstractRMO {
    public void putScript(RmiRmoArgument rmoArg) throws Exception {
        ScrpScript script = (ScrpScript)rmoArg.getRequest().getData();
        DtsSession dtsSession = rmoArg.getDtsSession(this);
        ScrpScriptDAO.getInstance().putEntity(dtsSession, script);
        rmoArg.getRespons().addData(script);
    }

    public void getScriptByName(RmiRmoArgument rmoArg) throws Exception {
        String scriptName = rmoArg.getRequest().getDataAsString();
        DtsSession dtsSession = rmoArg.getDtsSession(this);
        ScrpScript script = ScrpScriptDAO.getInstance().getScriptByName(dtsSession, scriptName);
        rmoArg.getRespons().addData(script);
    }

    public void getScriptList(RmiRmoArgument rmoArg) throws Exception {
        DtsSession dtsSession = rmoArg.getDtsSession(this);
        List<ScrpScript> scriptList = ScrpScriptDAO.getInstance().getScriptList(dtsSession);
        rmoArg.getRespons().addData(scriptList);
    }

    public void doScriptByName(RmiRmoArgument rmoArg) throws Exception {
        String scriptName = rmoArg.getRequest().getDataAsString();
        DtsSession dtsSession = rmoArg.getDtsSession(this);
        ScrpScript script = ScrpScriptDAO.getInstance().getScriptByName(dtsSession, scriptName);
        Object res = this.doScript(script.engine, script.script);
        rmoArg.getRespons().addData(res);
    }

    public void doScript(RmiRmoArgument rmoArg) throws Exception {
        String engineName = rmoArg.getRequest().getDataAsString();
        String script = rmoArg.getRequest().getDataAsString();
        Object res = this.doScript(engineName, script);
        rmoArg.getRespons().addData(res);
    }

    protected Object doScript(String engineName, String script) throws Exception {
        BcLogUtil.debug("engineName=" + engineName);
        BcLogUtil.debug("script=" + script);
        ScriptEngineManager scriptEngineManager = new ScriptEngineManager();
        ScriptEngine scriptEngine = scriptEngineManager.getEngineByName(engineName);
        if (scriptEngine == null) {
            throw new Exception("Not supported engine. '" + engineName + "'");
        }
        Invocable invocable = (Invocable)((Object)scriptEngine);
        Object res = scriptEngine.eval(script);
        BcLogUtil.debug("res=" + res);
        return res;
    }
}

