/*
 * Decompiled with CFR 0.152.
 */
package ext.lib.swg;

import java.awt.Dimension;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JViewport;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SwgViewportSynchronizer
implements ChangeListener {
    public boolean verticalEnabled = true;
    public boolean horizontalEnabled = true;
    protected List<JViewport> viewportList = new ArrayList<JViewport>();
    boolean adjflg = false;

    public void clear() {
        for (JViewport viewport : this.viewportList) {
            viewport.removeChangeListener(this);
        }
        this.viewportList.clear();
    }

    public void addViewport(JViewport viewport) {
        this.viewportList.add(viewport);
        viewport.addChangeListener(this);
    }

    @Override
    public void stateChanged(ChangeEvent ev) {
        JViewport source = null;
        ArrayList<JViewport> targetList = new ArrayList<JViewport>();
        for (JViewport viewport : this.viewportList) {
            if (ev.getSource() == viewport) {
                source = viewport;
                continue;
            }
            targetList.add(viewport);
        }
        if (this.adjflg || source == null || targetList.size() == 0) {
            return;
        }
        this.adjflg = true;
        Dimension dim1 = source.getViewSize();
        Dimension siz1 = source.getSize();
        Point pnt1 = source.getViewPosition();
        for (JViewport viewport : targetList) {
            Dimension dim2 = viewport.getViewSize();
            Dimension siz2 = viewport.getSize();
            Point pnt2 = viewport.getViewPosition();
            if (this.verticalEnabled) {
                double ny = pnt1.getY() / (dim1.getHeight() - siz1.getHeight()) * (dim2.getHeight() - siz2.getHeight());
                pnt2.y = (int)ny;
            }
            if (this.horizontalEnabled) {
                double nx = pnt1.getX() / (dim1.getWidth() - siz1.getWidth()) * (dim2.getWidth() - siz2.getWidth());
                pnt2.x = (int)nx;
            }
            viewport.setViewPosition(pnt2);
        }
        this.adjflg = false;
    }
}

