/*
 * Decompiled with CFR 0.152.
 */
package ext.lib.sql.xa;

import ext.lib.sql.SqlConnection;
import ext.lib.sql.context.SqlContext;
import java.util.ArrayList;
import java.util.List;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class SqlXAResource
implements XAResource {
    protected List<SqlConnection> connectionList = new ArrayList<SqlConnection>();

    public void addConnection(SqlConnection sqlConn) throws XAException {
        this.connectionList.add(sqlConn);
    }

    public boolean removeConnection(SqlConnection sqlConn) throws XAException {
        return this.connectionList.remove(sqlConn);
    }

    @Override
    public void commit(Xid xid, boolean onePhase) throws XAException {
        int i = 0;
        while (i < this.connectionList.size()) {
            SqlConnection sqlConn = this.connectionList.get(i);
            SqlContext sqlContext = sqlConn.getSqlContext();
            try {
                if (onePhase) {
                    sqlConn.commit();
                } else {
                    sqlContext.commitPrepared(sqlConn, new String(xid.getGlobalTransactionId()));
                }
            }
            catch (Exception ex) {
                throw new XAException(ex.getMessage());
            }
            ++i;
        }
    }

    @Override
    public void end(Xid arg0, int arg1) throws XAException {
    }

    @Override
    public void forget(Xid arg0) throws XAException {
    }

    @Override
    public int getTransactionTimeout() throws XAException {
        return -1;
    }

    @Override
    public boolean isSameRM(XAResource arg0) throws XAException {
        return false;
    }

    @Override
    public int prepare(Xid xid) throws XAException {
        int i = 0;
        while (i < this.connectionList.size()) {
            SqlConnection sqlConn = this.connectionList.get(i);
            SqlContext sqlContext = sqlConn.getSqlContext();
            try {
                sqlContext.prepareTransaction(sqlConn, new String(xid.getGlobalTransactionId()));
            }
            catch (Exception ex) {
                throw new XAException(ex.getMessage());
            }
            ++i;
        }
        return 0;
    }

    @Override
    public Xid[] recover(int arg0) throws XAException {
        return null;
    }

    @Override
    public void rollback(Xid xid) throws XAException {
        int i = 0;
        while (i < this.connectionList.size()) {
            SqlConnection sqlConn = this.connectionList.get(i);
            SqlContext sqlContext = sqlConn.getSqlContext();
            try {
                sqlContext.rollbackPrepared(sqlConn, new String(xid.getGlobalTransactionId()));
            }
            catch (Exception ex) {
                throw new XAException(ex.getMessage());
            }
            ++i;
        }
    }

    @Override
    public boolean setTransactionTimeout(int arg0) throws XAException {
        return false;
    }

    @Override
    public void start(Xid arg0, int arg1) throws XAException {
    }
}

