/*
 * Decompiled with CFR 0.152.
 */
package ext.lib.print;

import ext.base.core.BcConstants;
import ext.base.core.BcNumberUtil;
import ext.base.core.BcStringUtil;
import ext.base.log.BcLogUtil;
import ext.base.xml.BcXmlUtil;
import ext.lib.print.DcfPrintCondition;
import ext.lib.print.DcfPrintConditionElement;
import java.awt.print.PrinterJob;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.print.DocFlavor;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.attribute.Attribute;
import javax.print.attribute.HashPrintServiceAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.PrinterName;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class DcfPrintUtil {
    public static final String TAG_printCondition = "printCondition";
    public static final String TAG_job = "job";
    public static final String ATRR_name = "name";
    public static final String ATRR_x = "x";
    public static final String ATRR_y = "y";

    public static List<String> getPrintServiceNameList() throws Exception {
        ArrayList<String> printServiceNameList = new ArrayList<String>();
        PrintService[] printServices = PrinterJob.lookupPrintServices();
        int i = 0;
        while (i < printServices.length) {
            printServiceNameList.add(printServices[i].getName());
            ++i;
        }
        return printServiceNameList;
    }

    public static PrintService lookupPrintService(String printServiceName) throws Exception {
        DocFlavor.SERVICE_FORMATTED flavor = DocFlavor.SERVICE_FORMATTED.PRINTABLE;
        HashPrintServiceAttributeSet printAttrSet = new HashPrintServiceAttributeSet();
        printAttrSet.add(new PrinterName(printServiceName, Locale.getDefault()));
        PrintService[] printServices = PrintServiceLookup.lookupPrintServices(flavor, printAttrSet);
        if (printServices.length > 0) {
            return printServices[0];
        }
        return null;
    }

    public static PrintService lookupPrintService_bak(String printServiceName) throws Exception {
        PrintService[] printServices = PrinterJob.lookupPrintServices();
        int i = 0;
        while (i < printServices.length) {
            if (BcStringUtil.equals(printServiceName, printServices[i].getName())) {
                return printServices[i];
            }
            ++i;
        }
        return null;
    }

    public static PrintService getDefaultPrintService() throws Exception {
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        if (printerJob != null) {
            return printerJob.getPrintService();
        }
        return null;
    }

    public static String getDefaultPrintServiceName() throws Exception {
        PrintService printService = DcfPrintUtil.getDefaultPrintService();
        if (printService != null) {
            return printService.getName();
        }
        return null;
    }

    public static String toPrintEventMessage(int \uff50rintEventType) {
        String msg = null;
        switch (\uff50rintEventType) {
            case 106: {
                msg = "\u30b8\u30e7\u30d6\u304c\u5fc5\u305a\u3057\u3082\u307e\u3060\u5370\u5237\u3055\u308c\u3066\u3044\u306a\u304f\u3066\u3082\u3001\u30c7\u30fc\u30bf\u306f\u30af\u30e9\u30a4\u30a2\u30f3\u30c8\u304b\u3089\u5370\u5237\u30b5\u30fc\u30d3\u30b9\u306b\u6b63\u5e38\u306b\u8ee2\u9001\u3055\u308c\u3066\u3044\u307e\u3059\u3002\u30af\u30e9\u30a4\u30a2\u30f3\u30c8\u306f\u30c7\u30fc\u30bf\u30ea\u30bd\u30fc\u30b9\u3092\u89e3\u653e\u3067\u304d\u307e\u3059\u3002";
                break;
            }
            case 101: {
                msg = "\u30b8\u30e7\u30d6\u306f PrintService \u306b\u3088\u3063\u3066\u53d6\u308a\u6d88\u3055\u308c\u307e\u3057\u305f\u3002";
                break;
            }
            case 102: {
                msg = "\u30c9\u30ad\u30e5\u30e1\u30f3\u30c8\u306f\u5b8c\u5168\u306b\u5370\u5237\u3055\u308c\u307e\u3057\u305f\u3002";
                break;
            }
            case 103: {
                msg = "\u5370\u5237\u30b5\u30fc\u30d3\u30b9\u304c\u30b8\u30e7\u30d6\u3092\u5b8c\u4e86\u3067\u304d\u306a\u3044\u3053\u3068\u3092\u5831\u544a\u3057\u307e\u3059\u3002\u30a2\u30d7\u30ea\u30b1\u30fc\u30b7\u30e7\u30f3\u306f\u30b8\u30e7\u30d6\u3092\u518d\u9001\u4fe1\u3059\u308b\u5fc5\u8981\u304c\u3042\u308a\u307e\u3059\u3002";
                break;
            }
            case 105: {
                msg = "\u3059\u3079\u3066\u306e\u5370\u5237\u30b5\u30fc\u30d3\u30b9\u3001\u305f\u3068\u3048\u3070\u30b8\u30e7\u30d6\u306e\u5b8c\u4e86\u3092\u901a\u77e5\u3059\u308b\u3088\u3046\u306a\u91cd\u8981\u306a\u30a4\u30d9\u30f3\u30c8\u3067\u3055\u3048\u3001\u9001\u4fe1\u3067\u304d\u308b\u308f\u3051\u3067\u306f\u3042\u308a\u307e\u305b\u3093\u3002\u3053\u306e\u30e1\u30c3\u30bb\u30fc\u30b8\u306f\u3001\u5370\u5237\u30b8\u30e7\u30d6\u304c\u3053\u308c\u4ee5\u4e0a\u306e\u60c5\u5831\u3092\u3082\u3063\u3066\u3044\u306a\u3044\u3053\u3068\u3001\u307e\u305f\u306f\u5370\u5237\u30b5\u30fc\u30d3\u30b9\u3068\u3053\u308c\u4ee5\u4e0a\u901a\u4fe1\u3057\u306a\u3044\u3053\u3068\u3092\u793a\u3057\u307e\u3059\u3002\u3053\u306e\u30e1\u30c3\u30bb\u30fc\u30b8\u306f\u7aef\u672b\u30a4\u30d9\u30f3\u30c8 (\u5b8c\u4e86/\u5931\u6557/\u53d6\u308a\u6d88\u3057) \u304c\u9001\u4fe1\u3055\u308c\u306a\u3044\u5834\u5408\u306b\u306f\u5e38\u306b\u9001\u4fe1\u3055\u308c\u306a\u3051\u308c\u3070\u306a\u308a\u307e\u305b\u3093\u3002\u305f\u3068\u3048\u3070\u3001\u3053\u306e\u30e1\u30c3\u30bb\u30fc\u30b8\u3092\u53d7\u3051\u53d6\u308b\u524d\u306b\u3001JOB_COMPLETE \u306a\u3069\u306e\u30e1\u30c3\u30bb\u30fc\u30b8\u304c\u53d7\u3051\u53d6\u3089\u308c\u306a\u304b\u3063\u305f\u5834\u5408\u3001\u63a8\u6e2c\u3055\u308c\u308b\u3053\u3068\u306f\u5370\u5237\u30b5\u30fc\u30d3\u30b9\u304c\u3053\u306e\u3088\u3046\u306a\u30a4\u30d9\u30f3\u30c8\u306e\u9001\u4fe1\u3092\u30b5\u30dd\u30fc\u30c8\u3057\u3066\u3044\u306a\u3044\u3053\u3068\u3060\u3051\u3067\u3059\u3002";
                break;
            }
            case 104: {
                msg = "\u5370\u5237\u30b5\u30fc\u30d3\u30b9\u304c\u3001\u5370\u5237\u30b5\u30fc\u30d3\u30b9\u3092\u7d9a\u3051\u308b\u524d\u306b\u5916\u90e8\u304b\u3089\u306e\u64cd\u4f5c\u304c\u5fc5\u8981\u306a\u3001\u304a\u305d\u3089\u304f\u4e00\u6642\u7684\u306a\u554f\u984c\u304c\u767a\u751f\u3057\u305f\u3053\u3068\u3092\u793a\u3057\u307e\u3059\u3002\u3053\u306e\u30e1\u30c3\u30bb\u30fc\u30b8\u3092\u751f\u6210\u3067\u304d\u308b\u30a4\u30d9\u30f3\u30c8\u306e 1 \u3064\u306e\u4f8b\u306b\u3001\u30d7\u30ea\u30f3\u30bf\u306e\u7528\u7d19\u5207\u308c\u304c\u3042\u308a\u307e\u3059\u3002";
            }
        }
        return msg;
    }

    public static void printRequestAttributeSetLog(PrintRequestAttributeSet printRequestAttributeSet) throws Exception {
        Attribute[] attributes = printRequestAttributeSet.toArray();
        BcLogUtil.debug("attributes.length=" + attributes.length);
        int i = 0;
        while (i < attributes.length) {
            Attribute attribute = attributes[i];
            BcLogUtil.debug("attribute=" + attribute);
            ++i;
        }
    }

    public static Document createXml(DcfPrintCondition printCondition) throws Exception {
        Document dom = BcXmlUtil.createDocument(TAG_printCondition, true);
        Element rootElem = dom.getDocumentElement();
        BcLogUtil.debug("createXml:marginMap.size()=" + printCondition.conditionElemetList.size());
        int i = 0;
        while (i < printCondition.conditionElemetList.size()) {
            DcfPrintConditionElement printConditionElement = printCondition.conditionElemetList.get(i);
            Element element = BcXmlUtil.createElement(rootElem, TAG_job);
            element.setAttribute(ATRR_name, printConditionElement.name);
            element.setAttribute(ATRR_x, String.valueOf(printConditionElement.marginPoint2D.x));
            element.setAttribute(ATRR_y, String.valueOf(printConditionElement.marginPoint2D.y));
            ++i;
        }
        return dom;
    }

    public static void parseXml(Document dom, DcfPrintCondition printCondition) throws Exception {
        BcLogUtil.debug(BcXmlUtil.toString(dom, BcConstants.charset.name(), true));
        printCondition.conditionElemetList.clear();
        List<Node> domNodeList = BcXmlUtil.getNodeList((Node)dom, (short)1);
        int i = 0;
        while (i < domNodeList.size()) {
            Node node = domNodeList.get(i);
            if (node.getNodeName().equals(TAG_job)) {
                String jobName = BcXmlUtil.getAttribute(node, ATRR_name);
                BcLogUtil.debug("jobName=" + jobName);
                DcfPrintConditionElement printConditionElement = new DcfPrintConditionElement();
                printConditionElement.name = jobName;
                printConditionElement.marginPoint2D.x = BcNumberUtil.parseDouble(BcXmlUtil.getAttribute(node, ATRR_x));
                printConditionElement.marginPoint2D.y = BcNumberUtil.parseDouble(BcXmlUtil.getAttribute(node, ATRR_y));
                printCondition.conditionElemetList.add(printConditionElement);
            }
            ++i;
        }
    }
}

