/*
 * Decompiled with CFR 0.152.
 */
package ext.lib.pdf.object;

import ext.base.core.BcStringUtil;
import ext.base.core.BcTimeUtil;
import ext.lib.pdf.PdfUtil;
import ext.lib.pdf.object.PdfObject;
import java.io.Serializable;
import java.util.Calendar;

public class PdfInformation
extends PdfObject
implements Serializable {
    private static final long serialVersionUID = -193650492925535542L;
    protected String author;
    protected String creator;
    protected String producer = "Ex-PDF Producer Ver 1.0 beta";
    protected String title;
    protected String subject;

    @Override
    public byte[] getObjectDetail() {
        StringBuilder sb = new StringBuilder();
        sb.append("<<\r\n");
        if (!BcStringUtil.isEmpty(this.getCreationDate())) {
            sb.append("/CreationDate (D:" + this.getCreationDate() + ")\r\n");
        }
        if (!BcStringUtil.isEmpty(this.getCreator())) {
            sb.append("/Creator <" + PdfUtil.toUnicodeName(this.getCreator()) + ">\r\n");
        }
        if (!BcStringUtil.isEmpty(this.getProducer())) {
            sb.append("/Producer <" + PdfUtil.toUnicodeName(this.getProducer()) + ">\r\n");
        }
        if (!BcStringUtil.isEmpty(this.getAuthor())) {
            sb.append("/Author <" + PdfUtil.toUnicodeName(this.getAuthor()) + ">\r\n");
        }
        if (!BcStringUtil.isEmpty(this.getTitle())) {
            sb.append("/Title <" + PdfUtil.toUnicodeName(this.getTitle()) + ">\r\n");
        }
        if (!BcStringUtil.isEmpty(this.getSubject())) {
            sb.append("/Subject <" + PdfUtil.toUnicodeName(this.getSubject()) + ">\r\n");
        }
        sb.append(">>\r\n");
        return sb.toString().getBytes();
    }

    public String getCreationDate() {
        Calendar calender = BcTimeUtil.createCalendar();
        return BcTimeUtil.toString(calender, "yyyyMMddhhmmss");
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public String getCreator() {
        return this.creator;
    }

    public void setProducer(String producer) {
        this.producer = producer;
    }

    public String getProducer() {
        return this.producer;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getSubject() {
        return this.subject;
    }
}

