/*
 * Decompiled with CFR 0.152.
 */
package ext.lib.nlp;

import ext.base.core.BcConstants;
import ext.base.table.BcTableModel;
import ext.base.util.BcCsvUtil;
import ext.lib.nlp.ExtNameFinderImpl0;
import ext.lib.nlp.KrmjTokenWrap;
import ext.lib.nlp.KuromojiUtil;
import ext.lib.nlp.NlpNoun;
import ext.lib.nlp.NlpTempUtil;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ExtNameFinderImpl1
extends ExtNameFinderImpl0 {
    protected Map<String, NlpNoun> nounMap;

    @Override
    public void setup() throws Exception {
        InputStream is = NlpTempUtil.getPersonNameInputStream(NlpTempUtil.personNameDat);
        InputStreamReader inputStreamReader = new InputStreamReader(is, BcConstants.charset);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        BcTableModel tableModel = BcCsvUtil.csvToTable(inputStreamReader, -1);
        this.nounMap = new LinkedHashMap<String, NlpNoun>();
        int i = 0;
        while (i < tableModel.getRowCount()) {
            NlpNoun noun = new NlpNoun();
            noun.key = (String)tableModel.getValueAt(i, 0);
            noun.name = (String)tableModel.getValueAt(i, 1);
            noun.reading = (String)tableModel.getValueAt(i, 2);
            noun.score = 2;
            this.nounMap.put(noun.key, noun);
            ++i;
        }
        this.getLogger().debug("nounMap.size()=" + this.nounMap.size());
    }

    @Override
    protected NlpNoun getNoun(List<KrmjTokenWrap> tokenWrapList) throws Exception {
        String key = KuromojiUtil.toString2(tokenWrapList);
        NlpNoun noun = this.nounMap.get(key);
        return noun;
    }
}

