/*
 * Decompiled with CFR 0.152.
 */
package ext.lib.activation;

import ext.base.core.BcStringUtil;
import ext.base.io.BcFileUtil;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;

public final class BcMimeUtil {
    private BcMimeUtil() {
    }

    public static String getMimeType(String fileName) throws Exception {
        String extention = BcFileUtil.getExtention(fileName);
        String mimeType = null;
        if ("xml".equalsIgnoreCase(extention)) {
            mimeType = MimeType.application_xml.type;
        } else if ("js".equalsIgnoreCase(extention)) {
            mimeType = MimeType.application_javascript.type;
        } else {
            Path path = Paths.get(fileName, new String[0]);
            mimeType = Files.probeContentType(path);
        }
        if (BcStringUtil.isEmpty(mimeType)) {
            mimeType = MimeType.application_octet_stream.type;
        }
        return mimeType;
    }

    public static String getMimeType(File file) throws Exception {
        return BcMimeUtil.getMimeType(file.getName());
    }

    public static boolean isImageMime(String mimeType) throws Exception {
        return mimeType.toLowerCase().startsWith("image");
    }

    public static boolean isImageFile(String fileName) throws Exception {
        String mimeType = BcMimeUtil.getMimeType(fileName);
        if (mimeType == null) {
            return false;
        }
        return BcMimeUtil.isImageMime(mimeType);
    }

    public static enum MimeType {
        application_javascript("text/javascript"),
        application_json("application/json"),
        application_octet_stream("application/octet-stream"),
        application_xml("application/xml; charset=utf-8");

        public final String type;

        private MimeType(String type) {
            this.type = type;
        }
    }
}

