/*
 * Decompiled with CFR 0.152.
 */
package ext.base.xml;

import ext.base.core.BcStringUtil;
import ext.base.io.BcFileUtil;
import ext.base.util.BcObjectConvertor;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;

public final class BcXmlUtil {
    public static final String EXTENTION_xml = "xml";
    public static final String EXTENTION_dot_xml = String.valueOf(BcStringUtil.DOT_STR) + "xml";

    private BcXmlUtil() {
    }

    public static Document createDocument(String rootTagName, boolean isStandalone) throws Exception {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.newDocument();
        document.setXmlStandalone(isStandalone);
        Element rootElem = document.createElement(rootTagName);
        document.appendChild(rootElem);
        return document;
    }

    public static Document createDocument(InputSource inputSource) throws Exception {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(inputSource);
        return document;
    }

    public static Document createDocument(InputStream is) throws Exception {
        InputSource inputSource = new InputSource(is);
        return BcXmlUtil.createDocument(inputSource);
    }

    public static Document createDocument(String xmlText, String encoding) throws Exception {
        byte[] bytes = null;
        bytes = BcStringUtil.isEmpty(encoding) ? xmlText.getBytes() : xmlText.getBytes(encoding);
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        return BcXmlUtil.createDocument(bais);
    }

    public static Document createDocument(File file) throws Exception {
        return BcXmlUtil.createDocument(new FileInputStream(file));
    }

    public static Document getOwnerDocument(Node node) {
        Document document = node.getOwnerDocument();
        if (document == null && node.getNodeType() == 9) {
            document = (Document)node;
        }
        return document;
    }

    public static List<Node> getNodeList(Node baseNode, String path) {
        ArrayList<Node> nodeList = new ArrayList<Node>();
        Node tmpNode = BcXmlUtil.getNode(baseNode, path);
        if (tmpNode == null) {
            return nodeList;
        }
        Node baseNode2 = tmpNode.getParentNode();
        if (baseNode2.getNodeType() == 9) {
            baseNode2 = BcXmlUtil.getOwnerDocument(baseNode2).getDocumentElement();
        }
        int i = 0;
        while (i < baseNode2.getChildNodes().getLength()) {
            Node node = baseNode2.getChildNodes().item(i);
            if (node.getNodeName().equals(tmpNode.getNodeName())) {
                nodeList.add(node);
            }
            ++i;
        }
        return nodeList;
    }

    public static List<Node> getNodeList(Node baseNode, short nodeType) {
        if (baseNode.getNodeType() == 9) {
            baseNode = BcXmlUtil.getOwnerDocument(baseNode).getDocumentElement();
        }
        ArrayList<Node> nodeList = new ArrayList<Node>();
        int i = 0;
        while (i < baseNode.getChildNodes().getLength()) {
            Node node = baseNode.getChildNodes().item(i);
            if (node.getNodeType() == nodeType) {
                nodeList.add(node);
            }
            ++i;
        }
        return nodeList;
    }

    public static Node getFirstNode(Node baseNode, String tagName) {
        if (baseNode.getNodeType() == 9) {
            baseNode = BcXmlUtil.getOwnerDocument(baseNode).getDocumentElement();
        }
        NodeList nodeList = baseNode.getChildNodes();
        int i = 0;
        while (i < nodeList.getLength()) {
            Node node = nodeList.item(i);
            if (node.getNodeName().equals(tagName)) {
                return node;
            }
            ++i;
        }
        return null;
    }

    public static Node getFirstNode(Node baseNode, short nodeType) {
        if (baseNode.getNodeType() == 9) {
            baseNode = BcXmlUtil.getOwnerDocument(baseNode).getDocumentElement();
        }
        int i = 0;
        while (i < baseNode.getChildNodes().getLength()) {
            Node node = baseNode.getChildNodes().item(i);
            if (node.getNodeType() == nodeType) {
                return node;
            }
            ++i;
        }
        return null;
    }

    public static Node getNode(Node baseNode, String path, boolean doseCreate) {
        if (BcStringUtil.isEmpty(path)) {
            return baseNode;
        }
        Node node = null;
        int sepPos = path.indexOf("/");
        if (sepPos >= 0) {
            String tagName = path.substring(0, sepPos);
            Node node2 = BcXmlUtil.getFirstNode(baseNode, tagName);
            if (node2 != null) {
                node = BcXmlUtil.getNode(node2, path.substring(sepPos + 1), doseCreate);
            } else if (doseCreate) {
                node2 = baseNode.getOwnerDocument().createElement(tagName);
                baseNode.appendChild(node2);
                node = BcXmlUtil.getNode(node2, path.substring(sepPos + 1), doseCreate);
            }
        } else {
            String tagName = path;
            node = BcXmlUtil.getFirstNode(baseNode, tagName);
            if (node == null && doseCreate) {
                node = baseNode.getOwnerDocument().createElement(tagName);
                baseNode.appendChild(node);
            }
        }
        return node;
    }

    public static Node getNode(Node baseNode, String path) {
        return BcXmlUtil.getNode(baseNode, path, false);
    }

    public static Element createElement(Node baseNode, String path) {
        Element element = null;
        int sepPos = path.indexOf("/");
        if (sepPos >= 0) {
            String tagName = path.substring(0, sepPos);
            Node node2 = BcXmlUtil.getFirstNode(baseNode, tagName);
            if (node2 == null) {
                node2 = baseNode.getOwnerDocument().createElement(tagName);
                baseNode.appendChild(node2);
            }
            element = BcXmlUtil.createElement(node2, path.substring(sepPos + 1));
        } else {
            String tagName = path;
            element = baseNode.getOwnerDocument().createElement(tagName);
            baseNode.appendChild(element);
        }
        return element;
    }

    public static void deleteChild(Node baseNode, String tagName) {
        if (baseNode.getNodeType() == 9) {
            baseNode = BcXmlUtil.getOwnerDocument(baseNode).getDocumentElement();
        }
        NodeList nodeList = baseNode.getChildNodes();
        int i = 0;
        while (i < nodeList.getLength()) {
            Node node = nodeList.item(i);
            if (node.getNodeName().equals(tagName)) {
                baseNode.removeChild(node);
            }
            ++i;
        }
    }

    public static void deleteChild(Node baseNode, short nodeType) {
        if (baseNode.getNodeType() == 9) {
            baseNode = BcXmlUtil.getOwnerDocument(baseNode).getDocumentElement();
        }
        NodeList nodeList = baseNode.getChildNodes();
        int i = 0;
        while (i < nodeList.getLength()) {
            Node node = nodeList.item(i);
            if (node.getNodeType() == nodeType) {
                baseNode.removeChild(node);
            }
            ++i;
        }
    }

    public static void deleteAllChild(Node baseNode) {
        if (baseNode.getNodeType() == 9) {
            baseNode = BcXmlUtil.getOwnerDocument(baseNode).getDocumentElement();
        }
        NodeList nodeList = baseNode.getChildNodes();
        int i = 0;
        while (i < nodeList.getLength()) {
            Node node = nodeList.item(i);
            baseNode.removeChild(node);
            ++i;
        }
    }

    public static void deleteNode(List<Node> nodeList) {
        int i = 0;
        while (i < nodeList.size()) {
            Node node = nodeList.get(i);
            Node parentNode = node.getParentNode();
            if (parentNode != null) {
                parentNode.removeChild(node);
            }
            ++i;
        }
    }

    public static Node setTextValue(Node node, Object value) throws Exception {
        BcXmlUtil.deleteChild(node, (short)3);
        Text newNode = null;
        if (value != null) {
            String valueStr = (String)BcObjectConvertor.getInstance().convert(value, String.class);
            newNode = node.getOwnerDocument().createTextNode(valueStr);
        } else {
            newNode = node.getOwnerDocument().createTextNode("");
        }
        node.appendChild(newNode);
        return newNode;
    }

    public static Node setTextValue(Node baseNode, String path, Object value) throws Exception {
        Node node = BcXmlUtil.getNode(baseNode, path, true);
        String valueStr = (String)BcObjectConvertor.getInstance().convert(value, String.class);
        return BcXmlUtil.setTextValue(node, valueStr);
    }

    public static Node addTextValue(Node baseNode, String path, Object value) throws Exception {
        Element newNode = BcXmlUtil.createElement(baseNode, path);
        BcXmlUtil.setTextValue(newNode, value);
        return newNode;
    }

    public static String getAttribute(Node node, String itemName, String defaultValue) throws Exception {
        String resStr = null;
        Attr attr = (Attr)node.getAttributes().getNamedItem(itemName);
        if (attr != null) {
            resStr = attr.getNodeValue();
        }
        if (resStr != null) {
            return resStr;
        }
        return defaultValue;
    }

    public static String getAttribute(Node node, String itemName) throws Exception {
        return BcXmlUtil.getAttribute(node, itemName, null);
    }

    public static String getValue(Node node, int nodeType, String defaultValue) {
        String resStr = null;
        NodeList nodeList = node.getChildNodes();
        int i = 0;
        while (i < nodeList.getLength()) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() == nodeType) {
                resStr = node2.getNodeValue();
                break;
            }
            ++i;
        }
        if (resStr != null) {
            return resStr;
        }
        return defaultValue;
    }

    public static String getValue(Node node, int nodeType) {
        return BcXmlUtil.getValue(node, nodeType, null);
    }

    public static String getValue(Node baseNode, String path, int nodeType, String defaultValue) {
        Node node = BcXmlUtil.getNode(baseNode, path, false);
        if (node != null) {
            return BcXmlUtil.getValue(node, nodeType, defaultValue);
        }
        return defaultValue;
    }

    public static String getTextValue(Node node, String path, String defaultValue) {
        return BcXmlUtil.getValue(node, path, 3, defaultValue);
    }

    public static String getTextValue(Node node, String path) {
        return BcXmlUtil.getValue(node, path, 3, null);
    }

    public static String getTextValue(Node node) {
        return BcXmlUtil.getValue(node, null, 3, null);
    }

    public static byte[] toByteArray(Document document, String encodingChar, boolean indenting) throws Exception {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        BcXmlUtil.output(document, os, indenting, encodingChar);
        return os.toByteArray();
    }

    public static String toString(Document document, String encodingChar, boolean indenting) throws Exception {
        byte[] byteArray = BcXmlUtil.toByteArray(document, encodingChar, indenting);
        return new String(byteArray, encodingChar);
    }

    public static Document toDocument(String xmlText, String encodingChar) throws Exception {
        ByteArrayInputStream is = new ByteArrayInputStream(xmlText.getBytes(encodingChar));
        Document document = BcXmlUtil.createDocument(is);
        return document;
    }

    public static Document toDocument(String xmlText) throws Exception {
        ByteArrayInputStream is = new ByteArrayInputStream(xmlText.getBytes());
        Document document = BcXmlUtil.createDocument(is);
        return document;
    }

    public static void output(Document document, OutputStream os, boolean indenting, String encoding) throws Exception {
        DOMSource source = new DOMSource(document);
        StreamResult streamResult = new StreamResult(os);
        TransformerFactory transFactory = TransformerFactory.newInstance();
        Transformer transformer = transFactory.newTransformer();
        transformer.setOutputProperty("method", EXTENTION_xml);
        if (indenting) {
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xalan}indent-amount", "2");
        }
        if (!BcStringUtil.isEmpty(encoding)) {
            transformer.setOutputProperty("encoding", encoding);
        }
        transformer.transform(source, streamResult);
    }

    public static void output(Document document, OutputStream os, boolean indenting) throws Exception {
        BcXmlUtil.output(document, os, indenting, null);
    }

    public static void output(Document document, File file, boolean indenting, String encoding) throws Exception {
        BcFileUtil.makeParent(file);
        try (FileOutputStream os = new FileOutputStream(file, true);){
            BcXmlUtil.output(document, os, indenting, encoding);
        }
    }

    public static void output(Document document, File file, boolean indenting) throws Exception {
        BcXmlUtil.output(document, file, indenting, null);
    }
}

