/*
 * Decompiled with CFR 0.152.
 */
package com.nilo.plaf.nimrod;

import com.nilo.plaf.nimrod.NimRODDesktopIconUI;
import com.nilo.plaf.nimrod.NimRODLookAndFeel;
import com.nilo.plaf.nimrod.NimRODUtils;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JInternalFrame;
import javax.swing.UIManager;
import javax.swing.event.MouseInputAdapter;
import javax.swing.plaf.basic.BasicInternalFrameTitlePane;
import javax.swing.plaf.metal.MetalInternalFrameTitlePane;

public class NimRODInternalFrameTitlePane
extends MetalInternalFrameTitlePane {
    private static final long serialVersionUID = 3569530640592496710L;
    private MiML miml;
    private Icon resizeIcon;
    private Icon antIcon;
    private int litWidth = UIManager.getInt("NimRODInternalFrameIconLit.width");
    private int litHeight = UIManager.getInt("NimRODInternalFrameIconLit.height");

    public NimRODInternalFrameTitlePane(JInternalFrame arg0) {
        super(arg0);
        this.closeButton.setOpaque(false);
        this.closeButton.setBorderPainted(false);
        this.closeButton.setFocusPainted(false);
        this.maxButton.setOpaque(false);
        this.maxButton.setBorderPainted(false);
        this.maxButton.setFocusPainted(false);
        this.iconButton.setOpaque(false);
        this.iconButton.setBorderPainted(false);
        this.iconButton.setFocusPainted(false);
        HackML hackML = new HackML();
        this.closeButton.addMouseListener(hackML);
        this.maxButton.addMouseListener(hackML);
        this.iconButton.addMouseListener(hackML);
    }

    @Override
    public void installListeners() {
        super.installListeners();
        this.miml = new MiML();
        this.addMouseListener(this.miml);
        this.addMouseMotionListener(this.miml);
        this.frame.addMouseListener(this.miml);
        this.frame.addMouseMotionListener(this.miml);
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        this.removeMouseListener(this.miml);
        this.removeMouseMotionListener(this.miml);
        this.frame.removeMouseListener(this.miml);
        this.frame.removeMouseMotionListener(this.miml);
        this.miml = null;
    }

    @Override
    protected PropertyChangeListener createPropertyChangeListener() {
        return new NimRODPropertyChangeHandler();
    }

    @Override
    public void paintComponent(Graphics g) {
        String title;
        int xOffset;
        int width = this.getWidth();
        int height = this.getHeight();
        Graphics2D g2D = (Graphics2D)g.create();
        g2D.setComposite(AlphaComposite.getInstance(3, NimRODUtils.getFrameOpacityFloat()));
        GradientPaint grad = this.frame.isSelected() ? new GradientPaint(0.0f, 0.0f, NimRODLookAndFeel.getPrimaryControlDarkShadow(), width, 0.0f, NimRODLookAndFeel.getPrimaryControl()) : new GradientPaint(0.0f, 0.0f, NimRODLookAndFeel.getControl(), width, 0.0f, NimRODLookAndFeel.getControlDarkShadow());
        g2D.setPaint(grad);
        g2D.fillRect(0, 1, width, height);
        g2D.dispose();
        int n = xOffset = this.frame.getComponentOrientation().isLeftToRight() ? 5 : width - 5;
        if (this.frame.getFrameIcon() != this.antIcon) {
            int alto = this.litHeight > height ? height - 2 : this.litHeight;
            int ancho = this.litHeight > height ? alto : this.litWidth;
            this.antIcon = this.frame.getFrameIcon();
            this.resizeIcon = NimRODUtils.reescala(this.antIcon, alto, ancho);
        }
        if (this.resizeIcon != null) {
            int iconY = height / 2 - this.resizeIcon.getIconHeight() / 2;
            this.resizeIcon.paintIcon(this.frame, g, xOffset, iconY);
            xOffset += 5 + this.resizeIcon.getIconWidth();
        }
        if ((title = this.frame.getTitle()) != null) {
            Font f = this.getFont();
            g.setFont(f);
            FontMetrics fm = this.getFontMetrics(f);
            int yOffset = (height - fm.getHeight()) / 2 + fm.getAscent();
            int len = width;
            if (this.frame.isIconifiable()) {
                len = this.iconButton.getBounds().x;
            } else if (this.frame.isMaximizable()) {
                len = this.maxButton.getBounds().x;
            } else if (this.frame.isClosable()) {
                len = this.closeButton.getBounds().x;
            }
            len = len - xOffset - this.getInsets().left;
            title = this.getTitle(title, fm, len);
            if (this.frame.isSelected()) {
                NimRODUtils.paintShadowTitleFat(g, title, xOffset, yOffset, Color.white);
            } else {
                NimRODUtils.paintShadowTitleFat(g, title, xOffset, yOffset, NimRODLookAndFeel.getControl());
            }
        }
    }

    private class HackML
    extends MouseInputAdapter {
        private HackML() {
        }

        @Override
        public void mouseReleased(MouseEvent ev) {
            if (NimRODInternalFrameTitlePane.this.frame.getDesktopPane() != null) {
                NimRODInternalFrameTitlePane.this.frame.getDesktopPane().updateUI();
            }
        }

        @Override
        public void mouseExited(MouseEvent ev) {
            if (NimRODInternalFrameTitlePane.this.frame.getDesktopPane() != null) {
                NimRODInternalFrameTitlePane.this.frame.getDesktopPane().updateUI();
            }
        }

        @Override
        public void mouseEntered(MouseEvent ev) {
            if (NimRODInternalFrameTitlePane.this.frame.getDesktopPane() != null) {
                NimRODInternalFrameTitlePane.this.frame.getDesktopPane().updateUI();
            }
        }
    }

    private class MiML
    extends MouseInputAdapter {
        Insets ins;

        private MiML() {
            this.ins = NimRODInternalFrameTitlePane.this.frame.getBorder().getBorderInsets(NimRODInternalFrameTitlePane.this.frame);
        }

        @Override
        public void mouseDragged(MouseEvent ev) {
            this.dodo(ev);
        }

        @Override
        public void mousePressed(MouseEvent ev) {
            this.dodo(ev);
        }

        @Override
        public void mouseReleased(MouseEvent ev) {
            this.dodo(ev);
        }

        void dodo(MouseEvent ev) {
            if (ev.getComponent() instanceof NimRODInternalFrameTitlePane) {
                if (NimRODInternalFrameTitlePane.this.frame.getDesktopPane() != null) {
                    NimRODInternalFrameTitlePane.this.frame.getDesktopPane().updateUI();
                }
            } else {
                int x = ev.getX();
                int w = NimRODInternalFrameTitlePane.this.frame.getWidth();
                int y = ev.getY();
                int h = NimRODInternalFrameTitlePane.this.frame.getHeight();
                if ((x <= 5 || x >= w - this.ins.right || y >= h - this.ins.bottom) && NimRODInternalFrameTitlePane.this.frame.getDesktopPane() != null) {
                    NimRODInternalFrameTitlePane.this.frame.getDesktopPane().updateUI();
                }
            }
        }
    }

    class NimRODPropertyChangeHandler
    extends BasicInternalFrameTitlePane.PropertyChangeHandler {
        NimRODPropertyChangeHandler() {
            super(NimRODInternalFrameTitlePane.this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String prop = evt.getPropertyName();
            if (prop.equals("selected")) {
                Boolean b = (Boolean)evt.getNewValue();
                NimRODInternalFrameTitlePane.this.iconButton.putClientProperty("paintActive", b);
                NimRODInternalFrameTitlePane.this.closeButton.putClientProperty("paintActive", b);
                NimRODInternalFrameTitlePane.this.maxButton.putClientProperty("paintActive", b);
            } else if ("JInternalFrame.messageType".equals(prop)) {
                NimRODInternalFrameTitlePane.this.frame.repaint();
            } else if ("icon".equals(prop)) {
                NimRODInternalFrameTitlePane.this.iconButton.getModel().setRollover(false);
                NimRODInternalFrameTitlePane.this.closeButton.getModel().setRollover(false);
                NimRODInternalFrameTitlePane.this.maxButton.getModel().setRollover(false);
                ((NimRODDesktopIconUI)((NimRODInternalFrameTitlePane)NimRODInternalFrameTitlePane.this).frame.getDesktopIcon().getUI()).hasFocus = false;
            } else if ("frameIcon".equals(prop) && NimRODInternalFrameTitlePane.this.frame.getDesktopPane() != null) {
                NimRODInternalFrameTitlePane.this.frame.getDesktopPane().updateUI();
            }
            super.propertyChange(evt);
        }
    }
}

