/*
 * Decompiled with CFR 0.152.
 */
package ext.module.wbs1.server;

import ext.base.core.BcStringUtil;
import ext.base.core.BcTimeUtil;
import ext.base.log.BcLogUtil;
import ext.base.util.BcRandamUtil;
import ext.lib.datasource.DtsSession;
import ext.module.wbs1.dao.Wbs1CouponDetailDAO;
import ext.module.wbs1.dao.Wbs1CouponHeaderDAO;
import ext.module.wbs1.model.Wbs1CouponDetail;
import ext.module.wbs1.model.Wbs1CouponHeader;
import java.util.Random;

public class Wbs1CouponServerUtil {
    private Wbs1CouponServerUtil() {
    }

    public static Wbs1CouponServerUtil getInstance() {
        return SingletonHolder.instance;
    }

    public Wbs1CouponDetail createCoupon(DtsSession dtsSession, String code1, long personId) throws Exception {
        Wbs1CouponDetail couponDetail2;
        Wbs1CouponHeader couponHeader = (Wbs1CouponHeader)Wbs1CouponHeaderDAO.getInstance().getByCode1(dtsSession, code1);
        BcLogUtil.debug("couponHeader=" + couponHeader);
        Wbs1CouponDetail couponDetail1 = new Wbs1CouponDetail();
        couponDetail1.code1 = couponHeader.code1;
        Random random = new Random();
        do {
            couponDetail1.code2 = BcRandamUtil.createCode(random, 6, 8);
        } while ((couponDetail2 = (Wbs1CouponDetail)Wbs1CouponDetailDAO.getInstance().getByCode(dtsSession, couponDetail1.code1, couponDetail1.code2)) != null);
        couponDetail1.personId = personId;
        couponDetail1.distributionDateTime = BcTimeUtil.createCalendar();
        Wbs1CouponDetailDAO.getInstance().putEntity(dtsSession, couponDetail1);
        BcLogUtil.debug("couponDetail1.code2=" + couponDetail1.code2);
        return couponDetail1;
    }

    public String[] parseCode(String code) throws Exception {
        String[] elements = new String[]{BcStringUtil.substring(code, 0, 4), BcStringUtil.substring(code, 4, 12)};
        return elements;
    }

    /* synthetic */ Wbs1CouponServerUtil(Wbs1CouponServerUtil wbs1CouponServerUtil) {
        this();
    }

    private static final class SingletonHolder {
        private static final Wbs1CouponServerUtil instance = new Wbs1CouponServerUtil(null);

        private SingletonHolder() {
        }
    }
}

