/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types.optional.image;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import javax.media.jai.InterpolationNearest;
import javax.media.jai.JAI;
import javax.media.jai.PlanarImage;
import org.apache.tools.ant.types.optional.image.DrawOperation;
import org.apache.tools.ant.types.optional.image.ImageOperation;
import org.apache.tools.ant.types.optional.image.TransformOperation;

public class Rotate
extends TransformOperation
implements DrawOperation {
    private static final float HALF_CIRCLE = 180.0f;
    protected float angle = 0.0f;

    public void setAngle(String ang) {
        this.angle = Float.parseFloat(ang);
    }

    public PlanarImage performRotate(PlanarImage image) {
        float tAngle = (float)((double)this.angle * (Math.PI / 180));
        ParameterBlock pb = new ParameterBlock();
        pb.addSource(image);
        pb.add(0.0f);
        pb.add(0.0f);
        pb.add(tAngle);
        pb.add(new InterpolationNearest());
        return JAI.create((String)"Rotate", (ParameterBlock)pb, null);
    }

    @Override
    public PlanarImage executeTransformOperation(PlanarImage image) {
        BufferedImage bi = null;
        int size = this.instructions.size();
        int i = 0;
        while (i < size) {
            ImageOperation instr = (ImageOperation)this.instructions.elementAt(i);
            if (instr instanceof DrawOperation) {
                System.out.println("Execing Draws");
                PlanarImage op = ((DrawOperation)((Object)instr)).executeDrawOperation();
                image = this.performRotate(op);
                return image;
            }
            if (instr instanceof TransformOperation) {
                bi = image.getAsBufferedImage();
                System.out.println("Execing Transforms");
                image = ((TransformOperation)instr).executeTransformOperation(PlanarImage.wrapRenderedImage((RenderedImage)bi));
                bi = image.getAsBufferedImage();
            }
            ++i;
        }
        System.out.println("Execing as TransformOperation");
        image = this.performRotate(image);
        System.out.println(image);
        return image;
    }

    @Override
    public PlanarImage executeDrawOperation() {
        int size = this.instructions.size();
        int i = 0;
        while (i < size) {
            ImageOperation instr = (ImageOperation)this.instructions.elementAt(i);
            if (instr instanceof DrawOperation) {
                PlanarImage op = ((DrawOperation)((Object)instr)).executeDrawOperation();
                op = this.performRotate(op);
                return op;
            }
            ++i;
        }
        return null;
    }
}

