/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath.ri.model.dom;

import org.apache.commons.jxpath.ri.QName;
import org.apache.commons.jxpath.ri.compiler.NodeTest;
import org.apache.commons.jxpath.ri.compiler.NodeTypeTest;
import org.apache.commons.jxpath.ri.model.NodePointer;
import org.apache.commons.jxpath.ri.model.dom.DOMNodePointer;
import org.apache.commons.jxpath.util.TypeUtils;
import org.w3c.dom.Attr;

public class DOMAttributePointer
extends NodePointer {
    private static final long serialVersionUID = 1115085175427555951L;
    private Attr attr;

    public DOMAttributePointer(NodePointer parent, Attr attr) {
        super(parent);
        this.attr = attr;
    }

    @Override
    public QName getName() {
        return new QName(DOMNodePointer.getPrefix(this.attr), DOMNodePointer.getLocalName(this.attr));
    }

    @Override
    public String getNamespaceURI() {
        String prefix = DOMNodePointer.getPrefix(this.attr);
        return prefix == null ? null : this.parent.getNamespaceURI(prefix);
    }

    @Override
    public Object getValue() {
        String value = this.attr.getValue();
        if (value == null || value.equals("") && !this.attr.getSpecified()) {
            return null;
        }
        return value;
    }

    @Override
    public Object getBaseValue() {
        return this.attr;
    }

    @Override
    public boolean isCollection() {
        return false;
    }

    @Override
    public int getLength() {
        return 1;
    }

    @Override
    public Object getImmediateNode() {
        return this.attr;
    }

    @Override
    public boolean isActual() {
        return true;
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    @Override
    public boolean testNode(NodeTest nodeTest) {
        return nodeTest == null || nodeTest instanceof NodeTypeTest && ((NodeTypeTest)nodeTest).getNodeType() == 1;
    }

    @Override
    public void setValue(Object value) {
        this.attr.setValue((String)TypeUtils.convert(value, String.class));
    }

    @Override
    public void remove() {
        this.attr.getOwnerElement().removeAttributeNode(this.attr);
    }

    @Override
    public String asPath() {
        StringBuffer buffer = new StringBuffer();
        if (this.parent != null) {
            buffer.append(this.parent.asPath());
            if (buffer.length() == 0 || buffer.charAt(buffer.length() - 1) != '/') {
                buffer.append('/');
            }
        }
        buffer.append('@');
        buffer.append(this.getName());
        return buffer.toString();
    }

    public int hashCode() {
        return System.identityHashCode(this.attr);
    }

    public boolean equals(Object object) {
        return object == this || object instanceof DOMAttributePointer && this.attr == ((DOMAttributePointer)object).attr;
    }

    @Override
    public int compareChildNodePointers(NodePointer pointer1, NodePointer pointer2) {
        return 0;
    }
}

