/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bsf.util;

import java.beans.PropertyChangeEvent;
import java.util.Vector;
import org.apache.bsf.BSFDeclaredBean;
import org.apache.bsf.BSFEngine;
import org.apache.bsf.BSFException;
import org.apache.bsf.BSFManager;
import org.apache.bsf.util.CodeBuffer;
import org.apache.bsf.util.ObjInfo;
import org.apache.bsf.util.StringUtils;

public abstract class BSFEngineImpl
implements BSFEngine {
    protected BSFManager mgr;
    protected String lang;
    protected Vector declaredBeans;
    protected String classPath;
    protected String tempDir;
    protected ClassLoader classLoader;

    @Override
    public Object apply(String source, int lineNo, int columnNo, Object funcBody, Vector paramNames, Vector arguments) throws BSFException {
        return this.eval(source, lineNo, columnNo, funcBody);
    }

    @Override
    public void compileApply(String source, int lineNo, int columnNo, Object funcBody, Vector paramNames, Vector arguments, CodeBuffer cb) throws BSFException {
        this.compileExpr(source, lineNo, columnNo, funcBody, cb);
    }

    @Override
    public void compileExpr(String source, int lineNo, int columnNo, Object expr, CodeBuffer cb) throws BSFException {
        ObjInfo bsfInfo = cb.getSymbol("bsf");
        if (bsfInfo == null) {
            bsfInfo = new ObjInfo(BSFManager.class, "bsf");
            cb.addFieldDeclaration("org.apache.bsf.BSFManager bsf = new org.apache.bsf.BSFManager();");
            cb.putSymbol("bsf", bsfInfo);
        }
        String evalString = String.valueOf(bsfInfo.objName) + ".eval(\"" + this.lang + "\", ";
        evalString = String.valueOf(evalString) + "request.getRequestURI(), " + lineNo + ", " + columnNo;
        evalString = String.valueOf(evalString) + "," + StringUtils.lineSeparator;
        evalString = String.valueOf(evalString) + StringUtils.getSafeString(expr.toString()) + ")";
        ObjInfo oldRet = cb.getFinalServiceMethodStatement();
        if (oldRet != null && oldRet.isExecutable()) {
            cb.addServiceMethodStatement(String.valueOf(oldRet.objName) + ";");
        }
        cb.setFinalServiceMethodStatement(new ObjInfo(Object.class, evalString));
        cb.addServiceMethodException("org.apache.bsf.BSFException");
    }

    @Override
    public void compileScript(String source, int lineNo, int columnNo, Object script, CodeBuffer cb) throws BSFException {
        ObjInfo bsfInfo = cb.getSymbol("bsf");
        if (bsfInfo == null) {
            bsfInfo = new ObjInfo(BSFManager.class, "bsf");
            cb.addFieldDeclaration("org.apache.bsf.BSFManager bsf = new org.apache.bsf.BSFManager();");
            cb.putSymbol("bsf", bsfInfo);
        }
        String execString = String.valueOf(bsfInfo.objName) + ".exec(\"" + this.lang + "\", ";
        execString = String.valueOf(execString) + "request.getRequestURI(), " + lineNo + ", " + columnNo;
        execString = String.valueOf(execString) + "," + StringUtils.lineSeparator;
        execString = String.valueOf(execString) + StringUtils.getSafeString(script.toString()) + ")";
        ObjInfo oldRet = cb.getFinalServiceMethodStatement();
        if (oldRet != null && oldRet.isExecutable()) {
            cb.addServiceMethodStatement(String.valueOf(oldRet.objName) + ";");
        }
        cb.setFinalServiceMethodStatement(new ObjInfo(Void.TYPE, execString));
        cb.addServiceMethodException("org.apache.bsf.BSFException");
    }

    @Override
    public void declareBean(BSFDeclaredBean bean) throws BSFException {
        throw new BSFException(499, "language " + this.lang + " does not support declareBean(...).");
    }

    @Override
    public void exec(String source, int lineNo, int columnNo, Object script) throws BSFException {
        this.eval(source, lineNo, columnNo, script);
    }

    @Override
    public void iexec(String source, int lineNo, int columnNo, Object script) throws BSFException {
        this.eval(source, lineNo, columnNo, script);
    }

    @Override
    public void initialize(BSFManager mgr, String lang, Vector declaredBeans) throws BSFException {
        this.mgr = mgr;
        this.lang = lang;
        this.declaredBeans = declaredBeans;
        this.classPath = mgr.getClassPath();
        this.tempDir = mgr.getTempDir();
        this.classLoader = mgr.getClassLoader();
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String name = e.getPropertyName();
        Object value = e.getNewValue();
        if (name.equals("classPath")) {
            this.classPath = (String)value;
        } else if (name.equals("tempDir")) {
            this.tempDir = (String)value;
        } else if (name.equals("classLoader")) {
            this.classLoader = (ClassLoader)value;
        }
    }

    @Override
    public void terminate() {
        this.mgr = null;
        this.declaredBeans = null;
        this.classLoader = null;
    }

    @Override
    public void undeclareBean(BSFDeclaredBean bean) throws BSFException {
        throw new BSFException(499, "language " + this.lang + " does not support undeclareBean(...).");
    }
}

