/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.classfile;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.ConstantClass;
import org.apache.bcel.classfile.ConstantNameAndType;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.Visitor;

public class EnclosingMethod
extends Attribute {
    private int classIndex;
    private int methodIndex;

    EnclosingMethod(int nameIndex, int len, DataInput input, ConstantPool cpool) throws IOException {
        this(nameIndex, len, input.readUnsignedShort(), input.readUnsignedShort(), cpool);
    }

    private EnclosingMethod(int nameIndex, int len, int classIdx, int methodIdx, ConstantPool cpool) {
        super((byte)18, nameIndex, len, cpool);
        this.classIndex = classIdx;
        this.methodIndex = methodIdx;
    }

    @Override
    public void accept(Visitor v) {
        v.visitEnclosingMethod(this);
    }

    @Override
    public Attribute copy(ConstantPool constant_pool) {
        return (Attribute)this.clone();
    }

    public final int getEnclosingClassIndex() {
        return this.classIndex;
    }

    public final int getEnclosingMethodIndex() {
        return this.methodIndex;
    }

    public final void setEnclosingClassIndex(int idx) {
        this.classIndex = idx;
    }

    public final void setEnclosingMethodIndex(int idx) {
        this.methodIndex = idx;
    }

    public final ConstantClass getEnclosingClass() {
        ConstantClass c = (ConstantClass)super.getConstantPool().getConstant(this.classIndex, (byte)7);
        return c;
    }

    public final ConstantNameAndType getEnclosingMethod() {
        if (this.methodIndex == 0) {
            return null;
        }
        ConstantNameAndType nat = (ConstantNameAndType)super.getConstantPool().getConstant(this.methodIndex, (byte)12);
        return nat;
    }

    @Override
    public final void dump(DataOutputStream file) throws IOException {
        super.dump(file);
        file.writeShort(this.classIndex);
        file.writeShort(this.methodIndex);
    }
}

