/*
 * Decompiled with CFR 0.152.
 */
package ext.scf8.util;

import ext.base.core.BcStringUtil;
import ext.base.util.BcKanaUtil;
import java.util.List;
import java.util.Locale;

public class KscfKeywordUtil {
    private KscfKeywordUtil() {
    }

    public static String conv(CharSequence src) throws Exception {
        if (src == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < src.length()) {
            char char_ = src.charAt(i);
            if (!BcStringUtil.isControlCharacter(char_) && char_ != ' ') {
                sb.append(char_);
            }
            ++i;
        }
        sb = BcKanaUtil.hanKanaToZenKana(sb, 2);
        sb = BcKanaUtil.hiraganaToZenKana(sb, 2);
        sb = BcKanaUtil.zenKanaToSimple(sb, 2);
        sb = BcStringUtil.toLatinBasic(sb, 2);
        sb = new StringBuilder(sb.toString().toUpperCase(Locale.ENGLISH));
        return sb.toString();
    }

    public static void appenKeyword(StringBuilder sb, CharSequence word) throws Exception {
        if (BcStringUtil.isEmpty(word)) {
            return;
        }
        String words2 = KscfKeywordUtil.conv(word);
        List<String> tokenList = BcStringUtil.stringTokenize((CharSequence)words2, BcStringUtil.SPACE_STR, false, true);
        int i = 0;
        while (i < tokenList.size()) {
            String token = tokenList.get(i);
            int index = sb.indexOf(token);
            if (index < 0) {
                BcStringUtil.appendExceptEmpty(sb, ' ', token);
            }
            ++i;
        }
    }
}

