/*
 * Decompiled with CFR 0.152.
 */
package ext.scf4.fx;

import ext.base.core.BcTimeUtil;
import ext.base.util.BcWords;
import ext.lib.fx.FxPlatform;
import ext.lib.fx.control.FxTextField;
import ext.lib.fx.layout.FxDecoratePane;
import ext.lib.fx.scene.FxScene;
import ext.lib.fx.stage.FxStage;
import ext.lib.fx.util.FxFontUtil;
import ext.lib.fx.util.FxOptionPane;
import ext.lib.fx.util.FxUtil;
import ext.lib.rmi.common.RmiLoggerConstants;
import ext.lib.swg.SwgUtil;
import ext.lib.task.TskAbstractCallable;
import ext.lib.task.TskTaskEventHandler;
import ext.scf4.fx.HfxConsolePane;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javafx.concurrent.Service;
import javafx.concurrent.Task;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.Pane;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import javafx.stage.WindowEvent;

public class HfxTaskMonitorPane
implements TskTaskEventHandler {
    protected TskAbstractCallable task;
    protected FxDecoratePane decoratePane = new FxDecoratePane();
    protected FlowPane bottomPane = new FlowPane();
    protected FxTextField elapsedTimeField = new FxTextField();
    protected FxTextField dataSizeField = new FxTextField();
    protected Pane rightPane = new Pane();
    protected HfxConsolePane consolePane = new HfxConsolePane();
    protected Window ownerWindow;
    protected String title;
    protected Stage stage;
    public long waitMills = 200L;
    boolean b;

    public HfxTaskMonitorPane() throws Exception {
        this.setComponent();
    }

    public TskAbstractCallable getTask() {
        return this.task;
    }

    public void setTask(TskAbstractCallable task) {
        this.task = task;
        task.addTaskEventHandler(this);
    }

    protected void setComponent() throws Exception {
        this.bottomPane.getChildren().add((Object)this.elapsedTimeField);
        this.bottomPane.getChildren().add((Object)this.dataSizeField);
        this.decoratePane.setBottom((Node)this.bottomPane);
        this.decoratePane.setCenter((Node)this.consolePane);
        FxUtil.setFont((Node)this.decoratePane, FxFontUtil.font_11b);
        FxUtil.setEditable((Node)this.decoratePane, false);
    }

    @Override
    public void taskStarted() {
    }

    @Override
    public void taskProgressUpdate(double progress) {
    }

    @Override
    public void taskFinished() {
        FxPlatform.runLater(new Runnable(){

            @Override
            public void run() {
                HfxTaskMonitorPane.this.close();
                String message = null;
                if (message == null) {
                    message = String.valueOf(HfxTaskMonitorPane.this.title) + "\u3092\u5b8c\u4e86\u3057\u307e\u3057\u305f\u3002";
                }
                FxOptionPane.showMessageDialog(HfxTaskMonitorPane.this.ownerWindow, message, BcWords.getInstance().information, 1);
            }
        });
    }

    @Override
    public void taskError(final Throwable throwable) {
        FxPlatform.runLater(new Runnable(){

            @Override
            public void run() {
                HfxTaskMonitorPane.this.close();
                HfxTaskMonitorPane.this.handleException(throwable);
            }
        });
    }

    protected void loopL1() {
        while (!this.b) {
            FxPlatform.runLater(new Runnable(){

                @Override
                public void run() {
                    Object event;
                    HfxTaskMonitorPane.this.b = true;
                    long elapsedTime = System.currentTimeMillis() - HfxTaskMonitorPane.this.task.getTaskContext().startTime;
                    String elapsedTimeStr = BcTimeUtil.getTermString(elapsedTime);
                    HfxTaskMonitorPane.this.dataSizeField.setText(Integer.toString(HfxTaskMonitorPane.this.task.getTaskContext().eventQueue.size()));
                    HfxTaskMonitorPane.this.elapsedTimeField.setText(elapsedTimeStr);
                    while ((event = HfxTaskMonitorPane.this.task.getTaskContext().eventQueue.poll()) != null) {
                        String str = null;
                        if (event instanceof byte[]) {
                            byte[] dataBytes = (byte[])event;
                            str = new String(dataBytes, RmiLoggerConstants.CHARSET);
                        } else {
                            str = event.toString();
                        }
                        HfxTaskMonitorPane.this.consolePane.clear();
                        HfxTaskMonitorPane.this.consolePane.addData(str);
                    }
                    HfxTaskMonitorPane.this.b = false;
                }
            });
            try {
                Thread.sleep(this.waitMills);
                continue;
            }
            catch (Exception ex) {
                this.handleException(ex);
                continue;
            }
            break;
        }
        return;
    }

    protected void close() {
        this.stage.close();
        this.stage = null;
    }

    public void show(String title, Window ownerWindow) throws Exception {
        this.title = title;
        this.ownerWindow = ownerWindow;
        this.stage = new FxStage(StageStyle.UTILITY);
        if (ownerWindow != null) {
            this.stage.initModality(Modality.WINDOW_MODAL);
            this.stage.initOwner(ownerWindow);
        }
        this.stage.setOnShown((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent ev) {
                DrawSerivce drawSerivce = new DrawSerivce();
                drawSerivce.restart();
            }
        });
        FxScene scene = new FxScene((Parent)this.decoratePane);
        this.stage.setScene((Scene)scene);
        this.stage.setWidth(620.0);
        this.stage.setHeight(360.0);
        this.stage.setResizable(true);
        this.stage.setTitle(title);
        this.stage.show();
    }

    protected void handleException(Throwable throwable) {
        SwgUtil.getExceptionHandler().handleException(throwable, this);
    }

    public class DrawSerivce
    extends Service {
        protected Task createTask() {
            return new Task<Void>(){

                protected Void call() throws Exception {
                    ExecutorService executorService = Executors.newCachedThreadPool();
                    Future response = executorService.submit(((DrawSerivce)DrawSerivce.this).HfxTaskMonitorPane.this.task);
                    HfxTaskMonitorPane.this.loopL1();
                    return null;
                }
            };
        }
    }
}

