/*
 * Decompiled with CFR 0.152.
 */
package ext.scf4.fx;

import ext.base.core.BcTimeUtil;
import ext.base.log.BcLogUtil;
import ext.base.util.BcMessageCreator;
import ext.base.util.BcWords;
import ext.lib.fx.FxPlatform;
import ext.lib.fx.layout.FxBorderPane;
import ext.lib.fx.scene.FxScene;
import ext.lib.fx.stage.FxStage;
import ext.lib.fx.util.FxImageHelper;
import ext.lib.fx.util.FxOptionPane;
import ext.lib.poi.PoiCsvWriter4Table;
import ext.lib.poi.PoiExportCondition;
import ext.lib.poi.PoiExportEventHandler;
import ext.lib.swg.SwgUtil;
import ext.libx.fx.FxxProgressIndicationPane;
import ext.scf4.fx.HfxExportConditionPane;
import ext.scf4.fx.HfxExportPane2;
import java.io.File;
import javafx.concurrent.Task;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class HfxExportWizard
implements PoiExportEventHandler {
    FxBorderPane borderPane = new FxBorderPane();
    HfxExportConditionPane exportConditionPane;
    HfxExportPane2 exportPane2;
    PoiExportCondition exportCondition;
    TableColumnModel tableColumnModel;
    TableModel tableModel;
    File destFile;
    PoiCsvWriter4Table csvWriter;
    long startMillis = -1L;
    boolean isExec;
    FxxProgressIndicationPane progressIndicationPane;
    Stage stage;

    public HfxExportWizard() throws Exception {
        this.setCsvWriter(new PoiCsvWriter4Table());
    }

    public void setCondition(PoiExportCondition exportCondition, TableColumnModel tableColumnModel, TableModel tableModel, File destFile) throws Exception {
        this.exportCondition = exportCondition;
        this.tableColumnModel = tableColumnModel;
        this.tableModel = tableModel;
        this.destFile = destFile;
    }

    public void setCsvWriter(PoiCsvWriter4Table csvWriter) throws Exception {
        this.csvWriter = csvWriter;
        csvWriter.addExportEventHandler(this);
    }

    protected void step1() throws Exception {
        if (this.exportConditionPane == null) {
            this.exportConditionPane = new HfxExportConditionPane(this);
        }
        this.exportConditionPane.setDataModel(this.exportCondition);
        this.borderPane.setCenter((Node)this.exportConditionPane);
        this.stage.setTitle(BcWords.getInstance().dataExport);
    }

    protected void step2() throws Exception {
        if (this.exportPane2 == null) {
            this.exportPane2 = new HfxExportPane2(this);
        }
        this.borderPane.setCenter((Node)this.exportPane2);
        this.stage.setTitle(String.valueOf(BcWords.getInstance().dataExport) + " Step-2");
        this.progressIndicationPane = this.exportPane2.crateProgressIndicationPane();
        String msg = BcMessageCreator.getInstance().bindMessage("\u51fa\u529b\u4e2d\u3067\u3059\uff0e\uff0e\uff0e\n \u51fa\u529b\u5148={0}", this.destFile.getPath());
        this.progressIndicationPane.msgLabel.setText(msg);
        InnerTask task = new InnerTask();
        new Thread((Runnable)((Object)task)).start();
    }

    @Override
    public void rowExported(TableModel tableModel, int rowId) throws Exception {
        if (this.startMillis < 0L) {
            this.startMillis = System.currentTimeMillis();
        }
        if (rowId % 10 != 0) {
            return;
        }
        int rowCount = rowId + 1;
        final double progressPer = (double)rowCount / (double)tableModel.getRowCount() * 100.0;
        long period = System.currentTimeMillis() - this.startMillis;
        double restTime = (double)period / progressPer * (100.0 - progressPer);
        String restTimeStr = BcTimeUtil.getTermString((long)restTime);
        FxPlatform.runLater(new Runnable(){

            @Override
            public void run() {
                HfxExportWizard.this.progressIndicationPane.progressIndicator.setProgress(progressPer);
            }
        });
    }

    protected void step_finish() throws Exception {
        this.csvWriter.removeExportEventHandler(this);
        String msg = BcMessageCreator.getInstance().bindMessage("\u51fa\u529b\u3092\u5b8c\u4e86\u3057\u307e\u3057\u305f\u3002\n \u51fa\u529b\u5148={0}", this.destFile.getPath());
        FxOptionPane.showMessageDialog((Window)this.stage, (Object)msg, BcWords.getInstance().information, 1);
        this.isExec = true;
        this.close();
    }

    protected void closeConfirm() {
        this.close();
    }

    protected void close() {
        this.stage.close();
    }

    public boolean show(Window ownerWindow, String title) throws Exception {
        this.isExec = false;
        boolean isNew = false;
        if (this.stage == null) {
            this.stage = new FxStage();
            isNew = true;
        }
        if (ownerWindow != null) {
            this.stage.initModality(Modality.APPLICATION_MODAL);
            this.stage.initOwner(ownerWindow);
        }
        if (!isNew) {
            this.stage.showAndWait();
            return this.isExec;
        }
        this.step1();
        this.stage.setOnShown((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent ev) {
                ev.consume();
                try {
                    HfxExportWizard.this.step1();
                }
                catch (Exception ex) {
                    HfxExportWizard.this.handleException(ex);
                }
            }
        });
        this.stage.setOnCloseRequest((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent ev) {
                ev.consume();
                try {
                    HfxExportWizard.this.close();
                }
                catch (Exception ex) {
                    HfxExportWizard.this.handleException(ex);
                }
            }
        });
        FxScene scene = new FxScene((Parent)this.borderPane);
        this.stage.setScene((Scene)scene);
        this.stage.setWidth(920.0);
        this.stage.setHeight(380.0);
        this.stage.setResizable(false);
        this.stage.setTitle(title);
        this.stage.getIcons().add((Object)FxImageHelper.getImage("export_64x64.png"));
        this.stage.showAndWait();
        return this.isExec;
    }

    public boolean show(Window ownerWindow) throws Exception {
        return this.show(ownerWindow, BcWords.getInstance().dataExport);
    }

    protected void handleException(Throwable throwable) {
        SwgUtil.getExceptionHandler().handleException(throwable, this);
    }

    class InnerTask
    extends Task {
        public Void call() {
            try {
                final TableModel tableModel2 = HfxExportWizard.this.tableModel;
                final TableColumnModel tableColumnModel2 = HfxExportWizard.this.tableColumnModel;
                final File destFile2 = HfxExportWizard.this.destFile;
                FxPlatform.runLater(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            ((InnerTask)InnerTask.this).HfxExportWizard.this.csvWriter.outputTable(((InnerTask)InnerTask.this).HfxExportWizard.this.exportCondition, tableColumnModel2, tableModel2, destFile2);
                            HfxExportWizard.this.step_finish();
                        }
                        catch (Exception ex) {
                            BcLogUtil.error(ex);
                        }
                    }
                });
            }
            catch (Exception ex) {
                BcLogUtil.error(ex);
            }
            return null;
        }
    }
}

