/*
 * Decompiled with CFR 0.152.
 */
package ext.scf4.fx;

import ext.base.core.BcStringUtil;
import ext.base.runtime.BcRuntimeUtil;
import ext.base.util.BcInputValidator;
import ext.base.util.BcMessageCreator;
import ext.base.util.BcResult;
import ext.base.util.BcWords;
import ext.lib.fx.control.FxButton;
import ext.lib.fx.control.FxLabel;
import ext.lib.fx.control.FxTextField;
import ext.lib.fx.layout.FxFlowPane;
import ext.lib.fx.layout.FxNodeUnit;
import ext.lib.fx.util.FxOptionPane;
import ext.lib.fx.util.FxUtil;
import ext.scf4.fx.HfxExportWizard;
import ext.scf4.fx.XdtsWizardPane;
import java.io.File;
import javafx.event.ActionEvent;
import javafx.scene.Node;
import javafx.stage.FileChooser;
import javafx.stage.Window;

class HfxExportPane2
extends XdtsWizardPane {
    FxFlowPane centerPane = new FxFlowPane(11);
    FxTextField filePathField = new FxTextField();
    FxButton fileChooseButton;
    FileChooser fileChooser;
    HfxExportWizard wizard;

    public HfxExportPane2(HfxExportWizard wizard) throws Exception {
        this.fileChooseButton = new FxButton(BcWords.getInstance().browse);
        this.fileChooser = new FileChooser();
        this.wizard = wizard;
    }

    @Override
    public void initComponent() throws Exception {
        super.initComponent();
        this.centerPane.removeAll();
        this.mainDecoratePane.setCenter((Node)this.centerPane);
        String description = "<html><font size=\"4\">\u53d6\u308a\u8fbc\u307f\u5bfe\u8c61\u306e\u30d5\u30a1\u30a4\u30eb\u3092\u8a2d\u5b9a\u3057\u3066\u4e0b\u3055\u3044\u3002<br>\u300c\u6b21\u3078\u300d\u30dc\u30bf\u30f3\u3092\u62bc\u4e0b\u306b\u3088\u308a\u5206\u6790\u3092\u884c\u3044\u307e\u3059\u3002</font></html>";
        this.mainDecoratePane.setDescription(description);
        this.filePathField.setPrefColumnCount(100);
        this.fileChooseButton.setOnAction(this.actionEventHandler);
        FxNodeUnit nodeUnit = new FxNodeUnit((Node)new FxLabel(BcWords.getInstance().file), new Node[]{this.filePathField, this.fileChooseButton});
        this.centerPane.addNodeUnit(nodeUnit);
        this.nextButton.setVisible(true);
        this.cancelButton.setVisible(true);
        FxUtil.defaultInitialize((Node)this);
    }

    protected BcResult validateInputValue() throws Exception {
        BcResult result = new BcResult();
        BcInputValidator inputValidator = BcInputValidator.getInstance();
        return result;
    }

    @Override
    public void actionPerformed(ActionEvent ev) throws Exception {
        super.actionPerformed(ev);
        if (ev.getSource() == this.fileChooseButton) {
            File file;
            if (BcStringUtil.isEmpty(this.filePathField.getText())) {
                this.fileChooser.setInitialDirectory(BcRuntimeUtil.getUserHomeDir());
            } else {
                file = new File(this.filePathField.getText());
                this.fileChooser.setInitialDirectory(file.getParentFile());
                this.fileChooser.setInitialFileName(file.getName());
            }
            file = this.fileChooser.showOpenDialog((Window)this.wizard.stage);
            if (file != null) {
                this.filePathField.setText(file.getPath());
            }
        }
    }

    @Override
    protected void nextButtonAction() throws Exception {
        BcResult result = this.validateInputValue();
        if (result.hasError()) {
            String message = BcMessageCreator.getInstance().createMessage(result.getErrorList());
            FxOptionPane.showMessageDialog((Window)this.wizard.stage, (Object)message, BcWords.getInstance().warning, 2);
            return;
        }
        this.wizard.step1();
    }

    @Override
    protected void cancelButtonAction() throws Exception {
        this.wizard.closeConfirm();
    }
}

