/*
 * Decompiled with CFR 0.152.
 */
package ext.scf4.dao;

import ext.base.core.BcStringUtil;
import ext.base.log.BcLogUtil;
import ext.base.util.BcWarningException;
import ext.lib.datasource.DtsConnectionManager;
import ext.lib.datasource.DtsSession;
import ext.lib.datasource.DtsSessionFactory;
import ext.lib.datasource.DtsSessionFactoryManegaer;
import ext.lib.orm.dao.OrmAbstractDAO;
import ext.lib.orm.persistence.OrmEntityContext;
import ext.lib.orm.persistence.OrmEntityContextManager;
import ext.lib.sql.SqlConnection;
import ext.lib.sql.SqlResultSet;
import ext.lib.sql.SqlStatement;
import ext.lib.sql.SqlUtil;
import ext.lib.sql.context.SqlContext;
import ext.lib.sql.model.SqlSelectSql;
import ext.lib.sql.model.SqlWhereElement;
import ext.scf4.model.ScfLock;
import java.sql.ResultSet;
import java.util.List;

public class ScfLockDAO
extends OrmAbstractDAO<ScfLock> {
    protected DtsConnectionManager connectionManager;
    protected SqlContext sqlContext;

    private ScfLockDAO() {
        super(new ScfLock[0]);
        this.setTableName("frwk_lock");
    }

    public static ScfLockDAO getInstance() {
        return SingletonHolder.instance;
    }

    /*
     * Unable to fully structure code
     */
    public synchronized boolean lock(String lockName, String groupName, Object owner, String note) throws Exception {
        status = -1;
        recordExist = false;
        updateCount = 0;
        dbCon = this.getConnection();
        try {
            block14: {
                block15: {
                    query = "SELECT status FROM " + this.tableName + " WHERE name" + this.sqlContext.toCondition_string("=", lockName) + " FOR UPDATE";
                    stmt = dbCon.createStatement();
                    try {
                        rs = stmt.executeQuery(query);
                        if (rs.next()) {
                            status = rs.getShort(1);
                            recordExist = true;
                        }
                        rs.close();
                    }
                    finally {
                        stmt.close();
                    }
                    if (!recordExist) break block14;
                    if (status != 0) break block15;
                    updateCount = this.updateToLock(dbCon, lockName, groupName, owner, note);
                    ** GOTO lbl31
                }
                return false;
            }
            updateCount = this.insertLock(dbCon, lockName, groupName, owner, note);
lbl31:
            // 2 sources

            dbCon.commit();
        }
        finally {
            this.connectionManager.connectionUsed(dbCon);
        }
        return updateCount > 0;
    }

    public synchronized boolean lock(String lockName, Object owner, String note) throws Exception {
        return this.lock(lockName, null, owner, note);
    }

    public synchronized boolean lock(String lockName, Object owner) throws Exception {
        return this.lock(lockName, owner, null);
    }

    public synchronized boolean lock(String lockName, long intervalMiilis, int tryMax, String groupName, Object owner, String note) throws Exception {
        int tryCnt = 0;
        while (++tryCnt <= tryMax) {
            if (this.lock(lockName, groupName, owner, note)) {
                return true;
            }
            BcLogUtil.debug("\u30ed\u30c3\u30af\u5931\u6557 \uff1a\u30ed\u30c3\u30af\u540d=" + lockName + " \u8a66\u884c\u9593\u9694\uff08\u30df\u30ea\u79d2\uff09=" + intervalMiilis + " \u8a66\u884c\u56de\u6570=" + tryCnt + "/" + tryMax);
            Thread.sleep(intervalMiilis);
        }
        return false;
    }

    public synchronized boolean lock(String lockName, long intervalMiilis, int tryMax, String groupName, Object owner) throws Exception {
        return this.lock(lockName, intervalMiilis, tryMax, groupName, owner, null);
    }

    public synchronized boolean lock(String lockName, Object owner, long intervalMiilis, int tryMax) throws Exception {
        return this.lock(lockName, intervalMiilis, tryMax, null, owner);
    }

    public synchronized boolean lockExeption(String lockName, String groupName, Object owner, String note) throws Exception {
        boolean locked = this.lock(lockName, groupName, owner, note);
        if (!locked) {
            String note2 = this.getNote(lockName);
            throw new BcWarningException(this.lockSFailureMessage(lockName, note2));
        }
        return true;
    }

    public synchronized boolean lockExeption(String lockName, Object owner, String note) throws Exception {
        return this.lockExeption(lockName, null, owner, note);
    }

    public synchronized boolean lockExeption(String lockName, long intervalMiilis, int tryMax, String groupName, Object owner, String note) throws Exception {
        boolean locked = this.lock(lockName, intervalMiilis, tryMax, groupName, owner, note);
        if (!locked) {
            String note2 = this.getNote(lockName);
            throw new BcWarningException(this.lockSFailureMessage(lockName, note2));
        }
        return true;
    }

    public synchronized boolean lockExeption(String lockName, Object owner, String note, long intervalMiilis, int tryMax) throws Exception {
        return this.lockExeption(lockName, intervalMiilis, tryMax, null, owner, note);
    }

    public synchronized boolean lockExeption(String lockName, Object owner, long intervalMiilis, int tryMax) throws Exception {
        return this.lockExeption(lockName, owner, null, intervalMiilis, tryMax);
    }

    public synchronized boolean unlock(String lockName, boolean doDelete) throws Exception {
        int updateCount = 0;
        SqlConnection dbCon = this.getConnection();
        try {
            updateCount = doDelete ? this.deleteLock(dbCon, lockName) : this.updateToUnock(dbCon, lockName);
            dbCon.commit();
        }
        finally {
            this.connectionManager.connectionUsed(dbCon);
        }
        return updateCount > 0;
    }

    public synchronized boolean unlock(String lockName) throws Exception {
        return this.unlock(lockName, false);
    }

    public List<ScfLock> getListByGroupName(DtsSession dtsSession, String groupName, Integer status) throws Exception {
        SqlWhereElement whereElement;
        SqlContext sqlContext = dtsSession.getSqlContext();
        SqlSelectSql selectSql = new SqlSelectSql();
        OrmEntityContext entityContext = OrmEntityContextManager.getInstance().getEntityContext(this.getEntityClass());
        selectSql.getSelectColumnList().addAll(entityContext.getColumnNameList(null));
        selectSql.setFromClause(this.tableName);
        if (!BcStringUtil.isEmpty(groupName)) {
            whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula("group_name" + sqlContext.toCondition_string("=", groupName));
            selectSql.addWhereElement(whereElement);
        }
        if (status != null) {
            whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula("status = " + status);
            selectSql.addWhereElement(whereElement);
        }
        selectSql.getOrderByList().add("group_name");
        selectSql.getOrderByList().add("name");
        String query = sqlContext.buildSelectSql(selectSql);
        return this.getEntityList(dtsSession, query);
    }

    protected int insertLock(SqlConnection dbCon, String lockName, String groupName, Object owner, Object note) throws Exception {
        String query = "INSERT INTO " + this.tableName + " (name, status, start_timestamp, group_name, owner, note_)" + " VALUES (" + this.sqlContext.toSet(lockName) + "," + 1 + "," + this.sqlContext.func_clockTimestamp() + "," + this.sqlContext.toSet(groupName) + "," + this.sqlContext.toSet(BcStringUtil.toString(owner)) + "," + this.sqlContext.toSet(BcStringUtil.toString(note)) + ")";
        return SqlUtil.executeUpdate(dbCon, query);
    }

    protected int updateToLock(SqlConnection dbCon, String lockName, String groupName, Object owner, Object note) throws Exception {
        String query = "UPDATE " + this.tableName + " SET " + "status=" + 1 + ",start_timestamp = " + this.sqlContext.func_clockTimestamp() + ",end_timestamp = Null" + ",group_name = " + this.sqlContext.toSet(groupName) + ",owner = " + this.sqlContext.toSet(BcStringUtil.toString(owner)) + ",note_ = " + this.sqlContext.toSet(BcStringUtil.toString(note)) + " WHERE name" + this.sqlContext.toCondition_string("=", lockName);
        return SqlUtil.executeUpdate(dbCon, query);
    }

    protected int updateToUnock(SqlConnection dbCon, String lockName) throws Exception {
        String query = "UPDATE " + this.tableName + " SET " + "status = " + 0 + ",end_timestamp = " + this.sqlContext.func_clockTimestamp() + " WHERE name" + this.sqlContext.toCondition_string("=", lockName);
        return SqlUtil.executeUpdate(dbCon, query);
    }

    public int deleteLock(SqlConnection dbCon, String lockName) throws Exception {
        String query = "DELETE FROM " + this.tableName + " WHERE name" + this.sqlContext.toCondition_string("=", lockName) + " AND status = " + 1;
        return SqlUtil.executeUpdate(dbCon, query);
    }

    public int delete(SqlConnection dbCon, String lockName) throws Exception {
        String query = "DELETE FROM " + this.tableName + " WHERE name" + this.sqlContext.toCondition_string("=", lockName);
        return SqlUtil.executeUpdate(dbCon, query);
    }

    public String getNote(String lockName) throws Exception {
        String query = "SELECT note_ FROM " + this.tableName + " WHERE name='" + lockName + "'";
        String note = null;
        SqlConnection dbCon = this.getConnection();
        SqlStatement stmt = dbCon.createStatement();
        try {
            ResultSet rs = stmt.executeQuery(query);
            if (rs.next()) {
                note = rs.getString(1);
            }
            rs.close();
        }
        finally {
            stmt.close();
            this.connectionManager.connectionUsed(dbCon);
        }
        return note;
    }

    protected synchronized SqlConnection getConnection() throws Exception {
        SqlConnection dbCon = null;
        if (this.connectionManager != null) {
            dbCon = this.connectionManager.getConnection();
        } else {
            DtsSessionFactory dtsSessionFactoryMain = DtsSessionFactoryManegaer.getInstance().getSessionFactoryMain();
            this.connectionManager = dtsSessionFactoryMain.getConnectionManager();
            this.sqlContext = this.connectionManager.getSqlContext();
            dbCon = this.connectionManager.getConnection();
            dbCon.setOwner(this);
        }
        return dbCon;
    }

    protected String lockSFailureMessage(String lockName, String note) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("\u30ed\u30c3\u30af\u53d6\u5f97\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
        if (!BcStringUtil.isEmpty(note)) {
            sb.append("\u88dc\u8db3\u60c5\u5831:");
            sb.append(note);
        }
        return sb.toString();
    }

    protected String unlockSFailureMessage(CharSequence lockName, CharSequence note) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("\u30ed\u30c3\u30af\u89e3\u9664\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
        if (!BcStringUtil.isEmpty(note)) {
            sb.append("\u88dc\u8db3\u60c5\u5831:");
            sb.append(note);
        }
        return sb.toString();
    }

    public int selectForUpdate(SqlConnection dbCon, String lockName) throws Exception {
        String query = "SELECT name FROM " + this.tableName + " WHERE name" + this.sqlContext.toCondition_string("=", lockName) + " FOR UPDATE NOWAIT";
        int cnt = 0;
        try (SqlStatement stmt = dbCon.createStatement();){
            SqlResultSet rs = stmt.executeQuery(query);
            while (rs.next()) {
                ++cnt;
            }
            rs.close();
        }
        return cnt;
    }

    /* synthetic */ ScfLockDAO(ScfLockDAO scfLockDAO) {
        this();
    }

    private static final class SingletonHolder {
        private static final ScfLockDAO instance = new ScfLockDAO(null);

        private SingletonHolder() {
        }
    }
}

