/*
 * Decompiled with CFR 0.152.
 */
package ext.scf4.client;

import ext.base.log.BcLogUtil;
import ext.base.net.BcAddressPort;
import ext.base.thread.BcThread;
import ext.lib.rmi.client.RmiAgentNet;
import ext.lib.rmi.client.RmiLocalAgent;
import ext.lib.rmi.model.RmiRequest;
import ext.lib.rmi.model.RmiRespons;
import ext.scf.client.ScfClientContainer;
import ext.scf.rmo.ScfLoggerRMO;
import java.io.EOFException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.Socket;
import java.net.SocketException;
import java.rmi.ServerException;
import java.util.concurrent.ConcurrentLinkedQueue;

public abstract class ScfAbstractProcessingMonitor {
    protected String handleId;
    protected int port;
    protected Socket socket;
    protected long startTime;
    protected InvokeThread invokeThread;
    protected ReceiveThread receiveThread;
    protected ConcurrentLinkedQueue<Object> dataQueue = new ConcurrentLinkedQueue();
    protected RmiRequest rmiReq;
    protected RmiRespons rmiRes;

    protected void doConnect() {
        this.startTime = System.currentTimeMillis();
        this.rmiRes = null;
        try {
            this.createLogger();
            RmiLocalAgent localAgent = ScfClientContainer.getInstance().getAgent();
            if (localAgent instanceof RmiAgentNet) {
                RmiAgentNet rmixAgentNet = (RmiAgentNet)localAgent;
                BcAddressPort addressPort = rmixAgentNet.getNetConfig().currentRemoteHostAddressPort;
                this.socket = new Socket(addressPort.address, addressPort.port);
            } else {
                this.socket = new Socket("localhost", this.port);
            }
            BcLogUtil.debug("doConnect:socket=" + this.socket);
            ObjectOutputStream objos = new ObjectOutputStream(this.socket.getOutputStream());
            objos.flush();
            objos.writeObject("logger_100");
            objos.flush();
            objos.reset();
            objos.writeObject(this.handleId);
            objos.flush();
            objos.reset();
            ObjectInputStream objis = new ObjectInputStream(this.socket.getInputStream());
            this.receiveThread = new ReceiveThread();
            this.receiveThread.start(objis);
            this.invokeThread = new InvokeThread();
            this.invokeThread.start();
        }
        catch (Exception ex) {
            BcLogUtil.error(ex);
        }
    }

    protected void createLogger() throws Exception {
        RmiRequest rmiReq = new RmiRequest();
        rmiReq.setClassName(ScfLoggerRMO.class.getName());
        rmiReq.setMethodName(ScfLoggerRMO.Method.createLogger.getMethodName());
        RmiRespons rmiRes = ScfClientContainer.getInstance().getAgent().invoke(rmiReq);
        this.handleId = (String)rmiRes.getData();
        this.port = rmiRes.getDataAsInteger();
    }

    protected void removeLogger() throws Exception {
        RmiRequest rmiReq = new RmiRequest();
        rmiReq.setClassName(ScfLoggerRMO.class.getName());
        rmiReq.setMethodName(ScfLoggerRMO.Method.removeLogger.getMethodName());
        rmiReq.addData(this.handleId);
        RmiRespons rmiRes = ScfClientContainer.getInstance().getAgent().invoke(rmiReq);
    }

    protected void rmoteMethodInvoke() {
        try {
            this.rmiReq.putData((Object)"lhId", this.handleId);
            this.rmiRes = ScfClientContainer.getInstance().getAgent().invoke(this.rmiReq);
            this.destruct();
            BcLogUtil.debug("run:rmiRes.getStatusId=" + this.rmiRes.getStatusId());
            switch (this.rmiRes.getStatusId()) {
                case 1: {
                    this.successed();
                    break;
                }
                default: {
                    throw new Exception("Invarid rmiRes.statusId=" + this.rmiRes.getStatusId());
                }
            }
        }
        catch (ServerException ex) {
            Throwable causeThrowable = ex.getCause();
            try {
                this.destruct();
            }
            catch (Exception ex2) {
                BcLogUtil.error(ex2);
            }
            this.exceptionOccurred(causeThrowable);
        }
        catch (Exception ex) {
            try {
                this.destruct();
            }
            catch (Exception ex2) {
                BcLogUtil.error(ex2);
            }
            this.exceptionOccurred(ex);
        }
    }

    public void dataReceived(int command, Object data) throws Exception {
        this.dataQueue.add(data);
    }

    protected void successed() {
    }

    protected void exceptionOccurred(Throwable throwable) {
    }

    protected void destruct() throws Exception {
        if (this.socket.isConnected()) {
            try {
                this.socket.close();
            }
            catch (Exception ex) {
                BcLogUtil.error(ex);
            }
        }
        if (this.handleId != null) {
            try {
                this.removeLogger();
                this.handleId = null;
            }
            catch (Exception ex) {
                BcLogUtil.error(ex);
            }
        }
        if (this.receiveThread != null) {
            this.receiveThread.stopThread();
            this.receiveThread = null;
        }
        this.invokeThread = null;
    }

    public RmiRequest getRequest() {
        return this.rmiReq;
    }

    public void setRequest(RmiRequest rmiReq) {
        this.rmiReq = rmiReq;
    }

    public RmiRespons getResponse() throws Exception {
        return this.rmiRes;
    }

    class InvokeThread
    extends BcThread {
        public InvokeThread() throws Exception {
            this.setPriority(1);
        }

        @Override
        protected void run2() throws Exception {
            ScfAbstractProcessingMonitor.this.rmoteMethodInvoke();
            this.stopThread();
        }
    }

    class ReceiveThread
    extends BcThread {
        protected ObjectInputStream objis;

        public ReceiveThread() throws Exception {
            this.setPriority(1);
        }

        public void start(ObjectInputStream objis) throws Exception {
            this.objis = objis;
            this.startThread();
        }

        @Override
        protected void run2() throws Exception {
            try {
                int command = (Integer)this.objis.readObject();
                byte[] dataBytes = (byte[])this.objis.readObject();
                ScfAbstractProcessingMonitor.this.dataReceived(command, dataBytes);
            }
            catch (EOFException command) {
            }
            catch (SocketException command) {
            }
            catch (Exception ex) {
                BcLogUtil.error(ex);
                this.stopThread();
                try {
                    this.objis.close();
                }
                catch (Exception ex2) {
                    BcLogUtil.error(ex2);
                }
            }
        }
    }
}

