/*
 * Decompiled with CFR 0.152.
 */
package ext.scf3.rmo;

import ext.appfw.common.AfbApplication;
import ext.base.core.BcNumberUtil;
import ext.base.core.BcStringUtil;
import ext.base.log.BcLogUtil;
import ext.base.xml.BcXmlUtil;
import ext.lib.rmi.model.RmiRmoArgument;
import ext.lib.rmi.rmo.RmiAbstractRMO;
import java.io.File;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class ScfClientUpdatorRMO
extends RmiAbstractRMO {
    public static final String METHOD_getNewClientJarFilePath = "getNewClientJarFilePath";

    public ScfClientUpdatorRMO() {
        this.objectPoolEnabled = true;
    }

    public void getNewClientJarFilePath(RmiRmoArgument rmoArg) throws Exception {
        String moduleName = rmoArg.getRequest().getDataAsString();
        String moduleVersion = rmoArg.getRequest().getDataAsString();
        BcLogUtil.debug("getNewClientJarFilePath:moduleName=" + moduleName);
        BcLogUtil.debug("getNewClientJarFilePath:moduleVersion=" + moduleVersion);
        Document bootConfig = AfbApplication.getInstance().getBootConfig();
        Node node_moduleUpdateService = BcXmlUtil.getNode(bootConfig, "moduleUpdateService");
        String name = BcXmlUtil.getAttribute(node_moduleUpdateService, "name");
        BcLogUtil.debug("name=" + name);
        Node node_approval = BcXmlUtil.getNode(node_moduleUpdateService, "approval");
        int approvalStart = Integer.parseInt(BcXmlUtil.getAttribute(node_approval, "start"));
        int approvalEnd = Integer.parseInt(BcXmlUtil.getAttribute(node_approval, "end"));
        BcLogUtil.debug("approvalStart=" + approvalStart + " approvalEnd=" + approvalEnd);
        Node node_update = BcXmlUtil.getNode(node_moduleUpdateService, "update");
        int updateStart = Integer.parseInt(BcXmlUtil.getAttribute(node_update, "start"));
        int updateEnd = Integer.parseInt(BcXmlUtil.getAttribute(node_update, "end"));
        String filePath = BcXmlUtil.getAttribute(node_update, "filePath");
        BcLogUtil.debug("updateStart=" + updateStart + " updateEnd=" + updateEnd + " filePath=" + filePath);
        if (BcStringUtil.equals(moduleName, name)) {
            String tmp = BcStringUtil.replace((CharSequence)moduleVersion, ".", "").toString();
            int clientBinaryVersionNum = BcNumberUtil.parseInteger(tmp);
            if (clientBinaryVersionNum >= approvalStart && clientBinaryVersionNum <= approvalEnd) {
                rmoArg.getRespons().addData(1);
            } else if (clientBinaryVersionNum >= updateStart && clientBinaryVersionNum <= updateEnd) {
                rmoArg.getRespons().addData(2);
                String filePath2 = AfbApplication.getInstance().toReal(filePath);
                BcLogUtil.debug("filePath2=" + filePath2);
                File file = new File(filePath2);
                rmoArg.getRespons().addData(1);
                rmoArg.getRespons().addData(file);
                rmoArg.getRespons().addData(file.length());
            } else {
                rmoArg.getRespons().addData(9);
            }
        } else {
            rmoArg.getRespons().addData(9);
        }
    }
}

